/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Line;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;

public interface DataLine
extends Line {
    public void drain();

    public void flush();

    public void start();

    public void stop();

    public boolean isRunning();

    public boolean isActive();

    public AudioFormat getFormat();

    public int getBufferSize();

    public int available();

    public int getFramePosition();

    public long getMicrosecondPosition();

    public float getLevel();

    public static class Info
    extends Line.Info {
        private AudioFormat[] EMPTY_AUDIO_FORMAT_ARRAY = new AudioFormat[0];
        private List<AudioFormat> m_audioFormats;
        private int m_nMinBufferSize;
        private int m_nMaxBufferSize;

        public Info(Class lineClass, AudioFormat[] aAudioFormats, int nMinBufferSize, int nMaxBufferSize) {
            super(lineClass);
            this.m_audioFormats = Arrays.asList(aAudioFormats);
            this.m_nMinBufferSize = nMinBufferSize;
            this.m_nMaxBufferSize = nMaxBufferSize;
        }

        public Info(Class lineClass, AudioFormat audioFormat, int nBufferSize) {
            this(lineClass, new AudioFormat[]{audioFormat}, nBufferSize, nBufferSize);
        }

        public Info(Class lineClass, AudioFormat audioFormat) {
            this(lineClass, audioFormat, -1);
        }

        public AudioFormat[] getFormats() {
            return this.m_audioFormats.toArray(this.EMPTY_AUDIO_FORMAT_ARRAY);
        }

        public boolean isFormatSupported(AudioFormat audioFormat) {
            for (AudioFormat format : this.m_audioFormats) {
                if (!AudioFormats.matches(format, audioFormat)) continue;
                return true;
            }
            return false;
        }

        public int getMinBufferSize() {
            return this.m_nMinBufferSize;
        }

        public int getMaxBufferSize() {
            return this.m_nMaxBufferSize;
        }

        public boolean matches(Line.Info info) {
            if (TDebug.TraceDataLine) {
                TDebug.out(">DataLine.Info.matches(): called");
                TDebug.out("DataLine.Info.matches(): own info: " + this.toString());
                TDebug.out("DataLine.Info.matches(): test info: " + info.toString());
            }
            if (!super.matches(info)) {
                if (TDebug.TraceDataLine) {
                    TDebug.out("<DataLine.Info.matches(): super.matches() does not match()");
                }
                return false;
            }
            if (!(info instanceof Info)) {
                return false;
            }
            Info dataLineInfo = (Info)info;
            if (this.getMinBufferSize() != -1 && dataLineInfo.getMinBufferSize() != -1 && this.getMinBufferSize() < dataLineInfo.getMinBufferSize() || this.getMaxBufferSize() != -1 && dataLineInfo.getMaxBufferSize() != -1 && this.getMaxBufferSize() > dataLineInfo.getMaxBufferSize()) {
                if (TDebug.TraceDataLine) {
                    TDebug.out("<DataLine.Info.matches(): buffer sizes do not match");
                }
                return false;
            }
            for (AudioFormat format : this.m_audioFormats) {
                if (TDebug.TraceDataLine) {
                    TDebug.out("checking if supported: " + format);
                }
                if (dataLineInfo.isFormatSupported(format)) continue;
                if (TDebug.TraceDataLine) {
                    TDebug.out("< format doesn't match");
                }
                return false;
            }
            if (TDebug.TraceDataLine) {
                TDebug.out("< matches: true");
            }
            return true;
        }

        public String toString() {
            AudioFormat[] aFormats = this.getFormats();
            String strFormats = "formats:\n";
            for (int i = 0; i < aFormats.length; ++i) {
                strFormats = strFormats + aFormats[i].toString() + "\n";
            }
            return super.toString() + strFormats + "minBufferSize=" + this.getMinBufferSize() + " maxBufferSize=" + this.getMaxBufferSize();
        }
    }
}

