/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.events;

import com.animania.api.interfaces.IAnimaniaAnimal;
import com.animania.api.interfaces.ISleeping;
import com.animania.common.handler.ItemHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.config.AnimaniaConfig;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="animania")
public class EntityEventHandler {
    @SubscribeEvent
    public static void onEntityTakeDamage(LivingHurtEvent event) {
        float amount = event.getAmount();
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entity instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)entity;
            if (source == DamageSource.field_76379_h && animal.func_110167_bD()) {
                event.setAmount(amount * AnimaniaConfig.gameRules.fallDamageReduceMultiplier);
                animal.field_70143_R = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHit(LivingAttackEvent event) {
        ISleeping isleeping;
        EntityLivingBase animal;
        float amount = event.getAmount();
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entity instanceof EntityLivingBase && entity instanceof IAnimaniaAnimal && (animal = entity).func_184218_aH()) {
            event.setCanceled(true);
        }
        if (entity instanceof ISleeping && (isleeping = (ISleeping)entity).getSleeping()) {
            if (source == DamageSource.field_76366_f) {
                event.setCanceled(true);
            }
            ((ISleeping)entity).setSleeping(false);
        }
        if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70906_o()) {
            ((EntityTameable)entity).func_70904_g(false);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            ItemHandler.regItemEggColors(event.getWorld());
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        ISleeping isleeping;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof ISleeping && entity instanceof EntityAnimal && (isleeping = (ISleeping)entity).getSleeping() && ((EntityAnimal)entity).func_110167_bD()) {
            isleeping.setSleeping(false);
        }
    }

    @SubscribeEvent
    public static void removeSquidSpawns(LivingSpawnEvent.CheckSpawn event) {
        BlockPos pos = new BlockPos((double)event.getX(), (double)event.getY(), (double)event.getZ());
        World worldIn = event.getWorld();
        Biome biome = event.getWorld().func_180494_b(pos);
        if (!(AnimaniaConfig.gameRules.spawnFreshWaterSquids || !event.getEntity().getClass().equals(EntitySquid.class) || worldIn.field_72995_K || AnimaniaHelper.hasBiomeType(biome, BiomeDictionary.Type.OCEAN) || event.getEntity().func_145818_k_())) {
            event.setResult(Event.Result.DENY);
        }
    }
}

