/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfig;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.ChapterImage;
import com.feed_the_beast.ftbquests.quest.theme.property.ThemeProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ButtonChapterImage
extends Button {
    public GuiQuestTree treeGui;
    public ChapterImage chapterImage;

    public ButtonChapterImage(Panel panel, ChapterImage i) {
        super(panel, "", i.image);
        this.treeGui = (GuiQuestTree)panel.getGui();
        this.setSize(20, 20);
        this.chapterImage = i;
    }

    public boolean checkMouseOver(int mouseX, int mouseY) {
        if (this.treeGui.questPanel.mouseOverQuest != null || this.treeGui.movingObjects || this.treeGui.viewQuestPanel.isMouseOver() || this.treeGui.chapterHoverPanel.isMouseOverAnyWidget()) {
            return false;
        }
        if (this.chapterImage.click.isEmpty() && !this.treeGui.file.canEdit()) {
            return false;
        }
        return super.checkMouseOver(mouseX, mouseY);
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver() && (!this.chapterImage.click.isEmpty() || this.treeGui.file.canEdit() && !button.isLeft())) {
            this.onClicked(button);
            return true;
        }
        return false;
    }

    public void onClicked(MouseButton button) {
        if (this.treeGui.file.canEdit() && button.isRight()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), (Icon)ThemeProperties.EDIT_ICON.get(), () -> {
                ConfigGroup group = ConfigGroup.newGroup((String)"ftbquests");
                this.chapterImage.getConfig(group.getGroup("chapter").getGroup("image"));
                new GuiEditConfig(group, (group1, sender) -> new MessageEditObject(this.chapterImage.chapter).sendToServer()).openGui();
            }));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"gui.move", (Object[])new Object[0]), (Icon)ThemeProperties.MOVE_UP_ICON.get(this.chapterImage.chapter), () -> {
                this.treeGui.movingObjects = true;
                this.treeGui.selectedObjects.clear();
                this.treeGui.toggleSelected(this.chapterImage);
            }){

                public void addMouseOverText(List<String> list) {
                    list.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"ftbquests.gui.move_tooltip", (Object[])new Object[0]));
                }
            });
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), (Icon)ThemeProperties.DELETE_ICON.get(), () -> {
                this.chapterImage.chapter.images.remove(this.chapterImage);
                new MessageEditObject(this.chapterImage.chapter).sendToServer();
            }).setYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{this.chapterImage.image.toString()})));
            this.getGui().openContextMenu(contextMenu);
        } else if (button.isLeft()) {
            if (!this.chapterImage.click.isEmpty()) {
                GuiHelper.playClickSound();
                this.handleClick(this.chapterImage.click);
            }
        } else if (this.treeGui.file.canEdit() && button.isMiddle()) {
            if (!this.treeGui.selectedObjects.contains(this.chapterImage)) {
                this.treeGui.toggleSelected(this.chapterImage);
            }
            this.treeGui.movingObjects = true;
        }
    }

    public void addMouseOverText(List<String> list) {
        for (String s : this.chapterImage.hover) {
            if (s.startsWith("{") && s.endsWith("}")) {
                list.add(I18n.func_135052_a((String)s.substring(1, s.length() - 1), (Object[])new Object[0]));
                continue;
            }
            list.add(s);
        }
    }

    public boolean shouldDraw() {
        return false;
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((int)((double)x + (double)w / 2.0)), (float)((int)((double)y + (double)h / 2.0)), (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.chapterImage.rotation), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179139_a((double)((double)w / 2.0), (double)((double)h / 2.0), (double)1.0);
        this.chapterImage.image.draw(-1, -1, 2, 2);
        GlStateManager.func_179121_F();
    }
}

