/*
 * Decompiled with CFR 0.152.
 */
package weather2.util;

import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.forge.CoroUtil;
import CoroUtil.util.CoroUtilFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import modconfig.ConfigMod;
import modconfig.IConfigCategory;
import modconfig.ModConfigData;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.lang3.StringUtils;
import weather2.ServerTickHandler;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.config.ConfigParticle;
import weather2.config.ConfigSand;
import weather2.config.ConfigSnow;
import weather2.config.ConfigStorm;
import weather2.config.ConfigTornado;

public class WeatherUtilConfig {
    public static List<Integer> listDimensionsWeather = new ArrayList<Integer>();
    public static List<Integer> listDimensionsClouds = new ArrayList<Integer>();
    public static List<Integer> listDimensionsStorms = new ArrayList<Integer>();
    public static List<Integer> listDimensionsWindEffects = new ArrayList<Integer>();
    public static int CMD_BTN_PERF_STORM = 2;
    public static int CMD_BTN_PERF_NATURE = 3;
    public static int CMD_BTN_PERF_PRECIPRATE = 12;
    public static int CMD_BTN_PERF_SHADERS_PARTICLE = 18;
    public static int CMD_BTN_PERF_SHADERS_FOLIAGE = 19;
    public static int CMD_BTN_COMP_STORM = 4;
    public static int CMD_BTN_COMP_LOCK = 5;
    public static int CMD_BTN_COMP_PARTICLEPRECIP = 6;
    public static int CMD_BTN_COMP_SNOWFALLBLOCKS = 7;
    public static int CMD_BTN_COMP_LEAFFALLBLOCKS = 8;
    public static int CMD_BTN_COMP_PARTICLESNOMODS = 13;
    public static int CMD_BTN_PREF_RATEOFSTORM = 9;
    public static int CMD_BTN_PREF_CHANCEOFSTORM = 14;
    public static int CMD_BTN_PREF_CHANCEOFRAIN = 10;
    public static int CMD_BTN_PREF_BLOCKDESTRUCTION = 11;
    public static int CMD_BTN_PREF_TORNADOANDCYCLONES = 15;
    public static int CMD_BTN_PREF_SANDSTORMS = 16;
    public static int CMD_BTN_PREF_GLOBALRATE = 17;
    public static int CMD_BTN_HIGHEST_ID = 19;
    public static List<String> LIST_RATES = new ArrayList<String>(Arrays.asList("High", "Medium", "Low"));
    public static List<String> LIST_RATES2 = new ArrayList<String>(Arrays.asList("High", "Medium", "Low", "None"));
    public static List<String> LIST_TOGGLE = new ArrayList<String>(Arrays.asList("Off", "On"));
    public static List<String> LIST_CHANCE = new ArrayList<String>(Arrays.asList("1/2 Day", "1 Day", "2 Days", "3 Days", "4 Days", "5 Days", "6 Days", "7 Days", "8 Days", "9 Days", "10 Days", "Never"));
    public static List<String> LIST_STORMSWHEN = new ArrayList<String>(Arrays.asList("Local Biomes", "Global Overcast"));
    public static List<String> LIST_LOCK = new ArrayList<String>(Arrays.asList("Always Off", "Always On", "Don't lock"));
    public static List<String> LIST_GLOBALRATE = new ArrayList<String>(Arrays.asList("Rand player", "Each player"));
    public static List<Integer> listSettingsClient = new ArrayList<Integer>();
    public static List<Integer> listSettingsServer = new ArrayList<Integer>();
    public static NBTTagCompound nbtClientCache = new NBTTagCompound();
    public static NBTTagCompound nbtServerData = new NBTTagCompound();
    public static NBTTagCompound nbtClientData = new NBTTagCompound();

    public static void processNBTToModConfigClient() {
        WeatherUtilConfig.nbtSaveDataClient();
        Weather.dbg("processNBTToModConfigClient");
        Weather.dbg("nbtClientData: " + nbtClientData);
        String modIDWeather = Weather.configMisc.getRegistryName();
        String modIDCoroUtil = CoroUtil.configCoroUtil.getRegistryName();
        try {
            int val;
            if (nbtClientData.func_74764_b("btn_" + CMD_BTN_COMP_PARTICLEPRECIP)) {
                ConfigParticle.Particle_RainSnow = LIST_TOGGLE.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_COMP_PARTICLEPRECIP)).equalsIgnoreCase("on");
            }
            if (nbtClientData.func_74764_b("btn_" + CMD_BTN_PERF_STORM)) {
                if (LIST_RATES.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_STORM)).equalsIgnoreCase("high")) {
                    ConfigMisc.Cloud_ParticleSpawnDelay = 0;
                    ConfigStorm.Storm_ParticleSpawnDelay = 1;
                    ConfigParticle.Sandstorm_Particle_Debris_effect_rate = 1.0;
                    ConfigParticle.Sandstorm_Particle_Dust_effect_rate = 1.0;
                } else if (LIST_RATES.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_STORM)).equalsIgnoreCase("medium")) {
                    ConfigMisc.Cloud_ParticleSpawnDelay = 2;
                    ConfigStorm.Storm_ParticleSpawnDelay = 3;
                    ConfigParticle.Sandstorm_Particle_Debris_effect_rate = 0.6;
                    ConfigParticle.Sandstorm_Particle_Dust_effect_rate = 0.6;
                } else if (LIST_RATES.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_STORM)).equalsIgnoreCase("low")) {
                    ConfigMisc.Cloud_ParticleSpawnDelay = 5;
                    ConfigStorm.Storm_ParticleSpawnDelay = 5;
                    ConfigParticle.Sandstorm_Particle_Debris_effect_rate = 0.3;
                    ConfigParticle.Sandstorm_Particle_Dust_effect_rate = 0.3;
                }
            }
            if (nbtClientData.func_74764_b("btn_" + CMD_BTN_PERF_NATURE)) {
                if (LIST_RATES2.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_NATURE)).equalsIgnoreCase("high")) {
                    ConfigParticle.Wind_Particle_effect_rate = 1.0;
                } else if (LIST_RATES2.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_NATURE)).equalsIgnoreCase("medium")) {
                    ConfigParticle.Wind_Particle_effect_rate = 0.7f;
                } else if (LIST_RATES2.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_NATURE)).equalsIgnoreCase("low")) {
                    ConfigParticle.Wind_Particle_effect_rate = 0.3f;
                } else if (LIST_RATES2.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_NATURE)).equalsIgnoreCase("none")) {
                    ConfigParticle.Wind_Particle_effect_rate = 0.0;
                }
            }
            if (nbtClientData.func_74764_b("btn_" + CMD_BTN_PERF_PRECIPRATE)) {
                if (LIST_RATES2.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_PRECIPRATE)).equalsIgnoreCase("high")) {
                    ConfigParticle.Precipitation_Particle_effect_rate = 1.0;
                } else if (LIST_RATES2.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_PRECIPRATE)).equalsIgnoreCase("medium")) {
                    ConfigParticle.Precipitation_Particle_effect_rate = 0.7;
                } else if (LIST_RATES2.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_PRECIPRATE)).equalsIgnoreCase("low")) {
                    ConfigParticle.Precipitation_Particle_effect_rate = 0.3;
                } else if (LIST_RATES2.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_PRECIPRATE)).equalsIgnoreCase("none")) {
                    ConfigParticle.Precipitation_Particle_effect_rate = 0.0;
                }
            }
            if (nbtClientData.func_74764_b("btn_" + CMD_BTN_COMP_PARTICLESNOMODS)) {
                ConfigParticle.Particle_VanillaAndWeatherOnly = LIST_TOGGLE.get(nbtClientData.func_74762_e("btn_" + CMD_BTN_COMP_PARTICLESNOMODS)).equalsIgnoreCase("on");
            }
            if (nbtClientData.func_74764_b("btn_" + CMD_BTN_PERF_SHADERS_PARTICLE)) {
                val = nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_SHADERS_PARTICLE);
                if (val == 0) {
                    ConfigCoroUtil.particleShaders = false;
                } else if (val == 1) {
                    ConfigCoroUtil.particleShaders = true;
                }
            }
            if (nbtClientData.func_74764_b("btn_" + CMD_BTN_PERF_SHADERS_FOLIAGE)) {
                val = nbtClientData.func_74762_e("btn_" + CMD_BTN_PERF_SHADERS_FOLIAGE);
                if (val == 0) {
                    ConfigCoroUtil.foliageShaders = false;
                } else if (val == 1) {
                    ConfigCoroUtil.foliageShaders = true;
                }
            }
            NBTTagCompound nbtDims = nbtClientData.func_74775_l("dimData");
            Weather.dbg("before cl: " + listDimensionsWindEffects);
            for (String tagName : nbtDims.func_150296_c()) {
                NBTTagInt entry = (NBTTagInt)nbtDims.func_74781_a(tagName);
                String[] vals = tagName.split("_");
                if (!vals[2].equals("3")) continue;
                int dimID = Integer.parseInt(vals[1]);
                if (entry.func_150287_d() == 0) {
                    if (!listDimensionsWindEffects.contains(dimID)) continue;
                    listDimensionsWindEffects.remove((Object)dimID);
                    continue;
                }
                if (listDimensionsWindEffects.contains(dimID)) continue;
                listDimensionsWindEffects.add(dimID);
            }
            Weather.dbg("after cl: " + listDimensionsWindEffects);
            WeatherUtilConfig.processListsReverse();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ConfigMod.forceSaveAllFilesFromRuntimeSettings();
    }

    public static void processNBTToModConfigServer() {
        WeatherUtilConfig.nbtSaveDataServer();
        Weather.dbg("processNBTToModConfigServer");
        Weather.dbg("nbtServerData: " + nbtServerData);
        try {
            int val;
            if (nbtServerData.func_74764_b("btn_" + CMD_BTN_COMP_STORM)) {
                ConfigMisc.overcastMode = LIST_STORMSWHEN.get(nbtServerData.func_74762_e("btn_" + CMD_BTN_COMP_STORM)).equalsIgnoreCase("Global Overcast");
            }
            if (nbtServerData.func_74764_b("btn_" + CMD_BTN_COMP_LOCK)) {
                val = nbtServerData.func_74762_e("btn_" + CMD_BTN_COMP_LOCK);
                ConfigMisc.lockServerWeatherMode = val == 1 ? 1 : (val == 0 ? 0 : -1);
            }
            if (nbtServerData.func_74764_b("btn_" + CMD_BTN_COMP_SNOWFALLBLOCKS)) {
                val = nbtServerData.func_74762_e("btn_" + CMD_BTN_COMP_SNOWFALLBLOCKS) == 1 ? 1 : 0;
                ConfigSnow.Snow_PerformSnowfall = val;
            }
            if (nbtServerData.func_74764_b("btn_" + CMD_BTN_PREF_RATEOFSTORM)) {
                int numDays = nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_RATEOFSTORM);
                if (numDays == 0) {
                    ConfigStorm.Player_Storm_Deadly_TimeBetweenInTicks = 12000;
                    ConfigStorm.Server_Storm_Deadly_TimeBetweenInTicks = 12000;
                } else if (numDays == 11) {
                    ConfigStorm.Player_Storm_Deadly_TimeBetweenInTicks = -1;
                    ConfigStorm.Server_Storm_Deadly_TimeBetweenInTicks = -1;
                } else {
                    ConfigStorm.Player_Storm_Deadly_TimeBetweenInTicks = 24000 * numDays;
                    ConfigStorm.Server_Storm_Deadly_TimeBetweenInTicks = 24000 * numDays;
                }
            }
            if (nbtServerData.func_74764_b("btn_" + CMD_BTN_PREF_CHANCEOFSTORM)) {
                if (LIST_RATES2.get(nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_CHANCEOFSTORM)).equalsIgnoreCase("high")) {
                    ConfigStorm.Player_Storm_Deadly_OddsTo1 = 30;
                    ConfigStorm.Server_Storm_Deadly_OddsTo1 = 30;
                } else if (LIST_RATES2.get(nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_CHANCEOFSTORM)).equalsIgnoreCase("medium")) {
                    ConfigStorm.Player_Storm_Deadly_OddsTo1 = 45;
                    ConfigStorm.Server_Storm_Deadly_OddsTo1 = 45;
                } else if (LIST_RATES2.get(nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_CHANCEOFSTORM)).equalsIgnoreCase("low")) {
                    ConfigStorm.Player_Storm_Deadly_OddsTo1 = 60;
                    ConfigStorm.Server_Storm_Deadly_OddsTo1 = 60;
                }
            }
            if (nbtServerData.func_74764_b("btn_" + CMD_BTN_PREF_CHANCEOFRAIN)) {
                if (LIST_RATES2.get(nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_CHANCEOFRAIN)).equalsIgnoreCase("high")) {
                    ConfigStorm.Storm_Rain_OddsTo1 = 150;
                    ConfigStorm.Storm_Rain_Overcast_OddsTo1 = ConfigStorm.Storm_Rain_OddsTo1 / 3;
                } else if (LIST_RATES2.get(nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_CHANCEOFRAIN)).equalsIgnoreCase("medium")) {
                    ConfigStorm.Storm_Rain_OddsTo1 = 300;
                    ConfigStorm.Storm_Rain_Overcast_OddsTo1 = ConfigStorm.Storm_Rain_OddsTo1 / 3;
                } else if (LIST_RATES2.get(nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_CHANCEOFRAIN)).equalsIgnoreCase("low")) {
                    ConfigStorm.Storm_Rain_OddsTo1 = 450;
                    ConfigStorm.Storm_Rain_Overcast_OddsTo1 = ConfigStorm.Storm_Rain_OddsTo1 / 3;
                } else if (LIST_RATES2.get(nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_CHANCEOFRAIN)).equalsIgnoreCase("none")) {
                    ConfigStorm.Storm_Rain_OddsTo1 = -1;
                    ConfigStorm.Storm_Rain_Overcast_OddsTo1 = -1;
                }
            }
            if (nbtServerData.func_74764_b("btn_" + CMD_BTN_PREF_BLOCKDESTRUCTION)) {
                ConfigTornado.Storm_Tornado_grabBlocks = LIST_TOGGLE.get(nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_BLOCKDESTRUCTION)).equalsIgnoreCase("on");
            }
            if (nbtServerData.func_74764_b("btn_" + CMD_BTN_PREF_TORNADOANDCYCLONES)) {
                ConfigTornado.Storm_NoTornadosOrCyclones = LIST_TOGGLE.get(nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_TORNADOANDCYCLONES)).equalsIgnoreCase("off");
            }
            if (nbtServerData.func_74764_b("btn_" + CMD_BTN_PREF_SANDSTORMS)) {
                ConfigSand.Storm_NoSandstorms = LIST_TOGGLE.get(nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_SANDSTORMS)).equalsIgnoreCase("off");
            }
            if (nbtServerData.func_74764_b("btn_" + CMD_BTN_PREF_GLOBALRATE)) {
                ConfigStorm.Server_Storm_Deadly_UseGlobalRate = nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_GLOBALRATE) == 0;
                ConfigSand.Sandstorm_UseGlobalServerRate = nbtServerData.func_74762_e("btn_" + CMD_BTN_PREF_GLOBALRATE) == 0;
            }
            NBTTagCompound nbtDims = nbtServerData.func_74775_l("dimData");
            Weather.dbg("before: " + listDimensionsWeather);
            for (String tagName : nbtDims.func_150296_c()) {
                int dimID;
                NBTTagInt entry = (NBTTagInt)nbtDims.func_74781_a(tagName);
                String[] vals = tagName.split("_");
                if (vals[2].equals("0")) {
                    dimID = Integer.parseInt(vals[1]);
                    if (entry.func_150287_d() == 0) {
                        if (listDimensionsWeather.contains(dimID)) {
                            listDimensionsWeather.remove(dimID);
                        }
                    } else if (!listDimensionsWeather.contains(dimID)) {
                        listDimensionsWeather.add(dimID);
                    }
                } else if (vals[2].equals("1")) {
                    dimID = Integer.parseInt(vals[1]);
                    if (entry.func_150287_d() == 0) {
                        if (listDimensionsClouds.contains(dimID)) {
                            listDimensionsClouds.remove(dimID);
                        }
                    } else if (!listDimensionsClouds.contains(dimID)) {
                        listDimensionsClouds.add(dimID);
                    }
                } else if (vals[2].equals("2")) {
                    dimID = Integer.parseInt(vals[1]);
                    if (entry.func_150287_d() == 0) {
                        if (listDimensionsStorms.contains(dimID)) {
                            listDimensionsStorms.remove(dimID);
                        }
                    } else if (!listDimensionsStorms.contains(dimID)) {
                        listDimensionsStorms.add(dimID);
                    }
                }
                Weather.dbg("dim: " + vals[1] + " - setting ID: " + vals[2] + " - data: " + entry.func_150287_d());
            }
            Weather.dbg("after: " + listDimensionsWeather);
            WeatherUtilConfig.processListsReverse();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (IConfigCategory config : Weather.listConfigs) {
            ((ModConfigData)ConfigMod.configLookup.get(config.getRegistryName())).writeConfigFile(true);
        }
        ServerTickHandler.syncServerConfigToClient();
    }

    public static void nbtReceiveClientData(NBTTagCompound parNBT) {
        for (int i = 0; i <= CMD_BTN_HIGHEST_ID; ++i) {
            if (!parNBT.func_74764_b("btn_" + i)) continue;
            nbtServerData.func_74768_a("btn_" + i, parNBT.func_74762_e("btn_" + i));
        }
        nbtServerData.func_74782_a("dimData", (NBTBase)parNBT.func_74775_l("dimData"));
        WeatherUtilConfig.processNBTToModConfigServer();
    }

    public static void nbtReceiveServerDataForCache(NBTTagCompound parNBT) {
        nbtClientCache = parNBT;
        Weather.dbg("nbtClientCache: " + nbtServerData);
    }

    public static void nbtSaveDataClient() {
        WeatherUtilConfig.nbtWriteNBTToDisk(nbtClientData, true);
    }

    public static void nbtSaveDataServer() {
        WeatherUtilConfig.nbtWriteNBTToDisk(nbtServerData, false);
    }

    public static void nbtLoadDataAll() {
        WeatherUtilConfig.nbtLoadDataClient();
        WeatherUtilConfig.nbtLoadDataServer();
    }

    public static void nbtLoadDataClient() {
        nbtClientData = WeatherUtilConfig.nbtReadNBTFromDisk(true);
    }

    public static void nbtLoadDataServer() {
        nbtServerData = WeatherUtilConfig.nbtReadNBTFromDisk(false);
    }

    public static NBTTagCompound createNBTDimensionListing() {
        NBTTagCompound data = new NBTTagCompound();
        WorldServer[] worlds = DimensionManager.getWorlds();
        for (int i = 0; i < worlds.length; ++i) {
            NBTTagCompound nbtDim = new NBTTagCompound();
            int dimID = worlds[i].field_73011_w.getDimension();
            nbtDim.func_74768_a("ID", dimID);
            nbtDim.func_74778_a("name", worlds[i].field_73011_w.func_186058_p().func_186065_b());
            nbtDim.func_74757_a("weather", listDimensionsWeather.contains(dimID));
            nbtDim.func_74757_a("clouds", listDimensionsClouds.contains(dimID));
            nbtDim.func_74757_a("storms", listDimensionsStorms.contains(dimID));
            data.func_74782_a("" + dimID, (NBTBase)nbtDim);
        }
        return data;
    }

    public static void processLists() {
        listDimensionsWeather = WeatherUtilConfig.parseList(ConfigMisc.Dimension_List_Weather);
        listDimensionsClouds = WeatherUtilConfig.parseList(ConfigMisc.Dimension_List_Clouds);
        listDimensionsStorms = WeatherUtilConfig.parseList(ConfigMisc.Dimension_List_Storms);
        listDimensionsWindEffects = WeatherUtilConfig.parseList(ConfigMisc.Dimension_List_WindEffects);
    }

    public static void processListsReverse() {
        ConfigMisc.Dimension_List_Weather = StringUtils.join(listDimensionsWeather, (String)" ");
        ConfigMisc.Dimension_List_Clouds = StringUtils.join(listDimensionsClouds, (String)" ");
        ConfigMisc.Dimension_List_Storms = StringUtils.join(listDimensionsStorms, (String)" ");
        ConfigMisc.Dimension_List_WindEffects = StringUtils.join(listDimensionsWindEffects, (String)" ");
    }

    public static List<Integer> parseList(String parData) {
        String listStr = parData;
        listStr = listStr.replace(",", " ");
        String[] arrStr = listStr.split(" ");
        Integer[] arrInt = new Integer[arrStr.length];
        for (int i = 0; i < arrStr.length; ++i) {
            try {
                arrInt[i] = Integer.parseInt(arrStr[i]);
                continue;
            }
            catch (Exception ex) {
                arrInt[i] = -999999;
            }
        }
        return new ArrayList<Integer>(Arrays.asList(arrInt));
    }

    public static void nbtWriteNBTToDisk(NBTTagCompound parData, boolean saveForClient) {
        String fileURL = null;
        fileURL = saveForClient ? CoroUtilFile.getMinecraftSaveFolderPath() + File.separator + "Weather2" + File.separator + "EZGUIConfigClientData.dat" : CoroUtilFile.getMinecraftSaveFolderPath() + File.separator + "Weather2" + File.separator + "EZGUIConfigServerData.dat";
        try {
            FileOutputStream fos = new FileOutputStream(fileURL);
            CompressedStreamTools.func_74799_a((NBTTagCompound)parData, (OutputStream)fos);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Weather.dbg("Error writing Weather2 EZ GUI data");
        }
    }

    public static NBTTagCompound nbtReadNBTFromDisk(boolean loadForClient) {
        NBTTagCompound data = new NBTTagCompound();
        String fileURL = null;
        fileURL = loadForClient ? CoroUtilFile.getMinecraftSaveFolderPath() + File.separator + "Weather2" + File.separator + "EZGUIConfigClientData.dat" : CoroUtilFile.getMinecraftSaveFolderPath() + File.separator + "Weather2" + File.separator + "EZGUIConfigServerData.dat";
        try {
            if (new File(fileURL).exists()) {
                data = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(fileURL));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Weather.dbg("Error reading Weather2 EZ GUI data");
        }
        return data;
    }

    public static void setOvercastModeServerSide(boolean val) {
        nbtServerData.func_74768_a("btn_" + CMD_BTN_COMP_STORM, val ? 1 : 0);
        WeatherUtilConfig.nbtSaveDataServer();
    }

    static {
        listSettingsClient.add(CMD_BTN_PERF_STORM);
        listSettingsClient.add(CMD_BTN_PERF_NATURE);
        listSettingsClient.add(CMD_BTN_COMP_PARTICLEPRECIP);
        listSettingsClient.add(CMD_BTN_PERF_PRECIPRATE);
        listSettingsClient.add(CMD_BTN_COMP_PARTICLESNOMODS);
        listSettingsClient.add(CMD_BTN_PERF_SHADERS_PARTICLE);
        listSettingsClient.add(CMD_BTN_PERF_SHADERS_FOLIAGE);
        listSettingsServer.add(CMD_BTN_COMP_STORM);
        listSettingsServer.add(CMD_BTN_COMP_LOCK);
        listSettingsServer.add(CMD_BTN_COMP_SNOWFALLBLOCKS);
        listSettingsServer.add(CMD_BTN_COMP_LEAFFALLBLOCKS);
        listSettingsServer.add(CMD_BTN_PREF_RATEOFSTORM);
        listSettingsServer.add(CMD_BTN_PREF_CHANCEOFSTORM);
        listSettingsServer.add(CMD_BTN_PREF_CHANCEOFRAIN);
        listSettingsServer.add(CMD_BTN_PREF_BLOCKDESTRUCTION);
        listSettingsServer.add(CMD_BTN_PREF_TORNADOANDCYCLONES);
        listSettingsServer.add(CMD_BTN_PREF_SANDSTORMS);
        listSettingsServer.add(CMD_BTN_PREF_GLOBALRATE);
    }
}

