/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.network;

import com.paneedah.weaponlib.vehicle.jimphysics.solver.VehiclePhysicsSolver;
import io.netty.buffer.ByteBuf;
import io.redstudioragnarok.redcore.vectors.Vector3D;
import java.io.IOException;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.util.math.Vec3d;

public class VehiclePhysSerializer {
    public VehiclePhysicsSolver solver;
    public double synthAccelFor;
    public double synthAccelSide;
    public Vec3d velocity;
    public static final DataSerializer<VehiclePhysSerializer> SERIALIZER = new DataSerializer<VehiclePhysSerializer>(){

        public void write(PacketBuffer buf, VehiclePhysSerializer value) {
            VehiclePhysicsSolver s = value.solver;
            buf.writeDouble(s.synthAccelFor);
            buf.writeDouble(s.synthAccelSide);
            new Vector3D(s.getVelocityVector()).write((ByteBuf)buf);
        }

        public VehiclePhysSerializer read(PacketBuffer buf) throws IOException {
            VehiclePhysSerializer vps = new VehiclePhysSerializer();
            double synthAccelFor = buf.readDouble();
            double synthAccelSide = buf.readDouble();
            Vector3D v = new Vector3D();
            v.read((ByteBuf)buf);
            vps.setData(synthAccelFor, synthAccelSide, v.toVec3d());
            return vps;
        }

        public DataParameter<VehiclePhysSerializer> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public VehiclePhysSerializer copyValue(VehiclePhysSerializer value) {
            return value;
        }
    };

    public VehiclePhysSerializer() {
    }

    public VehiclePhysSerializer(VehiclePhysicsSolver solver) {
        this.solver = solver;
    }

    public void setSolver(VehiclePhysicsSolver solver) {
        this.solver = solver;
    }

    public void setData(double synthAccelFor, double synthAccelSide, Vec3d velocity) {
        this.synthAccelFor = synthAccelFor;
        this.synthAccelSide = synthAccelSide;
        this.velocity = velocity;
    }

    public void updateSolver(VehiclePhysicsSolver solver) {
        solver.synthAccelFor = this.synthAccelFor;
        solver.synthAccelSide = this.synthAccelSide;
        solver.velocity = this.velocity;
    }
}

