/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.jimphysics.engines;

import com.paneedah.weaponlib.vehicle.collisions.InertiaKit;

public class FlywheelSolver {
    public double mass = 0.0;
    public double radius = 0.0;
    public double inertia = 0.0;
    public double angularVelocity = 0.0;
    public double angularAcceleration = 0.0;

    public FlywheelSolver(double mass, double radius, double thickness) {
        this.mass = mass;
        this.radius = radius;
        this.inertia = InertiaKit.inertiaTensorCylinder((float)((float)mass), (float)((float)radius), (float)((float)thickness)).m22;
    }

    public void applyTorque(double torque) {
        double a = torque / this.inertia;
        this.angularAcceleration += a;
    }

    public void determineResistiveForces() {
        this.angularAcceleration += 5000.5 * Math.signum(this.angularVelocity * -1.0);
    }

    public void doPhysics(double dt) {
        this.determineResistiveForces();
        this.angularVelocity += this.angularAcceleration * dt;
        this.angularAcceleration = 0.0;
    }

    public double getRPM() {
        return this.angularVelocity / (Math.PI * 2) * 60.0;
    }
}

