/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.Pair;
import com.paneedah.weaponlib.vehicle.jimphysics.Transmission;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class GearShiftPattern {
    private LinkedList<Branch> pattern = new LinkedList();

    public GearShiftPattern withNormalBranch(int g1, int g2) {
        Vec3d v1 = new Vec3d(0.5, 0.0, 1.0 * (double)this.pattern.size());
        Vec3d v2 = new Vec3d(-0.5, 0.0, 1.0 * (double)this.pattern.size());
        return this.withBranch(v1, g1, v2, g2);
    }

    public GearShiftPattern withBranch(Vec3d v1, int g1, Vec3d v2, int g2) {
        Node n1 = new Node(v1, g1);
        Node n2 = new Node(v2, g2);
        Branch b = new Branch(n1, n2, this.pattern.size());
        this.pattern.add(b);
        return this;
    }

    public static double interpValue(double oldVal, double newVal, double step) {
        return oldVal + (newVal - oldVal) * step;
    }

    public static Vec3d interpVec3d(Vec3d one, Vec3d two, double step) {
        return new Vec3d(GearShiftPattern.interpValue(one.field_72450_a, two.field_72450_a, step), GearShiftPattern.interpValue(one.field_72448_b, two.field_72448_b, step), GearShiftPattern.interpValue(one.field_72449_c, two.field_72449_c, step));
    }

    public void drawCenteredString(FontRenderer fontRendererIn, String text, double x, double y, int color, double scale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        fontRendererIn.func_175063_a(text, (float)(-fontRendererIn.func_78256_a(text) / 2), 0.0f, color);
        GL11.glPopMatrix();
    }

    public void renderPattern(Color c, double x, double y) {
        Vec3d m;
        Vec3d bG;
        Vec3d tG;
        GL11.glPushMatrix();
        float red = (float)c.getRed() / 255.0f;
        float blue = (float)c.getBlue() / 255.0f;
        float green = (float)c.getGreen() / 255.0f;
        float alpha = (float)c.getAlpha() / 255.0f;
        GL11.glLineWidth((float)3.0f);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (Branch b : this.pattern) {
            tG = b.topGear.pos;
            bG = b.bottomGear.pos;
            m = b.median;
            bb.func_181662_b(m.field_72449_c, -m.field_72450_a, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            bb.func_181662_b(tG.field_72449_c, -tG.field_72450_a, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            bb.func_181662_b(bG.field_72449_c, -bG.field_72450_a, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            bb.func_181662_b(m.field_72449_c, -m.field_72450_a, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        }
        t.func_78381_a();
        GL11.glPopMatrix();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        for (Branch b : this.pattern) {
            tG = b.topGear.pos;
            bG = b.bottomGear.pos;
            m = b.median;
            this.drawCenteredString(ClientProxy.MC.field_71466_p, "" + b.topGear.gear, tG.field_72449_c, -tG.field_72450_a * 1.5, 16768345, 0.02);
            this.drawCenteredString(ClientProxy.MC.field_71466_p, "" + b.bottomGear.gear, bG.field_72449_c, -bG.field_72450_a * 1.1, 16768345, 0.02);
        }
    }

    public Vec3d quickDoAnimation(Transmission transmission) {
        return this.doAnimation(transmission.shiftTimer, transmission.maxShiftTime, transmission.startGear, transmission.targetGear);
    }

    public Vec3d doAnimation(int curVal, int maxVal, int startGear, int targetGear) {
        curVal = Math.min(maxVal, curVal);
        ArrayList<Vec3d> transitions = this.getTransitions(startGear, targetGear);
        double globalStep = curVal;
        double timePerTransiton = (double)maxVal / ((double)transitions.size() - 1.0);
        ArrayList<Pair<Double, Vec3d>> realTimeTransitions = new ArrayList<Pair<Double, Vec3d>>();
        double lastTime = 0.0;
        double totalPauseTime = 5.0;
        for (int x = 0; x < transitions.size(); ++x) {
            if (x != 0) {
                realTimeTransitions.add(new Pair<Double, Vec3d>(lastTime + (timePerTransiton * (double)x - totalPauseTime), transitions.get(x)));
            }
            realTimeTransitions.add(new Pair<Double, Vec3d>(lastTime + timePerTransiton * (double)x, transitions.get(x)));
            if (x != 0) continue;
            realTimeTransitions.add(new Pair<Double, Vec3d>(lastTime + (timePerTransiton * (double)x + totalPauseTime), transitions.get(x)));
        }
        Vec3d f = null;
        Vec3d s = null;
        double fB = 0.0;
        double sB = 0.0;
        for (int x = 0; x < realTimeTransitions.size() - 1; ++x) {
            double firstBound = (Double)((Pair)realTimeTransitions.get(x)).getFirst();
            double secondBound = (Double)((Pair)realTimeTransitions.get(x + 1)).getFirst();
            if (!(globalStep <= secondBound) || !(globalStep >= firstBound)) continue;
            f = (Vec3d)((Pair)realTimeTransitions.get(x)).getSecond();
            s = (Vec3d)((Pair)realTimeTransitions.get(x + 1)).getSecond();
            fB = firstBound;
            sB = secondBound;
            break;
        }
        double step = (globalStep - fB) / (sB - fB);
        return GearShiftPattern.interpVec3d(f, s, step);
    }

    public ArrayList<Vec3d> getTransitions(int startGear, int endGear) {
        ArrayList<Vec3d> transitions = new ArrayList<Vec3d>();
        boolean shouldReverse = false;
        if (startGear > endGear) {
            shouldReverse = true;
        }
        if (shouldReverse) {
            int tempGear = startGear;
            startGear = endGear;
            endGear = tempGear;
        }
        for (int x = 0; x < this.pattern.size(); ++x) {
            Branch b = this.pattern.get(x);
            if (b.containsGear(startGear) && b.containsGear(endGear)) {
                transitions.add(b.getGearPos(startGear));
                transitions.add(b.median);
                transitions.add(b.getGearPos(endGear));
                break;
            }
            if (b.containsGear(startGear)) {
                transitions.add(b.getGearPos(startGear));
                transitions.add(b.median);
                continue;
            }
            if (!b.containsGear(endGear)) continue;
            transitions.add(b.median);
            transitions.add(b.getGearPos(endGear));
        }
        if (shouldReverse) {
            Collections.reverse(transitions);
        }
        return transitions;
    }

    class Node {
        Vec3d pos;
        int gear;

        public Node(Vec3d pos, int gear) {
            this.pos = pos;
            this.gear = gear;
        }
    }

    class Branch {
        Node topGear;
        Node bottomGear;
        Vec3d median;

        public Branch(Node t, Node b, int i) {
            this.topGear = t;
            this.bottomGear = b;
            this.median = this.topGear.pos.func_178787_e(this.bottomGear.pos).func_186678_a(0.5);
        }

        public boolean containsGear(int g) {
            return this.topGear.gear == g || this.bottomGear.gear == g;
        }

        public Vec3d getGearPos(int g) {
            if (this.topGear.gear == g) {
                return this.topGear.pos;
            }
            if (this.bottomGear.gear == g) {
                return this.bottomGear.pos;
            }
            return null;
        }
    }
}

