/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render.shells;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.model.Bullet556;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class ShellParticleSimulator {
    public static final double CHUNK_SIZE = 1.5;
    private static final int SHELL_LIFE = 1024;
    private static final double RESTITUTION = 0.3;
    public static Bullet556 bulletModel = new Bullet556();

    public void update(ArrayList<Shell> shells, double dt) {
        shells.removeIf(s -> s.shouldDie());
        for (int i = 0; i < shells.size(); ++i) {
            Shell sh = shells.get(i);
            if (sh.getAge() > 1024) {
                sh.kill();
            }
            sh.ageShell();
            if (sh.isSleeping()) continue;
            Vector3d tempPos = (Vector3d)sh.pos.clone();
            Vector3d tempRot = (Vector3d)sh.rot.clone();
            sh.pos.x += sh.pos.x - sh.prevPos.x;
            sh.pos.y += sh.pos.y - sh.prevPos.y - 0.05;
            sh.pos.z += sh.pos.z - sh.prevPos.z;
            double decay = 0.9;
            sh.rot.x += (sh.rot.x - sh.prevRot.x) * decay;
            sh.rot.y += (sh.rot.y - sh.prevRot.y) * decay;
            sh.rot.z += (sh.rot.z - sh.prevRot.z) * decay;
            sh.prevPos = tempPos;
            sh.prevRot = tempRot;
            boolean bounceY = false;
            boolean bounceHorizontal = false;
            Vec3d next = new Vec3d(sh.pos.x + (sh.pos.x - sh.prevPos.x) * 0.5, sh.pos.y + (sh.pos.y - sh.prevPos.y) * 0.5, sh.pos.z + (sh.pos.z - sh.prevPos.z) * 0.5);
            RayTraceResult rtr = ClientProxy.MC.field_71441_e.func_147447_a(new Vec3d(sh.prevPos.x, sh.prevPos.y, sh.prevPos.z), new Vec3d(sh.pos.x, sh.pos.y, sh.pos.z), false, true, false);
            if (rtr != null) {
                EnumFacing side = rtr.field_178784_b;
                if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH || side == EnumFacing.WEST || side == EnumFacing.EAST) {
                    bounceHorizontal = true;
                } else {
                    bounceY = true;
                }
            }
            double elas = 0.9;
            double friction = 0.3;
            if (bounceY) {
                double tempY = sh.prevPos.y;
                sh.prevPos.y = sh.pos.y;
                sh.pos.y += (tempY - sh.prevPos.y) * elas;
                sh.prevPos.y += (sh.pos.y - sh.prevPos.y) * 0.7;
                sh.pos.x += (sh.prevPos.x - sh.pos.x) * friction;
                sh.pos.z += (sh.prevPos.z - sh.pos.z) * friction;
            }
            double hitRotationImpulse = 500.0;
            if (bounceHorizontal) {
                double tempX = sh.prevPos.x;
                double tempZ = sh.prevPos.z;
                sh.prevPos.x = sh.pos.x;
                sh.prevPos.z = sh.pos.z;
                sh.pos.x += (tempX - sh.prevPos.x) * elas;
                sh.pos.z += (tempZ - sh.prevPos.z) * elas;
                sh.prevRot.x += Math.random() * hitRotationImpulse - hitRotationImpulse / 2.0;
                sh.prevRot.z += Math.random() * hitRotationImpulse - hitRotationImpulse / 2.0;
            }
            AxisAlignedBB box = new AxisAlignedBB(-0.1, -0.1, -0.1, 0.1, 0.1, 0.1);
            box = box.func_186662_g(0.1);
            box = box.func_191194_a(new Vec3d(sh.pos.x, sh.pos.y - 0.9, sh.pos.z));
            List list = ClientProxy.MC.field_71441_e.func_184144_a(null, box);
            Vec3d separationVector = Vec3d.field_186680_a;
            double penetrationDepth = Double.MIN_VALUE;
            double zOffset = sh.pos.z;
            double xOffset = sh.pos.x;
            for (AxisAlignedBB b : list) {
                zOffset = b.func_72322_c(box, zOffset);
                xOffset = b.func_72316_a(box, xOffset);
                if (!(sh.pos.y < b.field_72337_e)) continue;
                sh.pos.y = b.field_72337_e;
                Vector3d tempVector = (Vector3d)sh.pos.clone();
                tempVector.sub((Tuple3d)sh.prevPos);
                Vector3d tempRotat = (Vector3d)sh.rot.clone();
                tempRotat.sub((Tuple3d)sh.prevRot);
                if (tempVector.lengthSquared() < 0.05 && tempRotat.lengthSquared() < 0.05) {
                    sh.prevPos = sh.pos;
                    sh.prevRot = sh.rot;
                    sh.sleep();
                    continue;
                }
                double verticalVelocity = sh.pos.y - sh.prevPos.y;
                if (!(Math.abs(verticalVelocity) < 2.0)) continue;
                double in = 0.1;
                sh.prevRot.x += (sh.rot.x - sh.prevRot.x) * 0.5;
                sh.prevRot.y += (sh.rot.y - sh.prevRot.y) * 0.5;
                sh.prevRot.z += (sh.rot.z - sh.prevRot.z) * 0.5;
            }
            sh.pos.x = xOffset;
            sh.pos.z = zOffset;
        }
    }

    public static class Shell {
        private boolean sleeping;
        private Type type;
        public int age = 0;
        public boolean onGround = false;
        public boolean shouldDie = false;
        public Vector3d pos = new Vector3d(0.0, 0.0, 0.0);
        public Vector3d prevPos = new Vector3d(0.0, 0.0, 0.0);
        public Vector3d velocity = new Vector3d(0.0, 0.0, 0.0);
        public Vector3d prevRot = new Vector3d(0.0, 0.0, 0.0);
        public Vector3d rot = new Vector3d(0.0, 0.0, 0.0);
        private double height;

        public Shell(Type type, Vec3d pos, Vec3d rot, Vec3d velocity) {
            this.setType(type);
            this.pos = new Vector3d(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            this.pos.x += velocity.field_72450_a;
            this.pos.y += velocity.field_72448_b;
            this.pos.z += velocity.field_72449_c;
            this.prevRot = this.rot = new Vector3d(rot.field_72450_a, rot.field_72448_b, rot.field_72449_c);
            this.prevPos = new Vector3d(this.pos.x - velocity.field_72450_a, this.pos.y - velocity.field_72448_b, this.pos.z - velocity.field_72449_c);
            this.prevRot = new Vector3d(Math.random() * 100.0, Math.random() * 100.0, Math.random() * 100.0);
        }

        public Type getType() {
            return this.type;
        }

        public boolean isSleeping() {
            return this.sleeping;
        }

        public void sleep() {
            this.sleeping = true;
        }

        public void wake() {
            this.sleeping = false;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void ageShell() {
            ++this.age;
        }

        public int getAge() {
            return this.age;
        }

        public void setHeight(double height) {
            this.height = height;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean shouldDie() {
            return this.shouldDie;
        }

        public void kill() {
            this.setShouldDie(true);
        }

        public void setShouldDie(boolean state) {
            this.shouldDie = state;
        }

        public static enum Type {
            SHOTGUN,
            ASSAULT,
            PISTOL;

        }
    }
}

