/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.AttachmentContainer;
import com.paneedah.weaponlib.ClientEventHandler;
import com.paneedah.weaponlib.CompatibleAttachment;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.animation.gui.AnimationGUI;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.render.Shaders;
import com.paneedah.weaponlib.render.SpriteSheetTools;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class MuzzleFlashRenderer {
    public static ResourceLocation FLASH_SHEET = new ResourceLocation("mwc:textures/flashes/sheet.png");
    private static boolean assignedParameters = false;
    private static final int SPRITE_SIZE = 256;
    private static final int SHEET_WIDTH = 1536;
    private static final int SHEET_HEIGHT = 768;

    public static int getRandomNumberBetween(int min, int max) {
        return (int)Math.floor(Math.random() * (double)(max - min + 1) + (double)min);
    }

    public static void renderFlash(int entityID, ItemStack weaponItemStack, boolean bloom) {
        Weapon weapon = (Weapon)weaponItemStack.func_77973_b();
        if (!(ClientProxy.MC.field_71441_e.func_73045_a(entityID) instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)ClientProxy.MC.field_71441_e.func_73045_a(entityID);
        boolean isPetalFlash = weapon.hasFlashPedals();
        boolean isSuppressedFlash = false;
        for (CompatibleAttachment<? extends AttachmentContainer> c : weapon.getActiveAttachments((EntityLivingBase)player, weaponItemStack)) {
            if (c.getAttachment().getCategory() != AttachmentCategory.SILENCER) continue;
            isSuppressedFlash = true;
        }
        boolean shouldRenderCrossplane = ClientProxy.MC.field_71441_e.func_73045_a(entityID) != ClientProxy.MC.field_71439_g || ClientProxy.MC.field_71474_y.field_74320_O != 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179129_p();
        GlStateManager.func_179126_j();
        Vec3d muzzle = weapon.getMuzzlePosition();
        if (AnimationModeProcessor.getInstance().getFPSMode() && AnimationGUI.getInstance().forceFlash.isState()) {
            muzzle = ClientEventHandler.debugmuzzlePosition;
        }
        GlStateManager.func_179137_b((double)muzzle.field_72450_a, (double)muzzle.field_72448_b, (double)muzzle.field_72449_c);
        ClientProxy.MC.func_110434_K().func_110577_a(FLASH_SHEET);
        if (!assignedParameters) {
            assignedParameters = true;
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
        if (ModernConfigManager.enableAllShaders && ModernConfigManager.enableFlashShaders) {
            Shaders.flash.use();
            Shaders.flash.uniform1i("bloom", bloom ? 1 : 0);
        }
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        double size = Math.random() * 0.5 + 0.5;
        int mainBodyID = 0;
        mainBodyID = isPetalFlash ? MuzzleFlashRenderer.getRandomNumberBetween(0, 2) : MuzzleFlashRenderer.getRandomNumberBetween(3, 5);
        SpriteSheetTools.Sprite mainFlashBody = SpriteSheetTools.getSquareSprite(mainBodyID, 256.0, 1536.0, 768.0);
        if (shouldRenderCrossplane && !isSuppressedFlash) {
            int sideID = MuzzleFlashRenderer.getRandomNumberBetween(6, 9);
            SpriteSheetTools.Sprite spriteSide = SpriteSheetTools.getRectSprite(sideID, 256.0, 512.0, 1536.0, 768.0, true);
            MuzzleFlashRenderer.renderCrossPlane(spriteSide, 1.2, 0.0, 0.0, size, size);
        }
        if (isSuppressedFlash) {
            SpriteSheetTools.Sprite suppressedSprite = SpriteSheetTools.getSquareSprite(0, 512.0, 512.0, 512.0);
            ClientProxy.MC.func_110434_K().func_110577_a(new ResourceLocation("mwc:textures/flashes/supre.png"));
            MuzzleFlashRenderer.renderFlippedCrossPlane(suppressedSprite, 1.0, 0.0, 0.0, size / 2.0, size / 2.0);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (!isSuppressedFlash) {
            if (shouldRenderCrossplane) {
                for (double d = 0.0; d <= 2.0; d += 1.0) {
                    double descalar = 1.0 - d / 2.0;
                    MuzzleFlashRenderer.renderFlatPlane(mainFlashBody, 0.0, -d, 0.0, size * descalar, size * descalar);
                }
            } else {
                MuzzleFlashRenderer.renderFlatPlane(mainFlashBody, 0.0, 0.0, 0.0, size, size);
            }
        }
        if (ModernConfigManager.enableAllShaders && ModernConfigManager.enableFlashShaders) {
            Shaders.flash.release();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179089_o();
        GlStateManager.func_179118_c();
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    public static void renderFlatPlane(SpriteSheetTools.Sprite sprite, double x, double y, double z, double width, double height) {
        GlStateManager.func_179094_E();
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bb.func_181662_b(-width + x, y, -height + z).func_187315_a(sprite.getMinU(), sprite.getMinV()).func_181675_d();
        bb.func_181662_b(width + x, y, -height + z).func_187315_a(sprite.getMinU(), sprite.getMaxV()).func_181675_d();
        bb.func_181662_b(width + x, y, height + z).func_187315_a(sprite.getMaxU(), sprite.getMaxV()).func_181675_d();
        bb.func_181662_b(-width + x, y, height + z).func_187315_a(sprite.getMaxU(), sprite.getMinV()).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void renderFlippedCrossPlane(SpriteSheetTools.Sprite sprite, double x, double y, double z, double sizeX, double sizeY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bb.func_181662_b(-sizeY + x, y, -sizeX + z).func_187315_a(sprite.getMinU(), sprite.getMaxV()).func_181675_d();
        bb.func_181662_b(sizeY + x, y, -sizeX + z).func_187315_a(sprite.getMaxU(), sprite.getMaxV()).func_181675_d();
        bb.func_181662_b(sizeY + x, y, sizeX + z).func_187315_a(sprite.getMaxU(), sprite.getMinV()).func_181675_d();
        bb.func_181662_b(-sizeY + x, y, sizeX + z).func_187315_a(sprite.getMinU(), sprite.getMinV()).func_181675_d();
        bb.func_181662_b(-sizeY + x, -sizeX + y, z).func_187315_a(sprite.getMinU(), sprite.getMinV()).func_181675_d();
        bb.func_181662_b(sizeY + x, -sizeX + y, z).func_187315_a(sprite.getMaxU(), sprite.getMinV()).func_181675_d();
        bb.func_181662_b(sizeY + x, sizeX + y, z).func_187315_a(sprite.getMaxU(), sprite.getMaxV()).func_181675_d();
        bb.func_181662_b(-sizeY + x, sizeX + y, z).func_187315_a(sprite.getMinU(), sprite.getMaxV()).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void renderCrossPlane(SpriteSheetTools.Sprite sprite, double x, double y, double z, double sizeX, double sizeY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bb.func_181662_b(-sizeY + x, y, -sizeX + z).func_187315_a(sprite.getMaxU(), sprite.getMinV()).func_181675_d();
        bb.func_181662_b(sizeY + x, y, -sizeX + z).func_187315_a(sprite.getMaxU(), sprite.getMaxV()).func_181675_d();
        bb.func_181662_b(sizeY + x, y, sizeX + z).func_187315_a(sprite.getMinU(), sprite.getMaxV()).func_181675_d();
        bb.func_181662_b(-sizeY + x, y, sizeX + z).func_187315_a(sprite.getMinU(), sprite.getMinV()).func_181675_d();
        bb.func_181662_b(-sizeY + x, -sizeX + y, z).func_187315_a(sprite.getMinU(), sprite.getMinV()).func_181675_d();
        bb.func_181662_b(sizeY + x, -sizeX + y, z).func_187315_a(sprite.getMinU(), sprite.getMaxV()).func_181675_d();
        bb.func_181662_b(sizeY + x, sizeX + y, z).func_187315_a(sprite.getMaxU(), sprite.getMaxV()).func_181675_d();
        bb.func_181662_b(-sizeY + x, sizeX + y, z).func_187315_a(sprite.getMaxU(), sprite.getMinV()).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179121_F();
    }
}

