/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.AttachmentContainer;
import com.paneedah.weaponlib.CompatibleAttachment;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.UniversalSoundLookup;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.WeaponAttachmentAspect;
import com.paneedah.weaponlib.command.DebugCommand;
import com.paneedah.weaponlib.config.BalancePackManager;
import com.paneedah.weaponlib.render.RadarChart;
import com.paneedah.weaponlib.render.gui.GUIRenderHelper;
import java.util.ArrayList;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Mouse;

public class ModificationGUI {
    public static ModificationGUI instance = new ModificationGUI();
    private static ArrayList<ModificationTab> tabList = new ArrayList();
    private static final ResourceLocation MODIFICATION_GUI_TEXTURES = new ResourceLocation("mwc:textures/gui/modificationguisheet.png");
    private static final double SIDEBAR_SCALE = 0.8;
    private static final double SIDEBAR_ALPHA = 0.3;
    private static final double TAB_SCALE = 0.3;
    private static final float TAB_ALPHA = 0.7f;
    private static final float TAB_TRANSPARENT_ALPHA = 0.3f;
    private static final int SHEET_SIZE = 768;
    private static final int TOOLTIP_COL_ERROR = 7351083;
    private static final int TOOLTIP_COL_NORMAL = 0;
    private static final int[][] DEFAULT_POSITION = new int[][]{{-50, 50}, {120, 75}, {150, 0}, {100, -50}, {145, 0}, {120, 50}, {-50, 50}, {0, -50}, {-100, -50}, {50, 100}, {50, 100}};
    private static final ModificationTab SCOPE_TAB = new ModificationTab(0, "Sight", AttachmentCategory.SCOPE, -50.0, 50.0, ModificationGroup.ATTACHMENT);
    private static final ModificationTab BARREL_TAB = new ModificationTab(1, "Muzzle", AttachmentCategory.SILENCER, 120.0, 75.0, ModificationGroup.ATTACHMENT);
    private static final ModificationTab LASER_TAB = new ModificationTab(2, "Laser", AttachmentCategory.LASER, 150.0, 0.0, ModificationGroup.ATTACHMENT);
    private static final ModificationTab GRIP_TAB = new ModificationTab(3, "Grip", AttachmentCategory.GRIP, 100.0, -50.0, ModificationGroup.ATTACHMENT);
    private static final ModificationTab HANDGUARD_TAB = new ModificationTab(4, "Handguard", AttachmentCategory.GUARD, 145.0, 0.0, ModificationGroup.MODIFICATION);
    private static final ModificationTab FRONT_SIGHT_TAB = new ModificationTab(5, "Front Sight", AttachmentCategory.FRONTSIGHT, 120.0, 50.0, ModificationGroup.MODIFICATION);
    private static final ModificationTab RECEIVER_TAB = new ModificationTab(6, "Receiver", AttachmentCategory.RECEIVER, -50.0, 50.0, ModificationGroup.MODIFICATION);
    private static final ModificationTab REAR_GRIP_TAB = new ModificationTab(7, "Rear Grip", AttachmentCategory.BACKGRIP, 0.0, -50.0, ModificationGroup.MODIFICATION);
    private static final ModificationTab STOCK_TAB = new ModificationTab(8, "Stock", AttachmentCategory.STOCK, -100.0, -50.0, ModificationGroup.MODIFICATION);
    private static final ModificationTab RAILING_TAB = new ModificationTab(9, "Railing", AttachmentCategory.RAILING, 50.0, 100.0, ModificationGroup.MODIFICATION);
    private static final ModificationTab WEAPON_SKIN_TAB = new ModificationTab(10, "Skin", AttachmentCategory.SKIN, 50.0, 100.0, ModificationGroup.CUSTOMIZATION);
    private static final TexturedRect PRIMARY_ELEMENT = new TexturedRect(0.0, 0.0, 0.0, 0.0, 311.0, 108.0, 1.0);
    private static final TexturedRect RED_ELEMENT = new TexturedRect(0.0, 0.0, 311.0, 0.0, 311.0, 108.0, 1.0);
    private static final TexturedRect DROPDOWN_SELECT_ELEMENT = new TexturedRect(0.0, 111.0, 40.0, 254.0, 109.0, 28.0, 1.0).withSelectedVariant(188, 254);
    private static final TexturedRect DROPDOWN_SELECT_RED_ELEMENT = new TexturedRect(0.0, 111.0, 350.0, 300.0, 109.0, 28.0, 1.0).withSelectedVariant(350, 328);
    private static final TexturedRect DROPDOWN_MENU_ELEMENT = new TexturedRect(0.0, 140.0, 0.0, 108.0, 434.0, 109.0, 1.0).withSelectedVariant(0, 478);
    private static final TexturedRect DROPDOWN_SAFE_BOX = new TexturedRect(0.0, 140.0, 0.0, 108.0, 434.0, 140.0, 1.0).withSelectedVariant(0, 478);
    private static final TexturedRect DROPDOWN_BAR_ELEMENT = new TexturedRect(0.0, 250.0, 0.0, 222.0, 435.0, 32.0, 1.0).withSelectedVariant(0, 592);
    private static final TexturedRect LEFT_ARROW_ELEMENT = new TexturedRect(165.0, 256.5, 0.0, 254.0, 40.0, 46.0, 0.4);
    private static final TexturedRect RIGHT_ARROW_ELEMENT = new TexturedRect(255.0, 256.5, 149.0, 254.0, 39.0, 46.0, 0.4);
    private static final TexturedRect MORE_ITEMS_ALERT_ELEMENT = new TexturedRect(75.0, 114.0, 0.0, 713.0, 26.0, 26.0, 0.8);
    private static final TexturedRect PRIMARY_SELECTOR_ELEMENT = new TexturedRect(11.0, 10.0, 0.0, 389.0, 89.0, 89.0, 1.0);
    private static final TexturedRect LOCK_OUT_ELEMENT = new TexturedRect(11.0, 10.0, 0.0, 624.0, 89.0, 89.0, 1.0);
    private ModificationTab activeTab;
    private ModificationGroup currentGroup = ModificationGroup.ATTACHMENT;
    private boolean waitingForMouseRelease = true;
    private boolean isInClick = false;
    private boolean dropdownCancel = false;
    private int tabHovered = -1;
    public RadarChart radarChart = new RadarChart("3", 1752220, 0.5f, 50.0f, 5).withTitles(new String[]{"Damage", "Recoil", "Inaccuracy", "Firerate", "Velocity"});
    private float[] persistentColorState = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private int grabbedX;
    private int grabbedY;
    private int originalMouseX;
    private int originalMouseY;
    private ModificationTab grabbedTab;
    private boolean hasBeenSetup = false;

    public static ModificationGUI getInstance() {
        return instance;
    }

    public static String translate(String unlocalized) {
        return new TextComponentTranslation(unlocalized + ".name", new Object[0]).func_150254_d();
    }

    public double getGUIScale() {
        return 0.3;
    }

    private void setRGB(float r, float g, float b) {
        this.persistentColorState[0] = r;
        this.persistentColorState[1] = g;
        this.persistentColorState[2] = b;
        this.callPersistentState();
    }

    private void callPersistentState() {
        GlStateManager.func_179131_c((float)this.persistentColorState[0], (float)this.persistentColorState[1], (float)this.persistentColorState[2], (float)this.persistentColorState[3]);
    }

    private void clearRGB() {
        this.setRGB(1.0f, 1.0f, 1.0f);
        this.callPersistentState();
    }

    private void setAlpha(float alpha) {
        this.persistentColorState[3] = alpha;
        this.callPersistentState();
    }

    public void setGroup(ModificationGroup group) {
        this.currentGroup = group;
    }

    public void printTabLocations() {
        tabList.sort((a, b) -> ((ModificationTab)a).id - ((ModificationTab)b).id);
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < tabList.size(); ++i) {
            ModificationTab tab = tabList.get(i);
            sb.append("{" + (int)tab.x + ", " + (int)tab.y + "}");
            if (i >= tabList.size() - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        System.out.println(sb.toString());
    }

    public void setupForWeapon(PlayerWeaponInstance pwi) {
        this.hasBeenSetup = true;
        int[][] guiPositions = pwi.getWeapon().builder.getGUIPositions();
        for (ModificationTab tab : tabList) {
            tab.setPos(guiPositions[tab.id][0], guiPositions[tab.id][1]);
            if (pwi.getWeapon().getCompatibleAttachments(tab.category).isEmpty()) {
                tab.hidden = true;
                continue;
            }
            tab.hidden = false;
        }
    }

    public void render(ModContext modContext) {
        if (!this.hasBeenSetup) {
            this.setupForWeapon(modContext.getMainHeldWeapon());
        }
        PlayerWeaponInstance weaponInstance = modContext.getMainHeldWeapon();
        Weapon weapon = weaponInstance.getWeapon();
        ScaledResolution scaledresolution = new ScaledResolution(ClientProxy.MC);
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int mouseX = Mouse.getX() * scaledWidth / ClientProxy.MC.field_71443_c;
        int mouseY = scaledHeight - Mouse.getY() * scaledHeight / ClientProxy.MC.field_71440_d - 1;
        GlStateManager.func_179094_E();
        ClientProxy.MC.func_71364_i();
        if (!this.waitingForMouseRelease && Mouse.isButtonDown((int)0) && ClientProxy.MC.field_71462_r == null) {
            this.waitingForMouseRelease = true;
            this.isInClick = true;
        } else if (!Mouse.isButtonDown((int)0)) {
            this.waitingForMouseRelease = false;
        }
        if (this.activeTab != null && !tabList.isEmpty() && tabList.get(tabList.size() - 1) != this.activeTab) {
            tabList.remove(this.activeTab);
            tabList.add(this.activeTab);
        }
        for (ModificationTab mt : tabList) {
            if (mt.group != this.currentGroup || mt.hidden) continue;
            this.drawModificationTab(scaledresolution, mt, mouseX, mouseY, modContext.getMainHeldWeapon(), modContext);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GUIRenderHelper.drawColoredRectangle(20.0, 20.0, 115.0, 175.0, 0.3, 0);
        GUIRenderHelper.drawColoredRectangle(140.5, 20.0, 7.5, 175.0, 0.3, 0);
        GUIRenderHelper.drawColoredRectangle(20.0, 200.0, 128.0, 125.0, 0.3, 0);
        float firerate = weaponInstance.getFireRate();
        float inaccuracy = weaponInstance.getWeapon().getInaccuracy() / 10.0f;
        float damage = weaponInstance.getWeapon().getSpawnEntityDamage() / 20.0f;
        float recoil = weaponInstance.getRecoil() / 10.0f;
        damage = Math.min(damage, 1.0f);
        this.radarChart.uploadSet(new float[]{damage, recoil, inaccuracy, firerate, 0.14f});
        GlStateManager.func_179090_x();
        this.radarChart.render(84.0, 275.5, mouseX, mouseY, 0.8);
        GlStateManager.func_179098_w();
        GUIRenderHelper.drawScaledString(TextFormatting.GOLD + "Weapon Stats", 30.0, 205.0, 1.0, 0xFFFFFF);
        GUIRenderHelper.drawScaledString(TextFormatting.GOLD + ModificationGUI.translate(weapon.func_77658_a()), 30.0, 30.0, 1.0, 0xFFFFFF);
        GUIRenderHelper.drawScaledString("Damage :: " + TextFormatting.GOLD + String.format("%.2f", BalancePackManager.getNetGunDamage(weapon)), 30.0, 60.0, 1.0, 0xFFFFFF);
        GUIRenderHelper.drawScaledString("Recoil :: " + TextFormatting.GOLD + String.format("%.2f", Float.valueOf(weaponInstance.getRecoil())), 30.0, 75.0, 1.0, 0xFFFFFF);
        GUIRenderHelper.drawScaledString("Firerate :: " + TextFormatting.GOLD + weaponInstance.getFireRate(), 30.0, 90.0, 1.0, 0xFFFFFF);
        GUIRenderHelper.drawScaledString("Inaccuracy :: " + TextFormatting.GOLD + String.format("%.1f", Float.valueOf(weaponInstance.getInaccuracy())), 30.0, 105.0, 1.0, 0xFFFFFF);
        GlStateManager.func_179121_F();
        ClientProxy.MC.func_110434_K().func_110577_a(MODIFICATION_GUI_TEXTURES);
        boolean nullHoverTab = false;
        this.clearRGB();
        this.setAlpha(1.0f);
        for (int groupID = 0; groupID < 3; ++groupID) {
            GlStateManager.func_179090_x();
            GUIRenderHelper.drawColoredRectangle(scaledresolution.func_78327_c() - 15.0, scaledresolution.func_78324_d() - 75.0 - (double)(18 * groupID), 15.0, 15.0, 0.5, 0);
            ClientProxy.MC.func_110434_K().func_110577_a(MODIFICATION_GUI_TEXTURES);
            GlStateManager.func_179098_w();
            TexturedRect groupSelector = new TexturedRect(scaledresolution.func_78327_c() - 13.0, scaledresolution.func_78324_d() - 73.5 - (double)(18 * groupID), 413.0, 356.0, 46.0, 46.0, 768.0, 768.0, 0.25);
            groupSelector.render();
            if (groupSelector.checkBounding(0.0, 0.0, mouseX, mouseY, 1.0)) {
                nullHoverTab = true;
                this.tabHovered = groupID;
            }
            if (!groupSelector.checkBounding(0.0, 0.0, mouseX, mouseY, 1.0) && (this.tabHovered != -1 || ModificationGroup.fromID(groupID) != this.currentGroup)) continue;
            TexturedRect groupSelector2 = new TexturedRect(scaledresolution.func_78327_c() - 13.0, scaledresolution.func_78324_d() - 73.5 - (double)(18 * groupID), 413.0, 402.0, 46.0, 46.0, 768.0, 768.0, 0.25);
            groupSelector2.render();
            String text = ModificationGroup.getName(groupID) + " Mode";
            this.setAlpha(0.5f);
            GUIRenderHelper.drawTexturedScaledRect(scaledresolution.func_78327_c() - 134.0, scaledresolution.func_78324_d() - 74.5 - (double)(18 * groupID), 90.0f, 624.0f, 390.0, 45.0, 768.0, 768.0, 0.3);
            this.setAlpha(1.0f);
            GUIRenderHelper.drawAlignedString(text, GUIRenderHelper.StringAlignment.RIGHT, true, scaledresolution.func_78327_c() - 18.0, scaledresolution.func_78324_d() - 75.0 - (double)(18 * groupID), 0.8, 0xFFFFFF);
            if (!this.isInClick || !groupSelector.checkBounding(0.0, 0.0, mouseX, mouseY, 1.0)) continue;
            this.currentGroup = ModificationGroup.fromID(groupID);
            weaponInstance.setAltModificationModeEnabled(this.currentGroup == ModificationGroup.MODIFICATION);
            this.activeTab = null;
        }
        if (!nullHoverTab) {
            this.tabHovered = -1;
        }
        this.isInClick = false;
        GlStateManager.func_179098_w();
    }

    public void drawModificationTab(ScaledResolution sr, ModificationTab tab, int mouseX, int mouseY, PlayerWeaponInstance pwi, ModContext modcontext) {
        ArrayList<Object> inventory;
        boolean creativeMode;
        float guiTransparency = 0.7f;
        if (this.activeTab != null && tab != this.activeTab) {
            guiTransparency = 0.3f;
        }
        double scale = 0.3;
        double x = sr.func_78327_c() / 2.0 - tab.x;
        double y = sr.func_78324_d() / 2.0 - tab.y;
        String title = tab.title;
        AttachmentCategory category = tab.category;
        if (tab.isDropDownOpen && sr.func_78324_d() < y + 100.0) {
            y -= 30.0;
        }
        if (!(creativeMode = ((EntityPlayer)pwi.getPlayer()).func_184812_l_())) {
            inventory = modcontext.getAttachmentAspect().getInventoryAttachments(category, pwi);
        } else {
            inventory = new ArrayList();
            for (CompatibleAttachment<? extends AttachmentContainer> compatibleAttachment : modcontext.getMainHeldWeapon().getWeapon().getCompatibleAttachments(category)) {
                WeaponAttachmentAspect.FlaggedAttachment flaggedAttachment = new WeaponAttachmentAspect.FlaggedAttachment(new ItemStack(compatibleAttachment.getAttachment()), compatibleAttachment.getAttachment());
                if (compatibleAttachment.getAttachment().getCategory() != category || !modcontext.getAttachmentAspect().isCompatibleAttachment(compatibleAttachment.getAttachment(), pwi)) continue;
                modcontext.getAttachmentAspect();
                if (!WeaponAttachmentAspect.hasRequiredAttachments(compatibleAttachment.getAttachment(), pwi)) {
                    flaggedAttachment.setRequiredParts(modcontext.getAttachmentAspect().getRequiredParts(compatibleAttachment.getAttachment(), pwi));
                }
                inventory.add(flaggedAttachment);
            }
        }
        boolean allInventoryRequired = true;
        for (Object flag : inventory) {
            if (((WeaponAttachmentAspect.FlaggedAttachment)flag).requiresAnyParts()) continue;
            allInventoryRequired = false;
            break;
        }
        if (inventory.isEmpty()) {
            allInventoryRequired = false;
        }
        boolean bl = DROPDOWN_SELECT_ELEMENT.checkBounding(x, y, mouseX, mouseY, scale);
        ClientProxy.MC.func_110434_K().func_110577_a(MODIFICATION_GUI_TEXTURES);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        GlStateManager.func_179147_l();
        this.clearRGB();
        this.setAlpha(guiTransparency);
        if (bl && this.isInClick) {
            tab.isDropDownOpen = !tab.isDropDownOpen;
            if (tab.isDropDownOpen) {
                this.activeTab = tab;
                for (ModificationTab mt : tabList) {
                    if (mt == tab) continue;
                    mt.isDropDownOpen = false;
                }
            } else {
                this.activeTab = null;
            }
        }
        TooltipBuilder tooltip = new TooltipBuilder();
        boolean requiresTooltip = false;
        if (allInventoryRequired) {
            RED_ELEMENT.render();
        } else {
            PRIMARY_ELEMENT.render();
        }
        if (DebugCommand.isEditingGUI()) {
            if (!Mouse.isButtonDown((int)0)) {
                this.grabbedTab = null;
            }
            if (Mouse.isButtonDown((int)0) && this.grabbedTab == tab) {
                tab.x = this.grabbedX + (this.originalMouseX - mouseX);
                tab.y = this.grabbedY + (this.originalMouseY - mouseY);
            }
            if (this.isInClick && PRIMARY_ELEMENT.checkBounding(x, y, mouseX, mouseY, scale)) {
                this.grabbedX = (int)tab.x;
                this.grabbedY = (int)tab.y;
                this.grabbedTab = tab;
                this.originalMouseX = mouseX;
                this.originalMouseY = mouseY;
            }
        }
        ItemAttachment<Weapon> primaryAttachment = pwi.getAttachmentItemWithCategory(category);
        boolean lockOutState = WeaponAttachmentAspect.isRequired(primaryAttachment, modcontext.getMainHeldWeapon());
        if (!this.dropdownCancel && primaryAttachment != null && PRIMARY_SELECTOR_ELEMENT.checkBounding(x, y, mouseX, mouseY, scale)) {
            this.setAlpha(0.5f);
            if (!lockOutState) {
                PRIMARY_SELECTOR_ELEMENT.render();
            }
            tooltip.color = 0;
            requiresTooltip = true;
            tooltip.addLine(new TextComponentTranslation(primaryAttachment.func_77658_a() + ".name", new Object[0]).func_150254_d());
            if (lockOutState) {
                ArrayList<ItemAttachment<Weapon>> requirees = WeaponAttachmentAspect.whatRequiredFor(primaryAttachment, pwi);
                tooltip.addLine(TextFormatting.BOLD + "Is Required By:");
                for (ItemAttachment<Weapon> req : requirees) {
                    tooltip.addBulletPoint(ModificationGUI.translate(req.func_77658_a()));
                }
            }
            if (this.isInClick) {
                ClientProxy.MC.field_71439_g.func_184185_a(UniversalSoundLookup.lookupSound("attachmentoff"), 10.0f, 1.0f);
                modcontext.getAttachmentAspect().forceAttachment(category, modcontext.getMainHeldWeapon(), ItemStack.field_190927_a);
            }
            this.setAlpha(guiTransparency);
        }
        this.clearRGB();
        if (lockOutState) {
            this.setAlpha(0.9f);
            LOCK_OUT_ELEMENT.render();
            this.setAlpha(guiTransparency);
        }
        if (!allInventoryRequired) {
            if (!bl) {
                DROPDOWN_SELECT_ELEMENT.render();
            } else {
                DROPDOWN_SELECT_ELEMENT.renderSelected();
            }
        } else if (!bl) {
            DROPDOWN_SELECT_RED_ELEMENT.render();
        } else {
            DROPDOWN_SELECT_RED_ELEMENT.renderSelected();
        }
        if (inventory.size() > 0) {
            MORE_ITEMS_ALERT_ELEMENT.render();
        }
        this.setAlpha(guiTransparency);
        if (this.activeTab == tab) {
            this.dropdownCancel = false;
            if (tab.isDropDownOpen && DROPDOWN_SAFE_BOX.checkBounding(x, y, mouseX, mouseY, scale)) {
                this.dropdownCancel = true;
            }
        }
        if (tab.isDropDownOpen) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
            if (!allInventoryRequired) {
                DROPDOWN_MENU_ELEMENT.render();
            } else {
                DROPDOWN_MENU_ELEMENT.renderSelected();
            }
            GlStateManager.func_179121_F();
            if (!allInventoryRequired) {
                DROPDOWN_BAR_ELEMENT.render();
            } else {
                DROPDOWN_BAR_ELEMENT.renderSelected();
            }
            if (LEFT_ARROW_ELEMENT.checkBounding(x, y, mouseX, mouseY, scale)) {
                if (this.isInClick) {
                    tab.previousPage();
                }
                this.setAlpha(0.5f);
            }
            LEFT_ARROW_ELEMENT.render();
            this.setAlpha(1.0f);
            if (RIGHT_ARROW_ELEMENT.checkBounding(x, y, mouseX, mouseY, scale)) {
                if (this.isInClick) {
                    tab.nextPage(inventory.size());
                }
                this.setAlpha(0.5f);
            }
            RIGHT_ARROW_ELEMENT.render();
            this.setAlpha(1.0f);
            GUIRenderHelper.drawScaledString("Pg. " + (tab.page + 1), 188.5, 256.5, 2.5, 0xFFFFFF);
        }
        GlStateManager.func_179147_l();
        this.setAlpha(0.3f);
        if (bl) {
            GUIRenderHelper.drawScaledString(title, 125.0, 10.0, 2.5, 16697943);
        } else {
            GUIRenderHelper.drawScaledString(title, 125.0, 10.0, 2.5, 0xFFFFFF);
        }
        ItemAttachment<Weapon> current = pwi.getAttachmentItemWithCategory(category);
        if (current != null) {
            this.clearRGB();
            this.setAlpha(1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-15.0f);
            GUIRenderHelper.quickItemRender(current, 13.0, 13.0, 5.0);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
        if (tab.isDropDownOpen) {
            int startingPosition;
            double i = 0.0;
            for (int g = startingPosition = tab.page * 4; g < Math.min(inventory.size(), startingPosition + 4); ++g) {
                WeaponAttachmentAspect.FlaggedAttachment flag = (WeaponAttachmentAspect.FlaggedAttachment)inventory.get(g);
                GUIRenderHelper.quickItemRender(flag.getAttachment(), i + 13.0, 150.0, 5.0);
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
                ClientProxy.MC.func_110434_K().func_110577_a(MODIFICATION_GUI_TEXTURES);
                if (flag.requiresAnyParts()) {
                    TexturedRect redBlockade = new TexturedRect(i + 11.0, 150.0, 0.0, 300.0, 89.0, 89.0, 1.0);
                    redBlockade.render();
                    if (redBlockade.checkBounding(x, y, mouseX, mouseY, scale)) {
                        requiresTooltip = true;
                        tooltip.color = 7351083;
                        tooltip.addBulletPoint(ModificationGUI.translate(flag.getAttachment().func_77658_a()));
                        tooltip.addLine(TextFormatting.BOLD + "Required Mods: ");
                        for (ItemAttachment<Weapon> required : flag.getRequiredParts()) {
                            tooltip.addBulletPoint(ModificationGUI.translate(required.func_77658_a()));
                        }
                    }
                } else {
                    TexturedRect selector = new TexturedRect(i + 11.0, 150.0, 0.0, 389.0, 89.0, 89.0, 1.0);
                    if (selector.checkBounding(x, y, mouseX, mouseY, scale)) {
                        this.setAlpha(0.5f);
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
                        selector.render();
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-50.0f);
                        tooltip.color = 0;
                        requiresTooltip = true;
                        tooltip.addLine(new TextComponentTranslation(flag.getAttachment().func_77658_a() + ".name", new Object[0]).func_150254_d());
                        if (this.isInClick) {
                            ClientProxy.MC.field_71439_g.func_184185_a(UniversalSoundLookup.lookupSound("attachmenton"), 10.0f, 1.0f);
                            modcontext.getAttachmentAspect().forceAttachment(category, modcontext.getMainHeldWeapon(), flag.getItemStack());
                        }
                    }
                }
                i += 108.0;
            }
        }
        GlStateManager.func_179121_F();
        if (allInventoryRequired) {
            GUIRenderHelper.drawScaledString("Mods required", 119.0, 50.0, 3.0, 0xFF3F34);
        }
        GlStateManager.func_179121_F();
        if (requiresTooltip) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1000.0f);
            ClientProxy.MC.func_110434_K().func_110577_a(MODIFICATION_GUI_TEXTURES);
            this.setAlpha(0.5f);
            String[] args = tooltip.getLines();
            double maxStringWidth = 0.0;
            double maxStringHeight = args.length * 12;
            for (String s : args) {
                double len = (double)ClientProxy.MC.field_71466_p.func_78256_a(s) + 5.0;
                if (!(len > maxStringWidth)) continue;
                maxStringWidth = len;
            }
            GlStateManager.func_179090_x();
            GUIRenderHelper.drawColoredRectangle(mouseX, mouseY, maxStringWidth, maxStringHeight, 0.5, tooltip.color);
            GlStateManager.func_179098_w();
            int space = 0;
            for (String splitted : args) {
                GUIRenderHelper.drawScaledString(splitted, mouseX + 2, mouseY + 2 + space, 1.0, 0xFFFFFF);
                space += 10;
            }
            this.setAlpha(1.0f);
            this.clearRGB();
            GlStateManager.func_179121_F();
        }
    }

    static {
        tabList.add(SCOPE_TAB);
        tabList.add(BARREL_TAB);
        tabList.add(LASER_TAB);
        tabList.add(GRIP_TAB);
        tabList.add(HANDGUARD_TAB);
        tabList.add(FRONT_SIGHT_TAB);
        tabList.add(RECEIVER_TAB);
        tabList.add(REAR_GRIP_TAB);
        tabList.add(STOCK_TAB);
        tabList.add(RAILING_TAB);
        tabList.add(WEAPON_SKIN_TAB);
    }

    public static class ModificationTab {
        private String title;
        private AttachmentCategory category;
        private double x;
        private double y;
        private boolean isDropDownOpen = false;
        private int page;
        private int id;
        private boolean hidden = false;
        private ModificationGroup group;

        public ModificationTab(int id, String title, AttachmentCategory category, double x, double y, ModificationGroup group) {
            this.id = id;
            this.x = x;
            this.y = y;
            this.group = group;
            this.title = title;
            this.category = category;
        }

        public void setDropdown(boolean down) {
            this.isDropDownOpen = down;
        }

        public void nextPage(int max) {
            this.page = this.page + 1 > max / 4 ? 0 : ++this.page;
        }

        public void previousPage() {
            if (this.page == 0) {
                return;
            }
            --this.page;
        }

        public void setPos(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    private static class TexturedRect {
        private double x;
        private double y;
        private double u;
        private double v;
        private double textureWidth;
        private double textureHeight;
        private double width;
        private double height;
        private double scale;
        private int selectedU;
        private int selectedV;

        public TexturedRect(double x, double y, double u, double v, double width, double height, double textureWidth, double textureHeight, double scale) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.scale = scale;
            this.u = u;
            this.v = v;
            this.textureHeight = textureHeight;
            this.textureWidth = textureWidth;
        }

        public TexturedRect(double x, double y, double u, double v, double width, double height, double scale) {
            this(x, y, u, v, width, height, 768.0, 768.0, scale);
        }

        public TexturedRect withSelectedVariant(int u, int v) {
            this.selectedU = u;
            this.selectedV = v;
            return this;
        }

        public void render() {
            GUIRenderHelper.drawTexturedScaledRect(this.x, this.y, (float)this.u, (float)this.v, this.width, this.height, this.textureWidth, this.textureHeight, this.scale);
        }

        public void renderSelected() {
            GUIRenderHelper.drawTexturedScaledRect(this.x, this.y, this.selectedU, this.selectedV, this.width, this.height, this.textureWidth, this.textureHeight, this.scale);
        }

        public boolean checkBounding(double guiX, double guiY, int mouseX, int mouseY, double guiScale) {
            return GUIRenderHelper.checkInBox(mouseX, mouseY, guiX + this.x * guiScale, guiY + this.y * guiScale, this.width * this.scale * guiScale, this.height * this.scale * guiScale);
        }
    }

    public static class TooltipBuilder {
        private StringBuilder sb = new StringBuilder();
        private int color;

        public void setColor(int color) {
            this.color = color;
        }

        public void addBulletPoint(String text) {
            this.addLine("\ufffd " + text);
        }

        public void addLine(String line) {
            this.sb.append(line + "\n");
        }

        public int getColor() {
            return this.color;
        }

        public String[] getLines() {
            return this.getText().split("\n");
        }

        public String getText() {
            return this.sb.toString();
        }
    }

    public static enum ModificationGroup {
        ATTACHMENT,
        MODIFICATION,
        CUSTOMIZATION;


        public static ModificationGroup fromID(int id) {
            switch (id) {
                case 0: {
                    return ATTACHMENT;
                }
                case 1: {
                    return MODIFICATION;
                }
                case 2: {
                    return CUSTOMIZATION;
                }
            }
            return ATTACHMENT;
        }

        public static String getName(int id) {
            switch (id) {
                case 0: {
                    return "Attachment";
                }
                case 1: {
                    return "Modification";
                }
                case 2: {
                    return "Customization";
                }
            }
            return "";
        }
    }
}

