/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.config;

import com.paneedah.weaponlib.config.ConfigSync;
import com.paneedah.weaponlib.config.HierarchialTree;
import com.paneedah.weaponlib.config.ModernConfigCategory;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.config.SynchronizedConfigElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;

public class VMWModConfigGUI
extends GuiConfig {
    private static final HierarchialTree<IConfigElement> configTree = new HierarchialTree();
    private static final List<IConfigElement> cachedList = new ArrayList<IConfigElement>();
    private static boolean shouldUpdateCache = true;

    public VMWModConfigGUI(GuiScreen parentScreen) {
        super(parentScreen, VMWModConfigGUI.getElements(), "mwc", false, false, "Finally... a config!");
    }

    public static ConfigGuiType getGUITypeFromFieldType(Field f) {
        if (f.getType() == Integer.TYPE) {
            return ConfigGuiType.INTEGER;
        }
        if (f.getType() == Boolean.TYPE) {
            return ConfigGuiType.BOOLEAN;
        }
        if (f.getType() == Double.TYPE) {
            return ConfigGuiType.DOUBLE;
        }
        if (f.getType() == String.class) {
            return ConfigGuiType.STRING;
        }
        return null;
    }

    protected static void submitField(ConfigSync annotation, Field f) {
        String propertyTag = "config." + annotation.category() + "." + f.getName() + ".property";
        try {
            SynchronizedConfigElement element = null;
            if (f.getType() == Integer.TYPE) {
                if (f.isAnnotationPresent(Config.RangeInt.class)) {
                    Config.RangeInt range = f.getAnnotation(Config.RangeInt.class);
                    element = new SynchronizedConfigElement(f, f.getName(), propertyTag + ".name", f.get(null), VMWModConfigGUI.getGUITypeFromFieldType(f), propertyTag, range.min(), range.max());
                }
            } else if (f.getType() == Double.TYPE && f.isAnnotationPresent(Config.RangeDouble.class)) {
                Config.RangeDouble range = f.getAnnotation(Config.RangeDouble.class);
                element = new SynchronizedConfigElement(f, f.getName(), propertyTag + ".name", f.get(null), VMWModConfigGUI.getGUITypeFromFieldType(f), propertyTag, range.min(), range.max());
            }
            if (element == null) {
                element = new SynchronizedConfigElement(f, f.getName(), propertyTag + ".name", f.get(null), VMWModConfigGUI.getGUITypeFromFieldType(f), propertyTag);
            }
            if (f.isAnnotationPresent(Config.RequiresMcRestart.class)) {
                element.setRequiresMcRestart(true);
            }
            configTree.addNode(annotation.category(), (IConfigElement)element);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    private static void recursiveWalk(HierarchialTree.Branch<IConfigElement> branch, ModernConfigCategory element) {
        String[] splitted = branch.getPathway().split("\\.");
        String name = splitted[splitted.length - 1];
        if (!element.getCategoryName().equals(name)) {
            ModernConfigCategory newElement = new ModernConfigCategory(name, "config.category." + name, new ArrayList<IConfigElement>());
            element.getChildElements().add(newElement);
            element = newElement;
        }
        Iterator<IConfigElement> nodeIterator = branch.getNodeIterator();
        while (nodeIterator.hasNext()) {
            element.getChildElements().add(nodeIterator.next());
        }
        for (Map.Entry<String, HierarchialTree.Branch<IConfigElement>> entry : branch.getSubBranches().entrySet()) {
            VMWModConfigGUI.recursiveWalk(entry.getValue(), element);
        }
    }

    public static List<IConfigElement> getElements() {
        ModernConfigManager.init();
        if (shouldUpdateCache) {
            cachedList.clear();
            shouldUpdateCache = false;
            Iterator<HierarchialTree.Branch<IConfigElement>> itr = configTree.getRootIterator();
            while (itr.hasNext()) {
                HierarchialTree.Branch<IConfigElement> root = itr.next();
                ModernConfigCategory category = new ModernConfigCategory(root.getKey(), "config.category." + root.getKey(), new ArrayList<IConfigElement>());
                cachedList.add((IConfigElement)category);
                VMWModConfigGUI.recursiveWalk(root, category);
            }
        }
        return cachedList;
    }

    public void func_146281_b() {
        ModernConfigManager.saveConfig();
        super.func_146281_b();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
    }
}

