/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation.jim;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.paneedah.weaponlib.ClientModContext;
import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.RenderableState;
import com.paneedah.weaponlib.UniversalSoundLookup;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.animation.Transform;
import com.paneedah.weaponlib.animation.Transition;
import com.paneedah.weaponlib.animation.jim.BBLoader;
import com.paneedah.weaponlib.render.bgl.math.AngleKit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class AnimationData {
    public TreeMap<Float, BlockbenchTransition> bbTransition = new TreeMap();
    public static final float PACE = 833.0f;
    public ArrayList<Float> timestamps = new ArrayList();
    public TreeMap<Float, Vec3d> rotationKeyframes = new TreeMap();
    public TreeMap<Float, Vec3d> translateKeyframes = new TreeMap();
    private boolean isNull = false;
    private int fakeTransitions = 0;
    private long fTLength;
    private float appointedDuration;

    protected AnimationData(ArrayList<Float> arrayList) {
        this.isNull = true;
        this.fakeTransitions = arrayList.size();
        this.fTLength = (long)(arrayList.get(arrayList.size() - 1).floatValue() / (float)arrayList.size());
    }

    public void setAppointedDuration(float f) {
        this.appointedDuration = f;
    }

    public float getAppointedDuration() {
        return this.appointedDuration;
    }

    public AnimationData(JsonObject obj) {
        Vec3d translationVector;
        JsonArray ar;
        float time;
        JsonArray ar2;
        ArrayList<Float> timestamps = new ArrayList<Float>();
        if (obj.has("rotation") && obj.get("rotation").isJsonObject()) {
            JsonObject rotation = obj.get("rotation").getAsJsonObject();
            for (Map.Entry i : rotation.entrySet()) {
                ar2 = ((JsonElement)i.getValue()).getAsJsonArray();
                time = Float.parseFloat((String)i.getKey());
                Vec3d rotationVector = new Vec3d(ar2.get(0).getAsDouble(), ar2.get(1).getAsDouble(), ar2.get(2).getAsDouble());
                if (!timestamps.contains(Float.valueOf(time))) {
                    timestamps.add(Float.valueOf(time));
                }
                this.rotationKeyframes.put(Float.valueOf(time), rotationVector);
            }
        } else if (!obj.has("rotation")) {
            this.rotationKeyframes.put(Float.valueOf(0.0f), Vec3d.field_186680_a);
        } else if (!obj.get("rotation").isJsonObject()) {
            ar = obj.get("rotation").getAsJsonArray();
            translationVector = new Vec3d(ar.get(0).getAsDouble(), ar.get(1).getAsDouble(), ar.get(2).getAsDouble());
            this.rotationKeyframes.put(Float.valueOf(0.0f), translationVector);
        }
        if (obj.has("position") && obj.get("position").isJsonObject()) {
            JsonObject translate = obj.get("position").getAsJsonObject();
            for (Map.Entry i : translate.entrySet()) {
                ar2 = ((JsonElement)i.getValue()).getAsJsonArray();
                time = Float.parseFloat((String)i.getKey());
                Vec3d translationVector2 = new Vec3d(ar2.get(0).getAsDouble(), ar2.get(1).getAsDouble(), ar2.get(2).getAsDouble());
                if (!timestamps.contains(Float.valueOf(time))) {
                    timestamps.add(Float.valueOf(time));
                }
                this.translateKeyframes.put(Float.valueOf(time), translationVector2);
            }
        } else if (!obj.has("position")) {
            this.translateKeyframes.put(Float.valueOf(0.0f), Vec3d.field_186680_a);
        } else if (!obj.get("position").isJsonObject()) {
            ar = obj.get("position").getAsJsonArray();
            translationVector = new Vec3d(ar.get(0).getAsDouble(), ar.get(1).getAsDouble(), ar.get(2).getAsDouble());
            this.translateKeyframes.put(Float.valueOf(0.0f), translationVector);
        }
        Collections.sort(timestamps);
        this.timestamps = timestamps;
        for (int i = 0; i < timestamps.size(); ++i) {
            float f = ((Float)timestamps.get(i)).floatValue();
            Vec3d rotationKey = null;
            Vec3d translationKey = null;
            float timeDelta = 0.0f;
            timeDelta = i != 0 ? (f - ((Float)timestamps.get(i - 1)).floatValue()) * 833.0f : 1.0f;
            try {
                if (!this.rotationKeyframes.containsKey(Float.valueOf(f))) {
                    rotationKey = this.buildRotationKeyframe(this.rotationKeyframes, f);
                    this.rotationKeyframes.put(Float.valueOf(f), rotationKey);
                } else {
                    rotationKey = this.rotationKeyframes.get(Float.valueOf(f));
                }
                if (!this.translateKeyframes.containsKey(Float.valueOf(f))) {
                    translationKey = this.buildKeyframe(this.translateKeyframes, f);
                    this.translateKeyframes.put(Float.valueOf(f), translationKey);
                } else {
                    translationKey = this.translateKeyframes.get(Float.valueOf(f));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.bbTransition.put(Float.valueOf(f), new BlockbenchTransition(timeDelta, rotationKey, translationKey));
        }
    }

    public void setSounds(HashMap<Float, String> map, ArrayList<Float> overflowList) {
        for (Map.Entry<Float, BlockbenchTransition> set : this.bbTransition.entrySet()) {
            if (!map.containsKey(set.getKey())) continue;
            overflowList.remove(set.getKey());
            set.getValue().setSound(UniversalSoundLookup.lookupSound(map.get(set.getKey())));
        }
    }

    public float getDelta(TreeMap<Float, Vec3d> map, float f) {
        if (map.floorKey(Float.valueOf(f)) != null) {
            return (f - map.floorKey(Float.valueOf(f)).floatValue()) * 833.0f;
        }
        if (map.ceilingKey(Float.valueOf(f)) != null) {
            return (f - map.ceilingKey(Float.valueOf(f)).floatValue()) * 833.0f;
        }
        return 100.0f;
    }

    public Vec3d buildRotationKeyframe(TreeMap<Float, Vec3d> keyList, float timestamp) {
        if (keyList.isEmpty()) {
            return Vec3d.field_186680_a;
        }
        if (keyList.ceilingKey(Float.valueOf(timestamp)) == null) {
            return keyList.get(keyList.floorKey(Float.valueOf(timestamp)));
        }
        if (keyList.floorKey(Float.valueOf(timestamp)) == null) {
            return keyList.get(keyList.ceilingKey(Float.valueOf(timestamp)));
        }
        float fromDelta = keyList.floorKey(Float.valueOf(timestamp)).floatValue();
        float toDeltaDelta = keyList.ceilingKey(Float.valueOf(timestamp)).floatValue();
        float alpha = (timestamp - fromDelta) / (toDeltaDelta - fromDelta);
        Vec3d beforeKey = keyList.floorEntry(Float.valueOf(timestamp)).getValue();
        Vec3d afterKey = keyList.ceilingEntry(Float.valueOf(timestamp)).getValue();
        if (afterKey == null) {
            afterKey = beforeKey;
        }
        AngleKit.EulerAngle beforeAngle = new AngleKit.EulerAngle(AngleKit.Format.DEGREES, beforeKey.field_72450_a, beforeKey.field_72448_b, beforeKey.field_72449_c);
        AngleKit.EulerAngle afterAngle = new AngleKit.EulerAngle(AngleKit.Format.DEGREES, afterKey.field_72450_a, afterKey.field_72448_b, afterKey.field_72449_c);
        AngleKit.EulerAngle resultant = beforeAngle.slerp(afterAngle, alpha);
        return new Vec3d(resultant.getX(), resultant.getY(), resultant.getZ());
    }

    public Vec3d buildKeyframe(TreeMap<Float, Vec3d> keyList, float timestamp) {
        if (keyList.isEmpty()) {
            return Vec3d.field_186680_a;
        }
        if (keyList.ceilingKey(Float.valueOf(timestamp)) == null) {
            return keyList.get(keyList.floorKey(Float.valueOf(timestamp)));
        }
        if (keyList.floorKey(Float.valueOf(timestamp)) == null) {
            return keyList.get(keyList.ceilingKey(Float.valueOf(timestamp)));
        }
        float fromDelta = keyList.floorKey(Float.valueOf(timestamp)).floatValue();
        float toDeltaDelta = keyList.ceilingKey(Float.valueOf(timestamp)).floatValue();
        float alpha = (timestamp - fromDelta) / (toDeltaDelta - fromDelta);
        Vec3d beforeKey = keyList.floorEntry(Float.valueOf(timestamp)).getValue();
        Vec3d afterKey = keyList.ceilingEntry(Float.valueOf(timestamp)).getValue();
        if (afterKey == null) {
            afterKey = beforeKey;
        }
        return MatrixHelper.lerpVectors(beforeKey, afterKey, alpha);
    }

    public void bakeKeyframes(float timeStamp) {
        Vec3d rotation = this.buildRotationKeyframe(this.rotationKeyframes, timeStamp);
        Vec3d translation = this.buildKeyframe(this.translateKeyframes, timeStamp);
        float timeDelta = this.getDelta(this.rotationKeyframes, timeStamp);
        this.rotationKeyframes.put(Float.valueOf(timeStamp), rotation);
        this.translateKeyframes.put(Float.valueOf(timeStamp), translation);
        this.getBbTransition().put(Float.valueOf(timeStamp), new BlockbenchTransition(timeDelta, rotation, translation));
    }

    public List<Transition<RenderContext<RenderableState>>> getTransitionList() {
        ArrayList<Transition<RenderContext<RenderableState>>> transitionList = new ArrayList<Transition<RenderContext<RenderableState>>>();
        for (Map.Entry<Float, BlockbenchTransition> bb : this.bbTransition.entrySet()) {
            transitionList.add(bb.getValue().createVMWTransition());
        }
        return transitionList;
    }

    public Transition<RenderContext<RenderableState>>[] getTransitionArray() {
        List<Transition<RenderContext<RenderableState>>> list = this.getTransitionList();
        Transition[] array = new Transition[list.size()];
        int count = 1;
        for (Transition<RenderContext<RenderableState>> t : list) {
            array[count++] = t;
            if (count != list.size() - 1) continue;
            break;
        }
        return array;
    }

    public List<Transition<RenderContext<RenderableState>>> getTransitionListDual(Transform normal, Transform ads, double divisor) {
        ArrayList<Transition<RenderContext<RenderableState>>> transitionList = new ArrayList<Transition<RenderContext<RenderableState>>>();
        if (!this.isNull) {
            for (Map.Entry<Float, BlockbenchTransition> bb : this.bbTransition.entrySet()) {
                transitionList.add(bb.getValue().createVMWTransitionWithADS(normal, ads, divisor));
            }
        } else {
            for (int i = 0; i < this.fakeTransitions; ++i) {
                transitionList.add(new Transition<RenderContext<RenderableState>>(normal.getAsPosition(), this.fTLength));
            }
        }
        long curLength = ((Transition)transitionList.get(transitionList.size() - 1)).getDuration();
        transitionList.set(transitionList.size() - 1, new Transition<RenderContext<RenderableState>>(normal.getAsPosition(), curLength));
        return transitionList;
    }

    public List<Transition<RenderContext<RenderableState>>> getTransitionList(Transform initial, double divisor) {
        return this.getTransitionList(initial, divisor, true);
    }

    public List<Transition<RenderContext<RenderableState>>> getTransitionList(Transform initial, double divisor, boolean applySwap) {
        ArrayList<Transition<RenderContext<RenderableState>>> transitionList = new ArrayList<Transition<RenderContext<RenderableState>>>();
        if (!this.isNull) {
            int count = 0;
            for (Map.Entry<Float, BlockbenchTransition> bb : this.bbTransition.entrySet()) {
                Transition<?> transition = bb.getValue().createVMWTransition(initial, divisor);
                if (count == 0) {
                    transition.setDuration(100L);
                }
                transitionList.add(transition);
                ++count;
            }
        } else {
            for (int i = 0; i < this.fakeTransitions; ++i) {
                transitionList.add(new Transition<RenderContext<RenderableState>>(initial.getAsPosition(), this.fTLength));
            }
        }
        if (applySwap) {
            long curLength = ((Transition)transitionList.get(transitionList.size() - 1)).getDuration();
            transitionList.set(transitionList.size() - 1, new Transition<RenderContext<RenderableState>>(initial.getAsPosition(), curLength));
        }
        return transitionList;
    }

    public TreeMap<Float, BlockbenchTransition> getBbTransition() {
        return this.bbTransition;
    }

    public void setBbTransition(TreeMap<Float, BlockbenchTransition> bbTransition) {
        this.bbTransition = bbTransition;
    }

    public ArrayList<Float> getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(ArrayList<Float> timestamps) {
        this.timestamps = timestamps;
    }

    public static class BlockbenchTransition {
        private float timestamp;
        private Vec3d rotation;
        private Vec3d translation;
        private SoundEvent sound;

        public BlockbenchTransition(float timestamp, Vec3d rotation, Vec3d translation) {
            this.timestamp = timestamp;
            this.rotation = rotation;
            this.translation = translation;
        }

        public void setSound(SoundEvent sound) {
            this.sound = sound;
        }

        public void directTransform() {
            GL11.glTranslated((double)(this.translation.field_72450_a / 25.0), (double)(this.translation.field_72448_b / 25.0), (double)(this.translation.field_72449_c / 25.0));
            GL11.glRotated((double)this.rotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)this.rotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)this.rotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
            GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        }

        public Transition<?> createVMWTransition() {
            return new Transition<Object>(rc -> {
                double mul = 0.01;
                GL11.glTranslated((double)(-this.translation.field_72450_a * mul), (double)(-this.translation.field_72448_b * mul), (double)(this.translation.field_72449_c * mul));
                GL11.glRotated((double)this.rotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
                GL11.glRotated((double)this.rotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)this.rotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
            }, (int)this.timestamp);
        }

        public Transition<?> createVMWTransitionWithADS(Transform normal, Transform ads, double divisor) {
            Transition<Object> trans = new Transition<Object>(rc -> {
                Transform t = normal;
                double rotXMult = 1.0;
                double rotYMult = 1.0;
                double rotZMult = 1.0;
                if (ClientModContext.getContext().getMainHeldWeapon().isAimed()) {
                    rotXMult = 0.1;
                    rotYMult = 0.1;
                    rotZMult = 0.5;
                }
                double tesla = 0.0;
                tesla = divisor == 12.6 ? BBLoader.HANDDIVISOR : (divisor == 5.0 ? BBLoader.GENDIVISOR : divisor);
                double mul = 1.0 / tesla;
                GlStateManager.func_179137_b((double)t.getPositionX(), (double)t.getPositionY(), (double)t.getPositionZ());
                GL11.glTranslated((double)(this.translation.field_72450_a * mul), (double)(-this.translation.field_72448_b * mul), (double)(this.translation.field_72449_c * mul));
                GlStateManager.func_179137_b((double)t.getRotationPointX(), (double)t.getRotationPointY(), (double)t.getRotationPointZ());
                GL11.glRotated((double)t.getRotationZ(), (double)0.0, (double)0.0, (double)1.0);
                GL11.glRotated((double)(this.rotation.field_72449_c * rotZMult), (double)0.0, (double)0.0, (double)1.0);
                GL11.glRotated((double)t.getRotationY(), (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)(this.rotation.field_72448_b * rotYMult), (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)t.getRotationX(), (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)(this.rotation.field_72450_a * rotXMult), (double)1.0, (double)0.0, (double)0.0);
                GlStateManager.func_179137_b((double)(-t.getRotationPointX()), (double)(-t.getRotationPointY()), (double)(-t.getRotationPointZ()));
                GlStateManager.func_179139_a((double)t.getScaleX(), (double)t.getScaleY(), (double)t.getScaleZ());
            }, (int)this.timestamp);
            trans.setSound(this.sound);
            return trans;
        }

        public Transition<?> createVMWTransition(Transform t, double divisor) {
            Transition<Object> trans = new Transition<Object>(rc -> {
                double rotXMult = 1.0;
                double rotYMult = 1.0;
                double rotZMult = 1.0;
                double tesla = 0.0;
                tesla = divisor == 12.6 ? BBLoader.HANDDIVISOR : (divisor == 5.0 ? BBLoader.GENDIVISOR : divisor);
                double mul = 1.0 / tesla;
                GlStateManager.func_179137_b((double)t.getPositionX(), (double)t.getPositionY(), (double)t.getPositionZ());
                GL11.glTranslated((double)(this.translation.field_72450_a * mul), (double)(-this.translation.field_72448_b * mul), (double)(this.translation.field_72449_c * mul));
                GlStateManager.func_179137_b((double)t.getRotationPointX(), (double)t.getRotationPointY(), (double)t.getRotationPointZ());
                GL11.glRotated((double)t.getRotationZ(), (double)0.0, (double)0.0, (double)1.0);
                GL11.glRotated((double)(this.rotation.field_72449_c * rotZMult), (double)0.0, (double)0.0, (double)1.0);
                GL11.glRotated((double)t.getRotationY(), (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)(this.rotation.field_72448_b * rotYMult), (double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)t.getRotationX(), (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)(this.rotation.field_72450_a * rotXMult), (double)1.0, (double)0.0, (double)0.0);
                GlStateManager.func_179137_b((double)(-t.getRotationPointX()), (double)(-t.getRotationPointY()), (double)(-t.getRotationPointZ()));
                GlStateManager.func_179139_a((double)t.getScaleX(), (double)t.getScaleY(), (double)t.getScaleZ());
            }, Math.round(this.timestamp));
            trans.setSound(this.sound);
            return trans;
        }

        public void showDebugCode() {
            System.out.println("GL11.glTranslated(" + this.translation.field_72450_a + ", " + this.translation.field_72448_b + ", " + this.translation.field_72449_c + ");");
            System.out.println("GL11.glRotated(" + this.rotation.field_72449_c + ", 0, 0, 1);");
            System.out.println("GL11.glRotated(" + this.rotation.field_72448_b + ", 0, 1, 0);");
            System.out.println("GL11.glRotated(" + this.rotation.field_72450_a + ", 1, 0, 0);");
            System.out.println("GL11.glScaled(1, 1, 1);");
        }

        public String toString() {
            return "[(" + this.timestamp + ") " + this.rotation + " > " + this.translation + "]";
        }

        public float getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(float timestamp) {
            this.timestamp = timestamp;
        }

        public Vec3d getRotation() {
            return this.rotation;
        }

        public void setRotation(Vec3d rotation) {
            this.rotation = rotation;
        }

        public Vec3d getTranslation() {
            return this.translation;
        }

        public void setTranslation(Vec3d translation) {
            this.translation = translation;
        }
    }
}

