/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation.gui;

import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.animation.gui.AnimationGUI;
import com.paneedah.weaponlib.animation.gui.Button;
import com.paneedah.weaponlib.animation.gui.IElement;
import io.redstudioragnarok.redcore.vectors.Vector2D;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;

public class Panel {
    private static final int BUFFER = 5;
    private ArrayList<Button> buttonList = new ArrayList();
    private ArrayList<IElement> elements = new ArrayList();
    private String title;
    private AnimationGUI gui;
    private double positionX;
    private double positionY;
    private double width;
    private double height;
    private double actualHeight;
    private double buttonSize;
    private boolean grabbed = false;
    private Vector2D originalMouseCoords;
    private Vector2D originalPanelCoords;
    private boolean closed = false;

    public Panel(AnimationGUI gui, String title, double x, double y, double buttonSize) {
        this.title = title;
        this.gui = gui;
        this.positionX = x;
        this.positionY = y;
        this.buttonSize = buttonSize;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bool) {
        this.closed = bool;
    }

    public void handleButtonClicks(int mouseX, int mouseY) {
        if ((double)mouseX >= this.positionX && (double)mouseX <= this.positionX + this.width && (double)mouseY >= this.positionY && (double)mouseY <= this.positionY + this.height) {
            this.gui.guiHoverStatus = true;
        }
        boolean clickedButton = false;
        if (!this.closed) {
            for (Button b : this.buttonList) {
                if (!b.isMouseOver(mouseX, mouseY)) continue;
                clickedButton = true;
                b.onMouseClick();
                this.gui.onAction(b);
            }
        }
        for (IElement e : this.elements) {
            if (!e.cancelGrab(mouseX, mouseY)) continue;
            clickedButton = true;
        }
        if (!clickedButton) {
            if (this.gui.checkIn2DBox(mouseX, mouseY, this.positionX + 2.0, this.positionY + 2.0, 6.0, 6.0)) {
                if (!this.closed) {
                    this.closed = true;
                    this.height = 10.0;
                } else {
                    this.closed = false;
                    this.height = this.actualHeight;
                }
            } else if ((double)mouseX >= this.positionX && (double)mouseX <= this.positionX + this.width && (double)mouseY >= this.positionY && (double)mouseY <= this.positionY + this.height) {
                AnimationModeProcessor.getInstance().permissionToDrag = false;
                AnimationModeProcessor.getInstance().leftLock = true;
                this.grabbed = true;
                this.originalMouseCoords = new Vector2D((double)mouseX, (double)mouseY);
                this.originalPanelCoords = new Vector2D(this.positionX, this.positionY);
            }
        }
    }

    public void onMouseReleased(int mouseX, int mouseY) {
        if (this.grabbed) {
            this.grabbed = false;
        }
    }

    public void addButtons(Button ... buttons) {
        for (Button b : buttons) {
            if ((double)b.size > this.height) {
                this.height = b.size + 15;
            }
            this.width += (double)(b.size + 5);
            this.addButton(b);
        }
        this.width += 5.0;
        this.actualHeight = this.height;
    }

    public void addButton(Button b) {
        b.id = this.buttonList.size();
        this.buttonList.add(b);
    }

    public void addElement(IElement e) {
        if (!this.elements.isEmpty()) {
            e.push(this.elements.get(this.elements.size() - 1).getPush() + 15.0);
        }
        this.elements.add(e);
    }

    public void render(int mouseX, int mouseY) {
        if (this.grabbed) {
            this.positionX = this.originalPanelCoords.x - (this.originalMouseCoords.x - (double)mouseX);
            this.positionY = this.originalPanelCoords.y - (this.originalMouseCoords.y - (double)mouseY);
        }
        if (!this.closed) {
            AnimationGUI.renderRect(new Color(2240318).darker(), this.positionX, this.positionY, this.width, this.height);
        } else {
            AnimationGUI.renderRect(new Color(2240318).darker(), this.positionX, this.positionY, this.width, 10.0);
        }
        Color button = new Color(2240318).darker().darker();
        if (this.gui.checkIn2DBox(mouseX, mouseY, this.positionX + 2.0, this.positionY + 2.0, 6.0, 6.0)) {
            button = button.darker();
        }
        AnimationGUI.renderRect(button, this.positionX + 2.0, this.positionY + 2.0, 6.0, 6.0);
        if (!this.closed) {
            for (Button b : this.buttonList) {
                b.x = this.positionX + (double)(this.buttonList.indexOf(b) * 25) + 5.0;
                b.y = this.positionY + 10.0;
                b.renderButton(mouseX, mouseY);
            }
            for (IElement e : this.elements) {
                e.render(this.positionX, this.positionY, mouseX, mouseY);
            }
        }
        GlStateManager.func_179098_w();
        AnimationGUI.renderScaledString(this.title, this.positionX + 10.0, this.positionY + 2.0, 0.75);
        GlStateManager.func_179090_x();
    }

    public String getTitle() {
        return this.title;
    }

    public ArrayList<Button> getButtonList() {
        return this.buttonList;
    }

    public void setButtonList(ArrayList<Button> buttonList) {
        this.buttonList = buttonList;
    }

    public AnimationGUI getGui() {
        return this.gui;
    }

    public void setGui(AnimationGUI gui) {
        this.gui = gui;
    }

    public double getPositionX() {
        return this.positionX;
    }

    public void setPositionX(double positionX) {
        this.positionX = positionX;
    }

    public double getPositionY() {
        return this.positionY;
    }

    public void setPositionY(double positionY) {
        this.positionY = positionY;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.actualHeight = height;
        this.height = height;
    }

    public double getButtonSize() {
        return this.buttonSize;
    }

    public void setButtonSize(double buttonSize) {
        this.buttonSize = buttonSize;
    }

    public boolean isGrabbed() {
        return this.grabbed;
    }

    public void setGrabbed(boolean grabbed) {
        this.grabbed = grabbed;
    }

    public Vector2D getOriginalMouseCoords() {
        return this.originalMouseCoords;
    }

    public void setOriginalMouseCoords(Vector2D originalMouseCoords) {
        this.originalMouseCoords = originalMouseCoords;
    }

    public Vector2D getOriginalPanelCoords() {
        return this.originalPanelCoords;
    }

    public void setOriginalPanelCoords(Vector2D originalPanelCoords) {
        this.originalPanelCoords = originalPanelCoords;
    }

    public static int getBuffer() {
        return 5;
    }
}

