/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation.gui;

import com.paneedah.weaponlib.animation.gui.AnimationGUI;
import java.awt.Color;
import net.minecraft.client.renderer.GlStateManager;

public class Button {
    public double x = 0.0;
    public double y = 0.0;
    public String tooltip;
    public int id;
    public int size = 0;
    public boolean state = false;
    public boolean isToggle = false;
    public int iconID;

    public Button(String tooltip, int iconID, int x, int y, int size) {
        this.tooltip = tooltip;
        this.x = x;
        this.y = y;
        this.size = size;
        this.iconID = iconID;
    }

    public Button(String tooltip, boolean toggle, int id, int x, int y, int size) {
        this.tooltip = tooltip;
        this.iconID = id;
        this.x = x;
        this.y = y;
        this.size = size;
        this.isToggle = toggle;
    }

    public void renderButton(int mouseX, int mouseY) {
        Color c = new Color(2240318);
        if (this.isMouseOver(mouseX, mouseY)) {
            c = c.darker().darker();
            AnimationGUI.getInstance().but = this;
        }
        AnimationGUI.renderRect(c, this.x, this.y, this.size, this.size);
        GlStateManager.func_179098_w();
        AnimationGUI.renderTexturedRect(this.iconID, this.x + (double)this.size * 0.2, this.y + (double)this.size * 0.1, (double)this.size * 0.6, (double)this.size * 0.6);
        if (this.isToggle()) {
            Color col = this.isState() ? new Color(16697943) : c.darker();
            AnimationGUI.renderRect(col, this.x + (double)this.size * 0.2, this.y + (double)this.size * 0.7, (double)this.size * 0.6, (double)this.size * 0.2);
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return (double)mouseX >= this.x && (double)mouseY >= this.y && (double)mouseX <= this.x + (double)this.size && (double)mouseY <= this.y + (double)this.size;
    }

    public double getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean isState() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public boolean isToggle() {
        return this.isToggle;
    }

    public void setToggle(boolean isToggle) {
        this.isToggle = isToggle;
    }

    public void onMouseClick() {
        if (this.isToggle) {
            this.setState(!this.state);
        }
    }
}

