/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation;

public enum Interpolation {
    LINEAR,
    ACCELERATION,
    DECELERATION,
    SMOOTHSTEP,
    COSINE,
    STEP,
    DAMPEDSPRING;


    public double interpolate(double input) {
        switch (this) {
            case LINEAR: {
                return input;
            }
            case ACCELERATION: {
                return input * input;
            }
            case DECELERATION: {
                return 1.0 - (1.0 - input) * (1.0 - input);
            }
            case SMOOTHSTEP: {
                return input * input * (3.0 - 2.0 * input);
            }
        }
        return input;
    }
}

