/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.KeyBindings;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.tracking.LivingEntityTracker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;

public class DebugPositioner {
    private static final String WEAPONLIB_DEBUG_PROPERTY = "weaponlib.debug";
    private static Boolean debugModeEnabled;
    private static Object currentPart;
    private static Set<Object> debugParts;
    private static Entity watchableEntity;
    private static boolean isAdjustRotationMode;
    private static Map<Object, Position> partPositions;
    private static Map<Integer, TransitionConfiguration> transitionConfigurations;

    public static void setAdjustRotPoint(boolean status) {
        isAdjustRotationMode = status;
    }

    public static Position getCurrentPartPosition() {
        return partPositions.get(currentPart);
    }

    private static Position getDebugPartPosition(Object part) {
        return partPositions.get(part);
    }

    public static Matrix4f rotationMatrix() {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            return new Matrix4f();
        }
        return MatrixHelper.yawPitchRollToMatrix(Math.toRadians(partPosition.yRotation), Math.toRadians(partPosition.xRotation), Math.toRadians(partPosition.zRotation));
    }

    public static void incrementXRotation(float increment) {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        partPosition.xRotation += increment;
        ModReference.LOG.debug("Debug rotations: ({}, {}, {}) ", (Object)Float.valueOf(partPosition.xRotation), (Object)Float.valueOf(partPosition.yRotation), (Object)Float.valueOf(partPosition.zRotation));
    }

    public static void incrementYRotation(float increment) {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        partPosition.yRotation += increment;
        ModReference.LOG.debug("Debug rotations: ({}, {}, {}) ", (Object)Float.valueOf(partPosition.xRotation), (Object)Float.valueOf(partPosition.yRotation), (Object)Float.valueOf(partPosition.zRotation));
    }

    public static void incrementZRotation(float increment) {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        partPosition.zRotation += increment;
        ModReference.LOG.debug("Debug rotations: ({}, {}, {}) ", (Object)Float.valueOf(partPosition.xRotation), (Object)Float.valueOf(partPosition.yRotation), (Object)Float.valueOf(partPosition.zRotation));
    }

    public static void incrementXPosition(float increment, boolean altMode) {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        if (altMode) {
            partPosition.rOffsetX += partPosition.step * increment;
            ModReference.LOG.debug("Debug roffset: ({}, {}, {}) ", (Object)Float.valueOf(partPosition.rOffsetX), (Object)Float.valueOf(partPosition.rOffsetY), (Object)Float.valueOf(partPosition.rOffsetZ));
        } else {
            partPosition.x += partPosition.step * increment;
            ModReference.LOG.debug("Debug position: ({}, {}, {}) ", (Object)Float.valueOf(partPosition.x), (Object)Float.valueOf(partPosition.y), (Object)Float.valueOf(partPosition.z));
        }
    }

    public static void incrementYPosition(float increment, boolean altMode) {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        if (altMode) {
            partPosition.rOffsetY += partPosition.step * increment;
            ModReference.LOG.debug("Debug roffset: ({}, {}, {}) ", (Object)Float.valueOf(partPosition.rOffsetX), (Object)Float.valueOf(partPosition.rOffsetY), (Object)Float.valueOf(partPosition.rOffsetZ));
        } else {
            partPosition.y += partPosition.step * increment;
            ModReference.LOG.debug("Debug position: ({}, {}, {}) ", (Object)Float.valueOf(partPosition.x), (Object)Float.valueOf(partPosition.y), (Object)Float.valueOf(partPosition.z));
        }
    }

    public static void incrementZPosition(float increment, boolean altMode) {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        if (altMode) {
            partPosition.rOffsetZ += partPosition.step * increment;
            ModReference.LOG.debug("Debug roffset: ({}, {}, {}) ", (Object)Float.valueOf(partPosition.rOffsetX), (Object)Float.valueOf(partPosition.rOffsetY), (Object)Float.valueOf(partPosition.rOffsetZ));
        } else {
            partPosition.z += partPosition.step * increment;
            ModReference.LOG.debug("Debug position: ({}, {}, {}) ", (Object)Float.valueOf(partPosition.x), (Object)Float.valueOf(partPosition.y), (Object)Float.valueOf(partPosition.z));
        }
    }

    public static void setScale(float scale) {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        partPosition.scale = scale;
        ModReference.LOG.debug("Scale set to {}", (Object)Float.valueOf(scale));
    }

    public static void setStep(float step) {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        partPosition.step = step;
        ModReference.LOG.debug("Step set to {}", (Object)Float.valueOf(step));
    }

    public static void setDebugMode(boolean enabled) {
        debugModeEnabled = enabled;
        if (debugModeEnabled.booleanValue()) {
            KeyBindings.bindDebugKeys();
        }
    }

    public static boolean isDebugModeEnabled() {
        if (debugModeEnabled == null) {
            debugModeEnabled = Boolean.getBoolean(WEAPONLIB_DEBUG_PROPERTY);
        }
        return debugModeEnabled;
    }

    public static void reset() {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        transitionConfigurations.clear();
        partPosition.rOffsetZ = 0.0f;
        partPosition.rOffsetY = 0.0f;
        partPosition.rOffsetX = 0.0f;
        partPosition.zrpm = 0.0f;
        partPosition.yrpm = 0.0f;
        partPosition.xrpm = 0.0f;
        partPosition.zRotation = 0.0f;
        partPosition.yRotation = 0.0f;
        partPosition.xRotation = 0.0f;
        partPosition.z = 0.0f;
        partPosition.y = 0.0f;
        partPosition.x = 0.0f;
        partPosition.scale = 1.0f;
        partPosition.step = 0.025f;
    }

    public static void setDebugPart(Object part) {
        currentPart = part;
        debugParts.add(part);
        partPositions.computeIfAbsent(part, p -> new Position());
    }

    public static Object getDebugPart() {
        return currentPart;
    }

    public static void configureTransitionPause(int transitionNumber, long pause) {
        TransitionConfiguration transitionConfiguration = DebugPositioner.getTransitionConfiguration(transitionNumber, true);
        transitionConfiguration.pause = pause;
    }

    public static TransitionConfiguration getTransitionConfiguration(int transitionNumber, boolean init) {
        return transitionConfigurations.computeIfAbsent(transitionNumber, k -> init ? new TransitionConfiguration() : null);
    }

    public static void position(Object part, Object renderContext) {
        boolean legacy = false;
        if (!debugParts.contains(part)) {
            return;
        }
        Position partPosition = DebugPositioner.getDebugPartPosition(part);
        if (partPosition == null) {
            return;
        }
        DebugPositioner.updateAutoIncrements(partPosition);
        GL11.glScalef((float)partPosition.scale, (float)partPosition.scale, (float)partPosition.scale);
        if (isAdjustRotationMode) {
            GL11.glTranslatef((float)partPosition.rOffsetX, (float)partPosition.rOffsetY, (float)partPosition.rOffsetZ);
            GL11.glTranslatef((float)partPosition.x, (float)partPosition.y, (float)partPosition.z);
            GL11.glRotatef((float)partPosition.zRotation, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)partPosition.yRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)partPosition.xRotation, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)(-partPosition.rOffsetX), (float)(-partPosition.rOffsetY), (float)(-partPosition.rOffsetZ));
        } else {
            GL11.glTranslatef((float)partPosition.x, (float)partPosition.y, (float)partPosition.z);
            GL11.glTranslatef((float)partPosition.rOffsetX, (float)partPosition.rOffsetY, (float)partPosition.rOffsetZ);
            GL11.glRotatef((float)partPosition.zRotation, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)partPosition.xRotation, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)partPosition.yRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)(-partPosition.rOffsetX), (float)(-partPosition.rOffsetY), (float)(-partPosition.rOffsetZ));
        }
    }

    private static void updateAutoIncrements(Position partPosition) {
        if (partPosition.xrpm > 0.0f || partPosition.yrpm > 0.0f || partPosition.zrpm > 0.0f) {
            long timeSinceLastIncrement = System.currentTimeMillis() - partPosition.lastAutorotationTimestamp;
            if (partPosition.xrpm > 0.0f) {
                float rpms = partPosition.xrpm / 60000.0f;
                float expectedRotations = (float)timeSinceLastIncrement * rpms;
                float expectedDegrees = expectedRotations * 360.0f;
                partPosition.xRotation += expectedDegrees;
                partPosition.xRotation %= 360.0f;
            } else if (partPosition.yrpm > 0.0f) {
                float rpms = partPosition.yrpm / 60000.0f;
                float expectedRotations = (float)timeSinceLastIncrement * rpms;
                float expectedDegrees = expectedRotations * 360.0f;
                partPosition.yRotation += expectedDegrees;
                partPosition.yRotation %= 360.0f;
            } else if (partPosition.zrpm > 0.0f) {
                float rpms = partPosition.zrpm / 60000.0f;
                float expectedRotations = (float)timeSinceLastIncrement * rpms;
                float expectedDegrees = expectedRotations * 360.0f;
                partPosition.zRotation += expectedDegrees;
                partPosition.zRotation %= 360.0f;
            }
            partPosition.lastAutorotationTimestamp = System.currentTimeMillis();
        }
    }

    public static void showCode() {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            return;
        }
        if (isAdjustRotationMode) {
            StringBuilder result = new StringBuilder();
            result.append("Positioners.position(\n");
            result.append(String.format("    %ff, %ff, %ff,\n", Float.valueOf(partPosition.x), Float.valueOf(partPosition.y), Float.valueOf(partPosition.z)));
            result.append(String.format("    %ff, %ff, %ff,\n", Float.valueOf(partPosition.xRotation), Float.valueOf(partPosition.yRotation), Float.valueOf(partPosition.zRotation)));
            result.append(String.format("    %ff, %ff, %ff,\n", Float.valueOf(partPosition.rOffsetX), Float.valueOf(partPosition.rOffsetY), Float.valueOf(partPosition.rOffsetZ)));
            result.append(String.format("    %ff, %ff, %ff\n", Float.valueOf(partPosition.scale), Float.valueOf(partPosition.scale), Float.valueOf(partPosition.scale)));
            result.append(");\n");
            ModReference.LOG.debug("Generated positioning code: \n" + result);
            System.out.println("\n" + result);
        } else {
            System.out.println(ClientProxy.MC.field_71439_g.func_184614_ca());
            StringBuilder result = new StringBuilder();
            result.append(String.format("GL11.glScalef(%ff, %ff, %ff);\n", Float.valueOf(partPosition.scale), Float.valueOf(partPosition.scale), Float.valueOf(partPosition.scale)));
            result.append(String.format("GL11.glTranslatef(%ff, %ff, %ff);\n", Float.valueOf(partPosition.x), Float.valueOf(partPosition.y), Float.valueOf(partPosition.z)));
            result.append(String.format("GL11.glTranslatef(%ff, %ff, %ff);\n", Float.valueOf(partPosition.rOffsetX), Float.valueOf(partPosition.rOffsetY), Float.valueOf(partPosition.rOffsetZ)));
            result.append(String.format("GL11.glRotatef(%ff, 0f, 0f, 1f);\n", Float.valueOf(partPosition.zRotation)));
            result.append(String.format("GL11.glRotatef(%ff, 1f, 0f, 0f);\n", Float.valueOf(partPosition.xRotation)));
            result.append(String.format("GL11.glRotatef(%ff, 0f, 1f, 0f);\n", Float.valueOf(partPosition.yRotation)));
            result.append(String.format("GL11.glTranslatef(%ff, %ff, %ff);", Float.valueOf(-partPosition.rOffsetX), Float.valueOf(-partPosition.rOffsetY), Float.valueOf(-partPosition.rOffsetZ)));
            ModReference.LOG.debug("Generated positioning code: \n" + result);
            System.out.println("\n" + result);
        }
    }

    public static void watch() {
        LivingEntityTracker tracker = LivingEntityTracker.getTracker((EntityLivingBase)ClientProxy.MC.field_71439_g);
        System.out.println("Trackable entities: " + tracker.getTrackableEntitites());
    }

    public static Entity getWatchableEntity() {
        return watchableEntity;
    }

    public static void showCurrentMatrix(String message) {
        DebugPositioner.showCurrentMatrix(null, message);
    }

    public static void showCurrentMatrix(Object part, String message) {
        if (part != null && part != currentPart) {
            return;
        }
        Matrix4f preparedPositionMatrix = MatrixHelper.captureMatrix();
        ModReference.LOG.trace("Current matrix: {} {}", (Object)message, (Object)DebugPositioner.formatMatrix(preparedPositionMatrix));
    }

    public static String formatMatrix(Matrix4f m) {
        StringBuilder buf = new StringBuilder();
        buf.append("\n");
        buf.append(String.format("%4.2f %4.2f %4.2f %4.2f\n", Float.valueOf(m.m00), Float.valueOf(m.m10), Float.valueOf(m.m20), Float.valueOf(m.m30)));
        buf.append(String.format("%4.2f %4.2f %4.2f %4.2f\n", Float.valueOf(m.m01), Float.valueOf(m.m11), Float.valueOf(m.m21), Float.valueOf(m.m31)));
        buf.append(String.format("%4.2f %4.2f %4.2f %4.2f\n", Float.valueOf(m.m02), Float.valueOf(m.m12), Float.valueOf(m.m22), Float.valueOf(m.m32)));
        buf.append(String.format("%4.2f %4.2f %4.2f %4.2f\n", Float.valueOf(m.m03), Float.valueOf(m.m13), Float.valueOf(m.m23), Float.valueOf(m.m33)));
        return buf.toString();
    }

    public static void setAutorotate(float xrpm, float yrpm, float zrpm) {
        Position partPosition = DebugPositioner.getCurrentPartPosition();
        if (partPosition == null) {
            ClientProxy.MC.field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Debug part not selected"));
            return;
        }
        isAdjustRotationMode = xrpm > 0.0f || yrpm > 0.0f || zrpm > 0.0f;
        partPosition.xrpm = xrpm;
        if (xrpm > 0.0f) {
            partPosition.zRotation = 0.0f;
            partPosition.yRotation = 0.0f;
        }
        partPosition.yrpm = yrpm;
        if (yrpm > 0.0f) {
            partPosition.zRotation = 0.0f;
            partPosition.xRotation = 0.0f;
        }
        partPosition.zrpm = zrpm;
        if (zrpm > 0.0f) {
            partPosition.yRotation = 0.0f;
            partPosition.xRotation = 0.0f;
        }
    }

    static {
        debugParts = new HashSet<Object>();
        partPositions = new HashMap<Object, Position>();
        transitionConfigurations = new HashMap<Integer, TransitionConfiguration>();
    }

    public static class Position {
        public float xRotation;
        public float yRotation;
        public float zRotation;
        public float x;
        public float y;
        public float z;
        public float rOffsetX;
        public float rOffsetY;
        public float rOffsetZ;
        public float scale = 1.0f;
        public float step = 0.025f;
        public float xrpm;
        public float yrpm;
        public float zrpm;
        private long lastAutorotationTimestamp = System.currentTimeMillis();
    }

    public static final class TransitionConfiguration {
        private long pause;

        public long getPause() {
            return this.pause;
        }

        public void setPause(long pause) {
            this.pause = pause;
        }
    }
}

