/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.ai;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.EntityPickupMessage;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.Configurable;
import com.paneedah.weaponlib.Contextual;
import com.paneedah.weaponlib.CustomArmor;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ItemMagazine;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.PlayerItemInstanceFactory;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.Tags;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.WeaponAttachmentAspect;
import com.paneedah.weaponlib.WeaponFireAspect;
import com.paneedah.weaponlib.WeaponSpawnEntity;
import com.paneedah.weaponlib.ai.CustomMobAttack;
import com.paneedah.weaponlib.ai.EntityClassFactory;
import com.paneedah.weaponlib.ai.EntityConfiguration;
import com.paneedah.weaponlib.ai.Timeable;
import com.paneedah.weaponlib.compatibility.CompatibleDataManager;
import com.paneedah.weaponlib.grenade.GrenadeAttackAspect;
import com.paneedah.weaponlib.grenade.ItemGrenade;
import com.paneedah.weaponlib.grenade.PlayerGrenadeInstance;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityCustomMob
extends EntityMob
implements IRangedAttackMob,
Contextual,
Configurable<EntityConfiguration> {
    private static final float FLAT_WORLD_SPAWN_CHANCE = 0.01f;
    private static final CompatibleDataManager.Key VARIANT = CompatibleDataManager.createKey(EntityCustomMob.class, Integer.TYPE);
    private static final CompatibleDataManager.Key SWINGING_ARMS = CompatibleDataManager.createKey(EntityCustomMob.class, Boolean.TYPE);
    private static final CompatibleDataManager.Key DELAYED_ATTACK_TIMER_INCREMENT = CompatibleDataManager.createKey(EntityCustomMob.class, Integer.TYPE);
    private static final CompatibleDataManager.Key DELAYED_ATTACK_STARTED = CompatibleDataManager.createKey(EntityCustomMob.class, Boolean.TYPE);
    protected CompatibleDataManager compatibleDataManager;
    private ModContext modContext;
    private EntityConfiguration configuration;
    private ItemStack secondaryEquipment;
    private int delayedAttackTimer;
    private EntityPlayer customer;

    public EntityCustomMob(World worldIn) {
        super(worldIn);
        this.func_70105_a(this.getConfiguration().getSizeWidth(), this.getConfiguration().getSizeHeight());
    }

    public Vec3d func_174824_e(float partialTicks) {
        return super.func_174824_e(partialTicks);
    }

    public String getMobName() {
        return this.configuration.getMobName();
    }

    @Override
    public EntityConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = EntityClassFactory.getInstance().getConfiguration(this.getClass());
        }
        return this.configuration;
    }

    public AxisAlignedBB func_70046_E() {
        return super.func_70046_E();
    }

    public AxisAlignedBB func_174813_aQ() {
        return super.func_174813_aQ();
    }

    public void func_174826_a(AxisAlignedBB bb) {
        super.func_174826_a(bb);
    }

    protected void func_184651_r() {
        this.func_70105_a(this.getConfiguration().getSizeWidth(), this.getConfiguration().getSizeHeight());
        this.getConfiguration().addAiTasks((EntityLiving)this, this.field_70714_bg);
        this.getConfiguration().addAiTargetTasks((EntityLiving)this, this.field_70715_bh);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.getConfiguration().getFollowRange());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getConfiguration().getMaxSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getConfiguration().getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getConfiguration().getCollisionAttackDamage());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.compatibleDataManager = new CompatibleDataManager(this.field_70180_af);
        this.compatibleDataManager.register(VARIANT, 0);
        this.compatibleDataManager.register(SWINGING_ARMS, false);
        this.compatibleDataManager.register(DELAYED_ATTACK_TIMER_INCREMENT, 0);
        this.compatibleDataManager.register(DELAYED_ATTACK_STARTED, false);
    }

    protected SoundEvent func_184639_G() {
        return this.getConfiguration().getAmbientSound();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return this.getConfiguration().getHurtSound();
    }

    protected SoundEvent func_184615_bR() {
        return this.getConfiguration().getDeathSound();
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.getConfiguration().getStepSound(), 0.15f, 1.0f);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return this.getConfiguration().getCreatureAttribute();
    }

    public void func_70636_d() {
        if (this.func_70089_S() && this.getConfiguration().getDelayedAttack() != null) {
            if (this.isDelayedAttackStarted()) {
                this.setDelayedAttackTimerIncrement(1);
            }
            int delayedAttackTimerIncrement = this.getDelayedAttackTimerIncrement();
            this.delayedAttackTimer += delayedAttackTimerIncrement;
            if (this.delayedAttackTimer < 0) {
                this.delayedAttackTimer = 0;
            }
            if (this.delayedAttackTimer >= ((Timeable)((Object)this.getConfiguration().getDelayedAttack())).getDuration()) {
                this.completeDelayedAttack();
            }
        }
        super.func_70636_d();
    }

    private void completeDelayedAttack() {
        CustomMobAttack delayedAttack = this.configuration.getDelayedAttack();
        if (delayedAttack != null) {
            delayedAttack.attackEntity(this, (Entity)this.func_70638_az());
        }
    }

    public void func_70645_a(DamageSource cause) {
        ItemStack itemStack = this.func_184614_ca();
        if (!this.field_70170_p.field_72995_K && itemStack != null) {
            this.initAmmo(itemStack);
        }
        super.func_70645_a(cause);
        Entity trueDamageSource = cause.func_76346_g();
        if (trueDamageSource instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)trueDamageSource;
            entityplayer.func_71029_a(StatList.field_188070_B);
        }
        if (this.secondaryEquipment != null && this.field_70146_Z.nextFloat() < this.getConfiguration().getPrimaryEquipmentDropChance()) {
            this.func_70099_a(this.secondaryEquipment, 0.0f);
        }
    }

    private void initAmmo(ItemStack itemStack) {
        PlayerItemInstance<?> instance = Tags.getInstance(itemStack);
        if (instance instanceof PlayerWeaponInstance) {
            PlayerWeaponInstance weaponInstance = (PlayerWeaponInstance)instance;
            ItemMagazine existingMagazine = (ItemMagazine)WeaponAttachmentAspect.getActiveAttachment(AttachmentCategory.MAGAZINE, weaponInstance);
            int maxAmmo = 0;
            if (existingMagazine != null) {
                maxAmmo = existingMagazine.getCapacity();
            } else if (weaponInstance.getWeapon().getAmmoCapacity() > 0) {
                maxAmmo = weaponInstance.getWeapon().getAmmoCapacity();
            }
            if (maxAmmo > 0) {
                weaponInstance.setAmmo(this.field_70146_Z.nextInt(maxAmmo));
                Tags.setInstance(itemStack, weaponInstance);
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.getConfiguration().getLootTable();
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.setArmorEquipment();
        this.setPrimaryEquipment();
        this.setSecondaryEquipment();
    }

    private void setArmorEquipment() {
        EntityConfiguration configuration = this.getConfiguration();
        Arrays.fill(this.field_184655_bs, configuration.getArmorDropChance());
        for (CustomArmor armor : configuration.getArmorSet()) {
            this.func_184201_a(armor.getCompatibleEquipmentSlot(), new ItemStack((Item)armor));
        }
    }

    private void setSecondaryEquipment() {
        EntityConfiguration configuration = this.getConfiguration();
        EntityConfiguration.Equipment secondaryEquipment = configuration.getSecondaryEquipmentOptions().pick(this.field_70170_p.func_175659_aa());
        if (secondaryEquipment != null) {
            ItemStack equipmentItemStack = new ItemStack(secondaryEquipment.item);
            if (secondaryEquipment.item instanceof ItemGrenade) {
                this.initGrenade(secondaryEquipment, equipmentItemStack);
            }
            this.secondaryEquipment = equipmentItemStack;
        }
    }

    public void func_184598_c(EnumHand hand) {
        ItemStack itemstack = this.func_184586_b(hand);
        if (itemstack != null && !this.func_184587_cr()) {
            this.field_184627_bm = itemstack;
            this.field_184628_bn = 100;
            if (!this.field_70170_p.field_72995_K) {
                int i = 1;
                if (hand == EnumHand.OFF_HAND) {
                    i |= 2;
                }
                this.field_70180_af.func_187227_b(field_184621_as, (Object)((byte)i));
            }
        }
    }

    private void setPrimaryEquipment() {
        EntityConfiguration configuration = this.getConfiguration();
        EntityConfiguration.Equipment equipment = configuration.getEquipmentOptions().pick(this.field_70170_p.func_175659_aa());
        Arrays.fill(this.field_82174_bp, configuration.getPrimaryEquipmentDropChance());
        if (equipment != null) {
            ItemStack equipmentItemStack = new ItemStack(equipment.item);
            if (equipment.item instanceof Weapon) {
                this.initWeaponWithAttachments(equipment, equipmentItemStack);
            } else if (equipment.item instanceof ItemGrenade) {
                this.initGrenade(equipment, equipmentItemStack);
            }
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, equipmentItemStack);
        }
    }

    private void initWeaponWithAttachments(EntityConfiguration.Equipment equipment, ItemStack itemStack) {
        if (equipment.attachments != null && equipment.item instanceof Weapon && equipment.item instanceof PlayerItemInstanceFactory) {
            PlayerWeaponInstance weaponInstance = (PlayerWeaponInstance)((PlayerItemInstanceFactory)equipment.item).createItemInstance((EntityLivingBase)this, new ItemStack(equipment.item), 0);
            for (ItemAttachment<Weapon> itemAttachment : equipment.attachments) {
                Set<ItemAttachment<Weapon>> compatibleAttachments = weaponInstance.getWeapon().getCompatibleAttachments().keySet();
                compatibleAttachments.contains(itemAttachment);
                WeaponAttachmentAspect.addAttachment(itemAttachment, weaponInstance);
            }
            Tags.setInstance(itemStack, weaponInstance);
            Tags.setAmmo(itemStack, this.getConfiguration().getMaxAmmo());
        }
    }

    private void initGrenade(EntityConfiguration.Equipment equipment, ItemStack itemStack) {
        if (equipment.item instanceof ItemGrenade) {
            PlayerGrenadeInstance grenadeInstance = (PlayerGrenadeInstance)((PlayerItemInstanceFactory)equipment.item).createItemInstance((EntityLivingBase)this, new ItemStack(equipment.item), 0);
            grenadeInstance.setThrowingFar(true);
            Tags.setInstance(itemStack, grenadeInstance);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        List<EntityConfiguration.TexturedModel> variants = this.getConfiguration().getTexturedModelVariants();
        int variant = 0;
        if (!variants.isEmpty()) {
            variant = this.field_70146_Z.nextInt(variants.size());
        }
        this.setVariant(variant);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        return livingdata;
    }

    public boolean func_70652_k(Entity target) {
        EntityConfiguration configuration = this.getConfiguration();
        CustomMobAttack collisionAttack = configuration.getCollisionAttack();
        if (collisionAttack != null) {
            return collisionAttack.attackEntity(this, target);
        }
        return super.func_70652_k(target);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.modContext == null) {
            return;
        }
        ItemStack itemStack = this.func_184614_ca();
        if (itemStack == null) {
            return;
        }
        if (itemStack.func_77973_b() instanceof Weapon) {
            WeaponFireAspect fireAspect = this.modContext.getWeaponFireAspect();
            BiFunction<Weapon, EntityLivingBase, WeaponSpawnEntity> spawnEntityWith = (weapon, player) -> {
                int difficultyId = this.field_70170_p.func_175659_aa().func_151525_a();
                float inaccuracy = weapon.getInaccuracy() + (3.0f - (float)difficultyId) * 0.5f;
                WeaponSpawnEntity bullet = new WeaponSpawnEntity((Weapon)weapon, this.field_70170_p, (EntityLivingBase)player, weapon.getSpawnEntityVelocity(), weapon.getSpawnEntityGravityVelocity(), inaccuracy, weapon.getSpawnEntityDamage() * 0.01f * 0.2f, weapon.getSpawnEntityExplosionRadius(), false, false, 1.0f, 1.0f, 1.5f, 1.0f, -1, -1);
                bullet.setPositionAndDirection(true);
                return bullet;
            };
            fireAspect.serverFire((EntityLivingBase)this, itemStack, spawnEntityWith, false, false, 0.2f);
        } else if (itemStack.func_77973_b() instanceof ItemGrenade) {
            float rotationPitchAdjustment = 20.0f;
            this.field_70125_A -= rotationPitchAdjustment;
            PlayerGrenadeInstance grenadeInstance = (PlayerGrenadeInstance)Tags.getInstance(itemStack);
            GrenadeAttackAspect.serverThrowGrenade(this.modContext, (EntityLivingBase)this, grenadeInstance, System.currentTimeMillis() + 2000L);
            this.field_70125_A += rotationPitchAdjustment;
        }
    }

    void attackWithSecondaryEquipment(EntityLivingBase target, float distanceFactor) {
        if (this.modContext == null) {
            return;
        }
        if (this.secondaryEquipment == null) {
            return;
        }
        if (this.secondaryEquipment.func_77973_b() instanceof ItemGrenade) {
            float rotationPitchAdjustment = 20.0f;
            this.field_70125_A -= rotationPitchAdjustment;
            PlayerGrenadeInstance grenadeInstance = (PlayerGrenadeInstance)Tags.getInstance(this.secondaryEquipment);
            GrenadeAttackAspect.serverThrowGrenade(this.modContext, (EntityLivingBase)this, grenadeInstance, System.currentTimeMillis() + 2000L);
            this.field_70125_A += rotationPitchAdjustment;
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        int variant = compound.func_74762_e("Variant");
        this.setVariant(variant);
        int delayedAttackTimerIncrement = compound.func_74762_e("DATI");
        this.setDelayedAttackTimerIncrement(delayedAttackTimerIncrement);
        NBTTagCompound secondaryNbt = compound.func_74775_l("Secondary");
        if (secondaryNbt != null) {
            this.secondaryEquipment = new ItemStack(secondaryNbt);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("DATI", this.getDelayedAttackTimerIncrement());
        if (this.secondaryEquipment != null) {
            compound.func_74782_a("Secondary", (NBTBase)this.secondaryEquipment.func_77955_b(new NBTTagCompound()));
        }
    }

    public float func_70047_e() {
        return super.func_70047_e();
    }

    public double func_70033_W() {
        return -0.35;
    }

    public int getVariant() {
        return this.compatibleDataManager.get(VARIANT).intValue();
    }

    public void setVariant(int variant) {
        this.compatibleDataManager.set(VARIANT, variant);
    }

    public boolean isSwingingArms() {
        return this.compatibleDataManager.get(SWINGING_ARMS).booleanValue();
    }

    public void func_184724_a(boolean swingingArms) {
        this.compatibleDataManager.set(SWINGING_ARMS, swingingArms);
    }

    protected boolean func_70814_o() {
        Predicate<Entity> predicate = this.getConfiguration().isValidLightLevel();
        return predicate != null ? predicate.test((Entity)this) : super.func_70814_o();
    }

    public float func_180484_a(BlockPos pos) {
        return this.getConfiguration().getMaxTolerableLightBrightness() - this.field_70170_p.func_175724_o(pos);
    }

    protected boolean func_70692_ba() {
        return this.getConfiguration().isDespawnable();
    }

    public void func_70108_f(Entity entityIn) {
        if (this.func_70104_M()) {
            super.func_70108_f(entityIn);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.func_70104_M()) {
            super.func_82167_n(entityIn);
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        super.func_70100_b_(entityIn);
    }

    public EnumPushReaction func_184192_z() {
        if (this.func_70104_M()) {
            return super.func_184192_z();
        }
        return EnumPushReaction.IGNORE;
    }

    public boolean func_70104_M() {
        return this.getConfiguration().isPushable();
    }

    public boolean func_180431_b(DamageSource source) {
        return this.getConfiguration().isInvulnerable() || super.func_180431_b(source);
    }

    public boolean func_70067_L() {
        return this.getConfiguration().isCollidable() || super.func_70067_L();
    }

    public boolean func_70601_bi() {
        boolean canSpawn = this.field_70170_p.func_175624_G() != WorldType.field_77138_c || this.field_70146_Z.nextFloat() > 0.99f;
        Predicate<Entity> predicate = this.getConfiguration().getCanSpawnHere();
        return canSpawn && (predicate != null ? predicate.test((Entity)this) : super.func_70601_bi());
    }

    @Override
    public void setContext(ModContext modContext) {
        this.modContext = modContext;
    }

    public ItemStack getSecondaryEquipment() {
        return this.secondaryEquipment;
    }

    public void setDelayedAttackTimerIncrement(int increment) {
        this.compatibleDataManager.set(DELAYED_ATTACK_TIMER_INCREMENT, increment);
    }

    public int getDelayedAttackTimerIncrement() {
        return this.compatibleDataManager.get(DELAYED_ATTACK_TIMER_INCREMENT).intValue();
    }

    public boolean isDelayedAttackStarted() {
        return this.compatibleDataManager.get(DELAYED_ATTACK_STARTED).booleanValue();
    }

    public void startDelayedAttack() {
        this.compatibleDataManager.set(DELAYED_ATTACK_STARTED, true);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean flag;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = flag = itemstack.func_77973_b() == Items.field_151057_cb;
        if (this.configuration.getPickupItemID() != -1) {
            MWC.CHANNEL.sendToServer((IMessage)new EntityPickupMessage(player.func_145782_y(), this.func_145782_y()));
            return true;
        }
        if (flag) {
            itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
        if (this.func_70089_S() && !player.func_70093_af()) {
            return false;
        }
        return super.func_184645_a(player, hand);
    }
}

