/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.capabilities.EquipmentCapability;
import com.paneedah.mwc.equipment.inventory.EquipmentInventory;
import com.paneedah.mwc.equipment.inventory.carryable.backpack.BackpackInventory;
import com.paneedah.mwc.network.NetworkPermitManager;
import com.paneedah.mwc.network.TypeRegistry;
import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ItemBullet;
import com.paneedah.weaponlib.ItemMagazine;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.Tags;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.WeaponAttachmentAspect;
import com.paneedah.weaponlib.WeaponRenderer;
import com.paneedah.weaponlib.WeaponState;
import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.state.Aspect;
import com.paneedah.weaponlib.state.Permit;
import com.paneedah.weaponlib.state.StateManager;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class WeaponReloadAspect
implements Aspect<WeaponState, PlayerWeaponInstance> {
    private static final long ALERT_TIMEOUT = 500L;
    private static final long INSPECT_TIMEOUT = 500L;
    private static final long UNLOAD_TIMEOUT = 1000L;
    private static final Set<WeaponState> ALLOWED_UPDATE_FROM_STATES;
    private static Predicate<PlayerWeaponInstance> hasNextLoadIteration;
    private static Predicate<PlayerWeaponInstance> supportsDirectBulletLoad;
    private static Predicate<PlayerWeaponInstance> magazineAttached;
    private static Predicate<PlayerWeaponInstance> hasAmmo;
    private static Predicate<PlayerWeaponInstance> loadIterationCompleted;
    private static Predicate<PlayerWeaponInstance> allLoadIterationsCompleted;
    private static Predicate<PlayerWeaponInstance> reloadAnimationCompleted;
    private static Predicate<PlayerWeaponInstance> magSwapCompleted;
    private static Predicate<PlayerWeaponInstance> reloadMidpoint;
    private static Predicate<PlayerWeaponInstance> unloadTimeoutExpired;
    private static Predicate<PlayerWeaponInstance> awaitFurtherLoadInstructionCompleted;
    private static Predicate<PlayerWeaponInstance> loadAfterUnloadEnabled;
    private static Predicate<PlayerWeaponInstance> unloadAnimationCompleted;
    private static Predicate<PlayerWeaponInstance> prepareFirstLoadIterationAnimationCompleted;
    private static Predicate<PlayerWeaponInstance> shouldFinishCompoundReload;
    private Predicate<PlayerWeaponInstance> inventoryHasFreeSlots = weaponInstance -> weaponInstance.getPlayer() instanceof EntityPlayer && ((EntityPlayer)weaponInstance.getPlayer()).field_71071_by.func_70447_i() != -1;
    private static Predicate<PlayerWeaponInstance> alertTimeoutExpired;
    private static Predicate<PlayerWeaponInstance> inspectTimeoutExpired;
    private static Predicate<PlayerWeaponInstance> drawingAnimationCompleted;
    private ModContext modContext;
    private NetworkPermitManager permitManager;
    private StateManager<WeaponState, ? super PlayerWeaponInstance> stateManager;
    public ItemAttachment<Weapon> previousMagazine;

    public WeaponReloadAspect(ModContext modContext) {
        this.modContext = modContext;
    }

    @Override
    public void setStateManager(StateManager<WeaponState, ? super PlayerWeaponInstance> stateManager) {
        if (this.permitManager == null) {
            throw new IllegalStateException("Permit manager not initialized");
        }
        this.stateManager = stateManager.in(this).change(WeaponState.READY).to(WeaponState.AWAIT_FURTHER_LOAD_INSTRUCTIONS).manual().in(this).change(WeaponState.READY).to(WeaponState.COMPOUND_REQUESTED).manual().in(this).change(WeaponState.COMPOUND_RELOAD_EMPTY).to(WeaponState.COMPOUND_RELOAD_EMPTY).when(reloadMidpoint.and(magSwapCompleted.negate())).withAction(this::clientCompoundReload).automatic().in(this).change(WeaponState.COMPOUND_RELOAD).to(WeaponState.COMPOUND_RELOAD).when(reloadMidpoint.and(magSwapCompleted.negate())).withAction(this::clientCompoundReload).automatic().in(this).change(WeaponState.READY).to(WeaponState.COMPOUND_RELOAD).manual().in(this).change(WeaponState.READY).to(WeaponState.COMPOUND_RELOAD_EMPTY).manual().in(this).change(WeaponState.READY).to(WeaponState.TACTICAL_RELOAD).manual().in(this).change(WeaponState.AWAIT_FURTHER_LOAD_INSTRUCTIONS).to(WeaponState.READY).when(awaitFurtherLoadInstructionCompleted).withAction(this::noFurtherLoadInstructionsReceived).automatic().in(this).change(WeaponState.AWAIT_FURTHER_LOAD_INSTRUCTIONS).to(WeaponState.READY).withAction(this::furtherLoadInstructionsReceived).manual().in(this).change(WeaponState.COMPOUND_REQUESTED).to(WeaponState.READY).when(awaitFurtherLoadInstructionCompleted).withAction(this::noCompoundInstructionsReceived).automatic().in(this).change(WeaponState.COMPOUND_REQUESTED).to(WeaponState.READY).withAction(this::compoundInstructionsReceived).manual().in(this).change(WeaponState.READY).to(WeaponState.LOAD).when(supportsDirectBulletLoad.or(magazineAttached.negate())).withPermit((s, es) -> new LoadPermit((WeaponState)s), this.modContext.getPlayerItemInstanceRegistry()::update, this.permitManager).withAction((c, f, t, p) -> this.completeClientLoad((PlayerWeaponInstance)c, (LoadPermit)p)).manual().in(this).change(WeaponState.UNLOAD).to(WeaponState.LOAD).when(loadAfterUnloadEnabled.and(supportsDirectBulletLoad.or(magazineAttached.negate()))).withPermit((s, es) -> new LoadPermit((WeaponState)s), this.modContext.getPlayerItemInstanceRegistry()::update, this.permitManager).withAction((c, f, t, p) -> this.completeClientLoad((PlayerWeaponInstance)c, (LoadPermit)p)).manual().in(this).change(WeaponState.LOAD).to(WeaponState.READY).when(reloadAnimationCompleted.and(hasNextLoadIteration.negate())).automatic().in(this).change(WeaponState.TACTICAL_RELOAD).to(WeaponState.COMPOUND_RELOAD_FINISH).when(reloadAnimationCompleted.and(hasNextLoadIteration.negate())).withAction((c, f, t, p) -> this.obamaCorporation((PlayerWeaponInstance)c)).automatic().in(this).change(WeaponState.COMPOUND_RELOAD).to(WeaponState.COMPOUND_RELOAD_FINISH).when(reloadAnimationCompleted.and(hasNextLoadIteration.negate())).withAction((c, f, t, p) -> this.obamaCorporation((PlayerWeaponInstance)c)).automatic().in(this).change(WeaponState.COMPOUND_RELOAD_EMPTY).to(WeaponState.COMPOUND_RELOAD_FINISH).when(reloadAnimationCompleted.and(hasNextLoadIteration.negate())).withAction((c, f, t, p) -> this.obamaCorporation((PlayerWeaponInstance)c)).automatic().in(this).change(WeaponState.COMPOUND_RELOAD_FINISH).to(WeaponState.COMPOUND_RELOAD_FINISHED).withPermit((s, es) -> new CompoundPermit((WeaponState)s), this.modContext.getPlayerItemInstanceRegistry()::update, this.permitManager).manual().in(this).change(WeaponState.COMPOUND_RELOAD_FINISHED).to(WeaponState.READY).when(shouldFinishCompoundReload).automatic().in(this).change(WeaponState.LOAD).to(WeaponState.LOAD_ITERATION).when(hasNextLoadIteration.and(prepareFirstLoadIterationAnimationCompleted)).withAction(this::startLoadIteration).automatic().in(this).change(WeaponState.LOAD_ITERATION).to(WeaponState.LOAD_ITERATION_COMPLETED).when(loadIterationCompleted).withAction(this::completeLoadIteration).automatic().in(this).change(WeaponState.LOAD_ITERATION_COMPLETED).to(WeaponState.LOAD_ITERATION).when(hasNextLoadIteration).withAction(this::startLoadIteration).automatic().in(this).change(WeaponState.LOAD_ITERATION_COMPLETED).to(WeaponState.ALL_LOAD_ITERATIONS_COMPLETED).when(hasNextLoadIteration.negate()).automatic().in(this).change(WeaponState.ALL_LOAD_ITERATIONS_COMPLETED).to(WeaponState.READY).when(allLoadIterationsCompleted).withAction(this::completeAllLoadIterations).automatic().in(this).prepare((c, f, t) -> this.prepareUnload((PlayerWeaponInstance)c), unloadAnimationCompleted).change(WeaponState.READY).to(WeaponState.UNLOAD).when(magazineAttached.and(this.inventoryHasFreeSlots)).withPermit((s, c) -> new UnloadPermit((WeaponState)s), this.modContext.getPlayerItemInstanceRegistry()::update, this.permitManager).withAction((c, f, t, p) -> this.completeClientUnload((PlayerWeaponInstance)c, (UnloadPermit)p)).manual().in(this).change(WeaponState.UNLOAD).to(WeaponState.READY).when(loadAfterUnloadEnabled.negate().or(unloadTimeoutExpired)).automatic().in(this).change(WeaponState.READY).to(WeaponState.ALERT).when(this.inventoryHasFreeSlots.negate()).withAction(this::inventoryFullAlert).manual().in(this).change(WeaponState.ALERT).to(WeaponState.READY).when(alertTimeoutExpired).automatic().in(this).change(WeaponState.READY).to(WeaponState.INSPECTING).withAction(this::inspect).manual().in(this).change(WeaponState.INSPECTING).to(WeaponState.READY).when(inspectTimeoutExpired).automatic().in(this).change(WeaponState.READY).to(WeaponState.DRAWING).withAction(this::draw).manual().in(this).change(WeaponState.DRAWING).to(WeaponState.READY).when(drawingAnimationCompleted).automatic();
    }

    @Override
    public void setPermitManager(NetworkPermitManager permitManager) {
        this.permitManager = permitManager;
        permitManager.registerEvaluator(LoadPermit.class, PlayerWeaponInstance.class, this::processLoadPermit);
        permitManager.registerEvaluator(UnloadPermit.class, PlayerWeaponInstance.class, this::processUnloadPermit);
        permitManager.registerEvaluator(CompoundPermit.class, PlayerWeaponInstance.class, this::processCompoundPermit);
    }

    public void processCompoundPermit(CompoundPermit p, PlayerWeaponInstance pwi) {
        this.processActualCompoundPermit(p, pwi);
        this.previousMagazine = null;
    }

    public void obamaCorporation(PlayerWeaponInstance instance) {
        this.stateManager.changeState(this, instance, new WeaponState[]{WeaponState.COMPOUND_RELOAD_FINISHED});
    }

    public void clientCompoundReload(PlayerWeaponInstance instance) {
        if (instance == null) {
            return;
        }
        instance.completeMagSwap();
        instance.getWeapon().getRenderer().setMagicMagPermit(true);
        if (instance.getState() == WeaponState.COMPOUND_RELOAD) {
            this.stateManager.changeState(this, instance, new WeaponState[]{WeaponState.COMPOUND_RELOAD});
        } else {
            this.stateManager.changeState(this, instance, new WeaponState[]{WeaponState.COMPOUND_RELOAD_EMPTY});
        }
        this.previousMagazine = null;
    }

    public void reloadMainHeldItem(EntityPlayer player) {
        PlayerWeaponInstance instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (instance != null) {
            if (AnimationModeProcessor.getInstance().isLegacyMode()) {
                this.furtherLoadInstructionsReceived(instance);
                this.stateManager.changeState(this, instance, new WeaponState[]{WeaponState.READY});
            } else if (WeaponAttachmentAspect.getActiveAttachment(AttachmentCategory.MAGAZINE, instance) == null) {
                ItemStack nextAttachment = this.getNextBestMagazineStack(instance);
                if (instance.getWeapon().getRenderer().getBuilder().isHasLoadEmpty() && nextAttachment != null && Tags.getAmmo(nextAttachment) == 0) {
                    instance.getWeapon().getRenderer().setShouldDoEmptyVariant(true);
                }
                this.stateManager.changeState(this, instance, new WeaponState[]{WeaponState.AWAIT_FURTHER_LOAD_INSTRUCTIONS, WeaponState.READY});
            } else {
                if (instance.getState() != WeaponState.READY && instance.getState() != WeaponState.COMPOUND_REQUESTED) {
                    return;
                }
                ItemAttachment<Weapon> nextAttachment = this.getNextMagazine(instance);
                instance.markReloadDirt();
                instance.markMagSwapReady();
                if (instance.getAmmo() == 0) {
                    if (nextAttachment == null) {
                        return;
                    }
                    instance.getWeapon().getRenderer().setMagicMag(instance, nextAttachment, WeaponState.COMPOUND_RELOAD_EMPTY);
                    this.stateManager.changeState(this, instance, new WeaponState[]{WeaponState.COMPOUND_RELOAD_EMPTY});
                } else {
                    if (nextAttachment == null) {
                        return;
                    }
                    instance.getWeapon().getRenderer().setMagicMag(instance, nextAttachment, WeaponState.COMPOUND_RELOAD);
                    instance.setIsAwaitingCompoundInstructions(true);
                    this.stateManager.changeState(this, instance, new WeaponState[]{WeaponState.COMPOUND_REQUESTED, WeaponState.READY});
                }
            }
        }
    }

    public void unloadMainHeldItem(EntityPlayer player) {
        PlayerWeaponInstance instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (instance != null) {
            instance.getWeapon().getRenderer().compoundReloadEmpty = false;
            instance.getWeapon().getRenderer().compoundReload = false;
            instance.setLoadAfterUnloadEnabled(false);
            ItemAttachment<Weapon> currentMagazine = this.modContext.getAttachmentAspect().getActiveAttachment(instance, AttachmentCategory.MAGAZINE);
            if (instance.getWeapon().getRenderer().getBuilder().isHasUnloadEmpty() && currentMagazine != null && instance.getAmmo() == 0) {
                instance.getWeapon().getRenderer().setShouldDoEmptyVariant(true);
            }
            this.stateManager.changeState(this, instance, new WeaponState[]{WeaponState.UNLOAD, WeaponState.ALERT});
        }
    }

    void updateMainHeldItem(EntityPlayer player) {
        PlayerWeaponInstance instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (instance != null) {
            this.stateManager.changeStateFromAnyOf(this, instance, ALLOWED_UPDATE_FROM_STATES, new WeaponState[0]);
        }
    }

    public void inspectMainHeldItem(EntityPlayer player) {
        PlayerWeaponInstance instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (instance != null) {
            this.stateManager.changeState(this, instance, new WeaponState[]{WeaponState.INSPECTING});
        }
    }

    public void drawMainHeldItem(EntityPlayer player) {
        PlayerWeaponInstance instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerWeaponInstance.class);
        if (instance != null) {
            this.stateManager.changeState(this, instance, new WeaponState[]{WeaponState.DRAWING});
        }
    }

    private ItemAttachment<Weapon> getNextMagazine(PlayerWeaponInstance weaponInstance) {
        int i;
        ItemStack beltStack;
        EntityPlayer player = (EntityPlayer)weaponInstance.getPlayer();
        Weapon weapon = (Weapon)weaponInstance.getItem();
        List compatibleMagazines = weapon.getCompatibleMagazines().stream().filter(compatibleMagazine -> WeaponAttachmentAspect.hasRequiredAttachments(compatibleMagazine, weaponInstance)).collect(Collectors.toList());
        if (compatibleMagazines.isEmpty()) {
            return null;
        }
        Comparator comparator = (stack1, stack2) -> Integer.compare(Tags.getAmmo(stack1), Tags.getAmmo(stack2));
        if (player.func_184812_l_() && !player.func_70093_af()) {
            return (ItemAttachment)((ItemStack)compatibleMagazines.stream().map(ItemMagazine::create).max(comparator).orElse(null)).func_77973_b();
        }
        int maxItemIndex = -1;
        ItemStack maxStack = null;
        EquipmentInventory equipmentInventory = EquipmentCapability.getInventory((EntityLivingBase)player);
        if (equipmentInventory != null && !(beltStack = equipmentInventory.func_70301_a(1)).func_190926_b()) {
            BackpackInventory beltInventory = new BackpackInventory(beltStack);
            for (int i2 = 0; i2 < beltInventory.func_70302_i_(); ++i2) {
                if (beltInventory.func_70301_a(i2) == null || !compatibleMagazines.contains(beltInventory.func_70301_a(i2).func_77973_b()) || maxStack != null && comparator.compare(beltInventory.func_70301_a(i2), maxStack) <= 0) continue;
                maxStack = beltInventory.func_70301_a(i2);
                maxItemIndex = i2;
            }
        }
        if (maxItemIndex < 0) {
            for (int i3 = 0; i3 < player.field_71071_by.field_70462_a.size(); ++i3) {
                if (player.field_71071_by.func_70301_a(i3) == null || !compatibleMagazines.contains(player.field_71071_by.func_70301_a(i3).func_77973_b()) || maxStack != null && comparator.compare(player.field_71071_by.func_70301_a(i3), maxStack) <= 0) continue;
                maxStack = player.field_71071_by.func_70301_a(i3);
                maxItemIndex = i3;
            }
        }
        if ((i = maxItemIndex) < 0) {
            return null;
        }
        ItemStack magazineItemStack = player.field_71071_by.func_70301_a(i).func_77946_l().func_77979_a(Math.min(player.field_71071_by.func_70301_a(i).func_77946_l().func_190916_E(), 1));
        if (magazineItemStack == null) {
            return null;
        }
        return (ItemAttachment)magazineItemStack.func_77973_b();
    }

    private ItemStack getNextBestMagazineStack(PlayerWeaponInstance weaponInstance) {
        int i;
        ItemStack beltStack;
        EntityPlayer player = (EntityPlayer)weaponInstance.getPlayer();
        Weapon weapon = (Weapon)weaponInstance.getItem();
        List compatibleMagazines = weapon.getCompatibleMagazines().stream().filter(compatibleMagazine -> WeaponAttachmentAspect.hasRequiredAttachments(compatibleMagazine, weaponInstance)).collect(Collectors.toList());
        if (compatibleMagazines.isEmpty()) {
            return null;
        }
        Comparator comparator = (stack1, stack2) -> Integer.compare(Tags.getAmmo(stack1), Tags.getAmmo(stack2));
        if (player.func_184812_l_() && !player.func_70093_af()) {
            return compatibleMagazines.stream().map(ItemMagazine::create).max(comparator).orElse(null);
        }
        int maxItemIndex = -1;
        ItemStack maxStack = null;
        EquipmentInventory equipmentInventory = EquipmentCapability.getInventory((EntityLivingBase)player);
        if (equipmentInventory != null && !(beltStack = equipmentInventory.func_70301_a(1)).func_190926_b()) {
            BackpackInventory beltInventory = new BackpackInventory(beltStack);
            for (int i2 = 0; i2 < beltInventory.func_70302_i_(); ++i2) {
                if (beltInventory.func_70301_a(i2) == null || !compatibleMagazines.contains(beltInventory.func_70301_a(i2).func_77973_b()) || maxStack != null && comparator.compare(beltInventory.func_70301_a(i2), maxStack) <= 0) continue;
                maxStack = beltInventory.func_70301_a(i2);
                maxItemIndex = i2;
            }
        }
        if (maxItemIndex < 0) {
            for (int i3 = 0; i3 < player.field_71071_by.field_70462_a.size(); ++i3) {
                if (player.field_71071_by.func_70301_a(i3) == null || !compatibleMagazines.contains(player.field_71071_by.func_70301_a(i3).func_77973_b()) || maxStack != null && comparator.compare(player.field_71071_by.func_70301_a(i3), maxStack) <= 0) continue;
                maxStack = player.field_71071_by.func_70301_a(i3);
                maxItemIndex = i3;
            }
        }
        if ((i = maxItemIndex) < 0) {
            return null;
        }
        ItemStack magazineItemStack = player.field_71071_by.func_70301_a(i).func_77946_l().func_77979_a(Math.min(player.field_71071_by.func_70301_a(i).func_77946_l().func_190916_E(), 1));
        return magazineItemStack;
    }

    private void processActualCompoundPermit(CompoundPermit p, PlayerWeaponInstance instance) {
        ItemStack weaponItemStack = instance.getItemStack();
        EntityPlayer player = (EntityPlayer)instance.getPlayer();
        Weapon weapon = instance.getWeapon();
        List compatibleMagazines = weapon.getCompatibleMagazines().stream().filter(compatibleMagazine -> WeaponAttachmentAspect.hasRequiredAttachments(compatibleMagazine, instance)).collect(Collectors.toList());
        ItemAttachment<Weapon> attachment = this.modContext.getAttachmentAspect().removeAttachment(AttachmentCategory.MAGAZINE, instance);
        int originalAmmo = instance.getAmmo();
        if (compatibleMagazines.isEmpty()) {
            return;
        }
        ItemStack magazineStack = MWCUtil.consumeItemsFromPlayerInventory(compatibleMagazines, (stack1, stack2) -> Integer.compare(Tags.getAmmo(stack1), Tags.getAmmo(stack2)), player);
        if (magazineStack == null) {
            return;
        }
        int ammo = Tags.getAmmo(magazineStack);
        Tags.setAmmo(weaponItemStack, ammo);
        WeaponAttachmentAspect.addAttachment((ItemAttachment)magazineStack.func_77973_b(), instance);
        instance.setAmmo(ammo);
        p.setStatus(Permit.Status.GRANTED);
        if (attachment == null) {
            p.setStatus(Permit.Status.DENIED);
        } else if (attachment instanceof ItemMagazine && !player.func_184812_l_()) {
            ItemStack attachmentItemStack = ((ItemMagazine)attachment).create(originalAmmo);
            if (!player.field_71071_by.func_70441_a(attachmentItemStack)) {
                ModReference.LOG.error("Cannot add attachment " + attachment + " for " + instance + "back to the inventory");
            }
            p.setStatus(Permit.Status.GRANTED);
        }
    }

    private void processLoadPermit(LoadPermit p, PlayerWeaponInstance weaponInstance) {
        int consumedAmount;
        ModReference.LOG.debug("Processing load permit on server for {}", (Object)weaponInstance);
        ItemStack weaponItemStack = weaponInstance.getItemStack();
        if (weaponItemStack == null || !(weaponInstance.getPlayer() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)weaponInstance.getPlayer();
        Permit.Status status = Permit.Status.GRANTED;
        weaponInstance.setLoadIterationCount(0);
        Weapon weapon = (Weapon)weaponInstance.getItem();
        if (weaponItemStack.func_77978_p() == null) {
            weaponItemStack.func_77982_d(new NBTTagCompound());
        }
        List compatibleMagazines = weapon.getCompatibleMagazines().stream().filter(compatibleMagazine -> WeaponAttachmentAspect.hasRequiredAttachments(compatibleMagazine, weaponInstance)).collect(Collectors.toList());
        List<ItemAttachment<Weapon>> compatibleBullets = weapon.getCompatibleAttachments(ItemBullet.class);
        boolean consumed = false;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (itemstack.func_77973_b() != weapon.builder.ammo) continue;
            itemstack.func_190918_g(1);
            consumed = true;
        }
        if (!compatibleMagazines.isEmpty()) {
            ItemAttachment<Weapon> existingMagazine = WeaponAttachmentAspect.getActiveAttachment(AttachmentCategory.MAGAZINE, weaponInstance);
            int ammo = Tags.getAmmo(weaponItemStack);
            if (existingMagazine == null) {
                ammo = 0;
                ItemStack magazineItemStack = MWCUtil.consumeItemsFromPlayerInventory(compatibleMagazines, (stack1, stack2) -> Integer.compare(Tags.getAmmo(stack1), Tags.getAmmo(stack2)), player);
                if (magazineItemStack != null) {
                    ammo = Tags.getAmmo(magazineItemStack);
                    Tags.setAmmo(weaponItemStack, ammo);
                    ModReference.LOG.debug("Setting server side ammo for {} to {}", (Object)weaponInstance, (Object)ammo);
                    WeaponAttachmentAspect.addAttachment((ItemAttachment)magazineItemStack.func_77973_b(), weaponInstance);
                    player.field_70170_p.func_184148_a((EntityPlayer)(player instanceof EntityPlayer ? player : null), player.field_70165_t, player.field_70163_u, player.field_70161_v, weapon.getReloadSound(), player.func_184176_by(), 1.0f, 1.0f);
                } else {
                    status = Permit.Status.DENIED;
                }
            }
            weaponInstance.setAmmo(ammo);
        } else if (!compatibleBullets.isEmpty() && (consumedAmount = MWCUtil.consumeItemsFromPlayerInventory(compatibleBullets, Math.min(weapon.getMaxBulletsPerReload(), weapon.getAmmoCapacity() - weaponInstance.getAmmo()), player)) != 0) {
            int ammo = weaponInstance.getAmmo() + consumedAmount;
            Tags.setAmmo(weaponItemStack, ammo);
            weaponInstance.setAmmo(ammo);
            if (weapon.hasIteratedLoad()) {
                weaponInstance.setLoadIterationCount(consumedAmount);
            }
            player.field_70170_p.func_184148_a((EntityPlayer)(player instanceof EntityPlayer ? player : null), player.field_70165_t, player.field_70163_u, player.field_70161_v, weapon.getReloadSound(), player.func_184176_by(), 1.0f, 1.0f);
        } else if (consumed) {
            Tags.setAmmo(weaponItemStack, weapon.builder.ammoCapacity);
            weaponInstance.setAmmo(weapon.builder.ammoCapacity);
            player.field_70170_p.func_184148_a((EntityPlayer)(player instanceof EntityPlayer ? player : null), player.field_70165_t, player.field_70163_u, player.field_70161_v, weapon.getReloadSound(), player.func_184176_by(), 1.0f, 1.0f);
        } else {
            ModReference.LOG.debug("No suitable ammo found for {}. Permit denied.", (Object)weaponInstance);
            status = Permit.Status.DENIED;
        }
        p.setStatus(status);
    }

    private void prepareUnload(PlayerWeaponInstance weaponInstance) {
        weaponInstance.getPlayer().func_184185_a(weaponInstance.getWeapon().getUnloadSound(), 1.0f, 1.0f);
    }

    private void processUnloadPermit(UnloadPermit p, PlayerWeaponInstance weaponInstance) {
        ModReference.LOG.debug("Processing unload permit on server for {}", (Object)weaponInstance);
        if (!(weaponInstance.getPlayer() instanceof EntityPlayer)) {
            return;
        }
        ItemStack weaponItemStack = weaponInstance.getItemStack();
        EntityPlayer player = (EntityPlayer)weaponInstance.getPlayer();
        Weapon weapon = (Weapon)weaponItemStack.func_77973_b();
        if (weaponItemStack.func_77978_p() != null) {
            ItemAttachment<Weapon> attachment = this.modContext.getAttachmentAspect().removeAttachment(AttachmentCategory.MAGAZINE, weaponInstance);
            if (attachment == null) {
                p.setStatus(Permit.Status.DENIED);
                return;
            }
            if (attachment instanceof ItemMagazine && !player.func_184812_l_()) {
                this.previousMagazine = attachment;
                ItemStack attachmentItemStack = ((ItemMagazine)attachment).create(Tags.getAmmo(weaponItemStack));
                if (!player.field_71071_by.func_70441_a(attachmentItemStack)) {
                    ModReference.LOG.error("Cannot add attachment " + attachment + " for " + weaponInstance + "back to the inventory");
                }
            }
            Tags.setAmmo(weaponItemStack, 0);
            weaponInstance.setAmmo(0);
            player.field_70170_p.func_184148_a((EntityPlayer)(player instanceof EntityPlayer ? player : null), player.field_70165_t, player.field_70163_u, player.field_70161_v, weapon.getUnloadSound(), player.func_184176_by(), 1.0f, 1.0f);
            p.setStatus(Permit.Status.GRANTED);
        } else {
            p.setStatus(Permit.Status.DENIED);
        }
        p.setStatus(Permit.Status.GRANTED);
    }

    private void completeClientLoad(PlayerWeaponInstance weaponInstance, LoadPermit permit) {
        weaponInstance.setLoadAfterUnloadEnabled(false);
        if (permit == null) {
            ModReference.LOG.error("Permit is null, something went wrong");
            return;
        }
        if (permit.getStatus() == Permit.Status.GRANTED) {
            weaponInstance.getPlayer().func_184185_a(weaponInstance.getWeapon().getReloadSound(), 1.0f, 1.0f);
        }
    }

    private void completeClientUnload(PlayerWeaponInstance weaponInstance, UnloadPermit p) {
        if (weaponInstance.isLoadAfterUnloadEnabled()) {
            this.stateManager.changeState(this, weaponInstance, new WeaponState[]{WeaponState.LOAD, WeaponState.ALERT});
            weaponInstance.setLoadAfterUnloadEnabled(false);
        }
    }

    public void inventoryFullAlert(PlayerWeaponInstance weaponInstance) {
        if (weaponInstance.getPlayer() instanceof EntityPlayer) {
            ((EntityPlayer)weaponInstance.getPlayer()).func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gui.inventoryFull", (Object[])new Object[0])), true);
        }
    }

    public void inspect(PlayerWeaponInstance weaponInstance) {
        weaponInstance.getPlayer().func_184185_a(weaponInstance.getWeapon().getInspectSound(), 1.0f, 1.0f);
    }

    public void draw(PlayerWeaponInstance weaponInstance) {
        weaponInstance.getPlayer().func_184185_a(weaponInstance.getWeapon().getDrawSound(), 1.0f, 1.0f);
    }

    public void startLoadIteration(PlayerWeaponInstance weaponInstance) {
        weaponInstance.getPlayer().func_184185_a(weaponInstance.getWeapon().getReloadIterationSound(), 1.0f, 1.0f);
    }

    public void completeLoadIteration(PlayerWeaponInstance weaponInstance) {
        weaponInstance.setLoadIterationCount(weaponInstance.getLoadIterationCount() - 1);
    }

    public void completeAllLoadIterations(PlayerWeaponInstance weaponInstance) {
        weaponInstance.getPlayer().func_184185_a(weaponInstance.getWeapon().getAllReloadIterationsCompletedSound(), 1.0f, 1.0f);
    }

    public void noCompoundInstructionsReceived(PlayerWeaponInstance weaponInstance) {
        weaponInstance.setDelayCompoundEnd(false);
        weaponInstance.setIsAwaitingCompoundInstructions(false);
        this.stateManager.changeState(this, weaponInstance, new WeaponState[]{WeaponState.COMPOUND_RELOAD});
    }

    public void compoundInstructionsReceived(PlayerWeaponInstance weaponInstance) {
        weaponInstance.setIsAwaitingCompoundInstructions(false);
        if (!weaponInstance.getWeapon().getRenderer().getBuilder().isHasTacticalReload()) {
            this.stateManager.changeState(this, weaponInstance, new WeaponState[]{WeaponState.COMPOUND_RELOAD});
            return;
        }
        WeaponRenderer weaponRenderer = weaponInstance.getWeapon().getRenderer();
        weaponInstance.getWeapon().getRenderer();
        weaponRenderer.setMagicMag(weaponInstance, WeaponRenderer.magicMagReplacement, WeaponState.TACTICAL_RELOAD);
        this.stateManager.changeState(this, weaponInstance, new WeaponState[]{WeaponState.TACTICAL_RELOAD});
    }

    public void noFurtherLoadInstructionsReceived(PlayerWeaponInstance weaponInstance) {
        this.stateManager.changeState(this, weaponInstance, new WeaponState[]{WeaponState.LOAD, WeaponState.ALERT});
    }

    public void furtherLoadInstructionsReceived(PlayerWeaponInstance weaponInstance) {
        weaponInstance.setLoadAfterUnloadEnabled(true);
        this.stateManager.changeState(this, weaponInstance, new WeaponState[]{WeaponState.UNLOAD, WeaponState.LOAD, WeaponState.ALERT});
    }

    static {
        TypeRegistry.getINSTANCE().register(CompoundPermit.class);
        TypeRegistry.getINSTANCE().register(UnloadPermit.class);
        TypeRegistry.getINSTANCE().register(LoadPermit.class);
        TypeRegistry.getINSTANCE().register(PlayerWeaponInstance.class);
        ALLOWED_UPDATE_FROM_STATES = new HashSet<WeaponState>(Arrays.asList(WeaponState.AWAIT_FURTHER_LOAD_INSTRUCTIONS, WeaponState.COMPOUND_REQUESTED, WeaponState.COMPOUND_RELOAD, WeaponState.COMPOUND_RELOAD_EMPTY, WeaponState.COMPOUND_RELOAD_FINISH, WeaponState.COMPOUND_RELOAD_FINISHED, WeaponState.TACTICAL_RELOAD, WeaponState.LOAD_REQUESTED, WeaponState.LOAD, WeaponState.LOAD_ITERATION, WeaponState.LOAD_ITERATION_COMPLETED, WeaponState.ALL_LOAD_ITERATIONS_COMPLETED, WeaponState.UNLOAD_PREPARING, WeaponState.UNLOAD_REQUESTED, WeaponState.UNLOAD, WeaponState.ALERT, WeaponState.INSPECTING, WeaponState.DRAWING));
        hasNextLoadIteration = weaponInstance -> weaponInstance.getWeapon().hasIteratedLoad() && weaponInstance.getLoadIterationCount() > 0;
        supportsDirectBulletLoad = weaponInstance -> weaponInstance.getWeapon().getAmmoCapacity() > 0;
        magazineAttached = weaponInstance -> WeaponAttachmentAspect.getActiveAttachment(AttachmentCategory.MAGAZINE, weaponInstance) != null;
        hasAmmo = i -> i.getAmmo() != 0;
        loadIterationCompleted = weaponInstance -> System.currentTimeMillis() >= weaponInstance.getStateUpdateTimestamp() + Math.max(weaponInstance.getWeapon().builder.loadIterationTimeout, weaponInstance.getWeapon().getTotalLoadIterationDuration() + 250L);
        allLoadIterationsCompleted = weaponInstance -> System.currentTimeMillis() >= weaponInstance.getStateUpdateTimestamp() + weaponInstance.getWeapon().getAllLoadIterationAnimationsCompletedDuration();
        reloadAnimationCompleted = weaponInstance -> {
            long maxTime = weaponInstance.getAnimationDuration();
            return System.currentTimeMillis() >= weaponInstance.getStateUpdateTimestamp() + Math.max(weaponInstance.getWeapon().builder.reloadingTimeout, maxTime);
        };
        magSwapCompleted = weaponInstance -> weaponInstance.isMagSwapDone();
        reloadMidpoint = weaponInstance -> Math.abs((double)(System.currentTimeMillis() - weaponInstance.getReloadTimestamp()) / ((double)weaponInstance.getWeapon().getTotalReloadingDuration() * 0.5) - 0.5) < 0.01;
        unloadTimeoutExpired = weaponInstance -> System.currentTimeMillis() >= weaponInstance.getStateUpdateTimestamp() + 1000L;
        awaitFurtherLoadInstructionCompleted = weaponInstance -> System.currentTimeMillis() >= weaponInstance.getStateUpdateTimestamp() + 295L;
        loadAfterUnloadEnabled = PlayerWeaponInstance::isLoadAfterUnloadEnabled;
        unloadAnimationCompleted = weaponInstance -> (double)System.currentTimeMillis() >= (double)weaponInstance.getStateUpdateTimestamp() + (double)weaponInstance.getWeapon().getTotalUnloadingDuration() * 1.1;
        prepareFirstLoadIterationAnimationCompleted = weaponInstance -> (double)System.currentTimeMillis() >= (double)weaponInstance.getStateUpdateTimestamp() + (double)weaponInstance.getWeapon().getPrepareFirstLoadIterationAnimationDuration() * 1.1;
        shouldFinishCompoundReload = weaponInstance -> {
            if (weaponInstance.isDelayCompoundEnd()) {
                return true;
            }
            long maxTime = (long)((double)weaponInstance.getAnimationDuration() * 1.2);
            return System.currentTimeMillis() >= weaponInstance.getReloadTimestamp() + maxTime;
        };
        alertTimeoutExpired = instance -> System.currentTimeMillis() >= 500L + instance.getStateUpdateTimestamp();
        inspectTimeoutExpired = instance -> System.currentTimeMillis() >= 500L + instance.getStateUpdateTimestamp();
        drawingAnimationCompleted = weaponInstance -> (double)System.currentTimeMillis() >= (double)weaponInstance.getStateUpdateTimestamp() + (double)weaponInstance.getWeapon().getTotalDrawingDuration() * 1.0;
    }

    public static class LoadPermit
    extends Permit<WeaponState> {
        public LoadPermit() {
        }

        public LoadPermit(WeaponState state) {
            super(state);
        }
    }

    public static class UnloadPermit
    extends Permit<WeaponState> {
        public UnloadPermit() {
        }

        public UnloadPermit(WeaponState state) {
            super(state);
        }
    }

    public static class CompoundPermit
    extends Permit<WeaponState> {
        public CompoundPermit() {
        }

        public CompoundPermit(WeaponState state) {
            super(state);
        }
    }
}

