/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.weaponlib.Contextual;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.RenderingPhase;
import com.paneedah.weaponlib.SpreadableExposure;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.WeaponState;
import com.paneedah.weaponlib.compatibility.CompatibleExposureCapability;
import com.paneedah.weaponlib.grenade.PlayerGrenadeInstance;
import com.paneedah.weaponlib.melee.PlayerMeleeInstance;
import com.paneedah.weaponlib.vehicle.EntityVehicle;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WeaponEventHandler {
    private ModContext modContext;

    public WeaponEventHandler(ModContext modContext) {
        this.modContext = modContext;
    }

    @SubscribeEvent
    public void zoom(FOVUpdateEvent event) {
        PlayerWeaponInstance instance = this.modContext.getMainHeldWeapon();
        EntityPlayerSP clientPlayer = ClientProxy.MC.field_71439_g;
        if (instance != null) {
            float fov;
            if (instance.isAttachmentZoomEnabled()) {
                fov = instance.getWeapon().getADSZoom();
                fov = ClientProxy.renderingPhase == RenderingPhase.RENDER_PERSPECTIVE ? instance.getZoom() : (clientPlayer.field_71075_bZ.field_75100_b ? 1.1f : 1.0f);
            } else {
                fov = ClientProxy.MC.field_71439_g.field_71075_bZ.field_75100_b ? 1.1f : 1.0f;
            }
            RenderingPhase phase = ClientProxy.renderingPhase;
            if (instance.isAimed() && phase == null) {
                fov = 0.7f;
            }
            if (ClientProxy.MC.field_71439_g.func_70051_ag()) {
                fov = (float)((double)fov * 1.2);
            }
            event.setNewfov(fov);
        } else {
            SpreadableExposure spreadableExposure = CompatibleExposureCapability.getExposure((Entity)ClientProxy.MC.field_71439_g, SpreadableExposure.class);
            if (spreadableExposure != null && spreadableExposure.getTotalDose() > 0.0f) {
                float fov = ClientProxy.MC.field_71439_g.field_71075_bZ.field_75100_b ? 1.1f : 1.0f;
                event.setNewfov(fov);
            }
        }
    }

    @SubscribeEvent
    public void onMouse(MouseEvent event) {
        PlayerItemInstance<?> instance;
        if ((event.getButton() == 0 || event.getButton() == 1) && ((instance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)ClientProxy.MC.field_71439_g)) instanceof PlayerWeaponInstance || instance instanceof PlayerMeleeInstance || instance instanceof PlayerGrenadeInstance)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderLivingEvent(RenderLivingEvent.Pre event) {
        if (event.isCanceled() || !(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        ItemStack itemStack = event.getEntity().func_184614_ca();
        if (itemStack != null && itemStack.func_77973_b() instanceof Weapon) {
            RenderPlayer rp = (RenderPlayer)event.getRenderer();
            if (itemStack != null) {
                EntityPlayer player = (EntityPlayer)event.getEntity();
                PlayerItemInstance<?> instance = this.modContext.getPlayerItemInstanceRegistry().getItemInstance((EntityLivingBase)player, itemStack);
                if (instance instanceof PlayerWeaponInstance) {
                    PlayerWeaponInstance weaponInstance = (PlayerWeaponInstance)instance;
                    if (!MWCUtil.isProning(player) && (weaponInstance.isAimed() || weaponInstance.getState() == WeaponState.FIRING || weaponInstance.getState() == WeaponState.RECOILED || weaponInstance.getState() == WeaponState.PAUSED)) {
                        rp.func_177087_b().field_187075_l = ModelBiped.ArmPose.BOW_AND_ARROW;
                        rp.func_177087_b().field_187076_m = ModelBiped.ArmPose.BOW_AND_ARROW;
                    } else {
                        rp.func_177087_b().field_187075_l = ModelBiped.ArmPose.EMPTY;
                        rp.func_177087_b().field_187076_m = ModelBiped.ArmPose.ITEM;
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public final void onRenderItemEvent(RenderHandEvent event) {
        if (ClientProxy.MC.field_71439_g.func_184187_bx() instanceof EntityVehicle) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityJoinedWorldEvent(EntityJoinWorldEvent entityJoinWorldEvent) {
        if (entityJoinWorldEvent.getEntity() instanceof Contextual) {
            ((Contextual)entityJoinWorldEvent.getEntity()).setContext(this.modContext);
        }
    }

    protected ModContext getModContext() {
        return this.modContext;
    }
}

