/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.MWC;
import com.paneedah.weaponlib.Part;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.animation.PartPositionProvider;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.util.vector.Matrix4f;

public class RenderContext<RS>
implements PartPositionProvider {
    private EntityLivingBase player;
    private ItemStack itemStack;
    private float limbSwing;
    private float flimbSwingAmount;
    private float ageInTicks;
    private float netHeadYaw;
    private float headPitch;
    private float scale;
    private float transitionProgress;
    private ItemCameraTransforms.TransformType transformType;
    private RS fromState;
    private RS toState;
    private PlayerItemInstance<?> playerItemInstance;
    private boolean cancelBeizer;
    private Map<Part, Matrix4f> attachablePartPositions;

    public RenderContext(EntityLivingBase player, ItemStack itemStack) {
        this.player = player;
        this.itemStack = itemStack;
        this.attachablePartPositions = new HashMap<Part, Matrix4f>();
    }

    public void setCancelBeizer() {
        this.cancelBeizer = true;
    }

    public boolean getCancelBeizer() {
        return this.cancelBeizer;
    }

    public float getLimbSwing() {
        return this.limbSwing;
    }

    public void setLimbSwing(float limbSwing) {
        this.limbSwing = limbSwing;
    }

    public float getFlimbSwingAmount() {
        return this.flimbSwingAmount;
    }

    public void setFlimbSwingAmount(float flimbSwingAmount) {
        this.flimbSwingAmount = flimbSwingAmount;
    }

    public float getAgeInTicks() {
        return this.ageInTicks;
    }

    public void setAgeInTicks(float ageInTicks) {
        this.ageInTicks = ageInTicks;
    }

    public float getNetHeadYaw() {
        return this.netHeadYaw;
    }

    public void setNetHeadYaw(float netHeadYaw) {
        this.netHeadYaw = netHeadYaw;
    }

    public float getHeadPitch() {
        return this.headPitch;
    }

    public void setHeadPitch(float headPitch) {
        this.headPitch = headPitch;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
    }

    public void setWeapon(ItemStack weapon) {
        this.itemStack = weapon;
    }

    public EntityLivingBase getPlayer() {
        return this.player;
    }

    public ItemStack getWeapon() {
        return this.itemStack;
    }

    public ItemCameraTransforms.TransformType getTransformType() {
        return this.transformType;
    }

    public void setCompatibleTransformType(ItemCameraTransforms.TransformType transformType) {
        this.transformType = transformType;
    }

    public RS getFromState() {
        return this.fromState;
    }

    public void setFromState(RS fromState) {
        this.fromState = fromState;
    }

    public RS getToState() {
        return this.toState;
    }

    public void setToState(RS toState) {
        this.toState = toState;
    }

    public float getTransitionProgress() {
        return this.transitionProgress;
    }

    public void setTransitionProgress(float transitionProgress) {
        this.transitionProgress = transitionProgress;
    }

    public PlayerItemInstance<?> getPlayerItemInstance() {
        return this.playerItemInstance;
    }

    public void setPlayerItemInstance(PlayerItemInstance<?> playerItemInstance) {
        this.playerItemInstance = playerItemInstance;
    }

    public PlayerWeaponInstance getWeaponInstance() {
        if (this.playerItemInstance instanceof PlayerWeaponInstance) {
            return (PlayerWeaponInstance)this.playerItemInstance;
        }
        PlayerItemInstance<?> itemInstance = MWC.modContext.getPlayerItemInstanceRegistry().getItemInstance(this.player, this.itemStack);
        if (itemInstance instanceof PlayerWeaponInstance) {
            return (PlayerWeaponInstance)itemInstance;
        }
        return null;
    }

    public void capturePartPosition(Part part) {
        this.attachablePartPositions.put(part, MatrixHelper.captureMatrix());
    }

    @Override
    public Matrix4f getPartPosition(Object part) {
        if (part == null) {
            part = Part.MAIN_ITEM;
        }
        return this.attachablePartPositions.get(part);
    }
}

