/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.Contextual;
import com.paneedah.weaponlib.ModContext;
import io.netty.buffer.ByteBuf;
import io.redstudioragnarok.redcore.vectors.Vector3D;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import net.jafama.FastMath;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public class EntityBounceable
extends Entity
implements Contextual,
IThrowableEntity,
IEntityAdditionalSpawnData {
    private static final int VELOCITY_HISTORY_SIZE = 10;
    private static final double STOP_THRESHOLD = 0.001;
    private static final int MAX_TICKS = 2000;
    protected ModContext modContext;
    private float gravityVelocity;
    private float slowdownFactor = 0.5f;
    private int ticksInAir;
    private EntityLivingBase thrower;
    protected int bounceCount;
    private float initialYaw;
    private float initialPitch;
    private float xRotation;
    private float yRotation;
    private float zRotation;
    private float xRotationChange;
    private float yRotationChange;
    private float zRotationChange;
    private float rotationSlowdownFactor = 0.99f;
    private float maxRotationChange = 20.0f;
    protected boolean stopped;
    private Queue<Double> velocityHistory = new ArrayDeque<Double>(10);

    public EntityBounceable(ModContext modContext, World world, EntityLivingBase thrower, float velocity, float gravityVelocity, float rotationSlowdownFactor) {
        super(world);
        this.modContext = modContext;
        this.thrower = thrower;
        this.gravityVelocity = gravityVelocity;
        this.rotationSlowdownFactor = rotationSlowdownFactor;
        this.func_70105_a(0.3f, 0.3f);
        this.func_70012_b(thrower.field_70165_t, thrower.field_70163_u + (double)thrower.func_70047_e(), thrower.field_70161_v, thrower.field_70177_z, thrower.field_70125_A);
        this.field_70165_t -= FastMath.cos((double)(this.field_70177_z / 180.0f * (float)Math.PI)) * (double)0.16f;
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= FastMath.sin((double)(this.field_70177_z / 180.0f * (float)Math.PI)) * (double)0.16f;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)((this.field_70125_A + 0.0f) / 180.0f * (float)Math.PI)) * f;
        this.initialYaw = this.field_70177_z;
        this.initialPitch = this.field_70125_A;
        this.setThrowableHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity, 10.0f);
        ModReference.LOG.debug("Throwing with position {}{}{}, rotation pitch {}, velocity {}, {}, {}", (Object)this.field_70165_t, (Object)this.field_70163_u, (Object)this.field_70161_v, (Object)Float.valueOf(this.field_70125_A), (Object)this.field_70159_w, (Object)this.field_70181_x, (Object)this.field_70179_y);
    }

    public void setThrowableHeading(double motionX, double motionY, double motionZ, float velocity, float inaccuracy) {
        float f2 = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)f2;
        motionY /= (double)f2;
        motionZ /= (double)f2;
        motionX += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        motionY += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        motionZ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = motionX *= (double)velocity;
        this.field_70181_x = motionY *= (double)velocity;
        this.field_70179_y = motionZ *= (double)velocity;
        float f3 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motionY, f3) * 180.0 / Math.PI);
    }

    public EntityBounceable(World world) {
        super(world);
        this.setRotations();
    }

    private void setRotations() {
        this.xRotationChange = this.maxRotationChange * (float)this.field_70146_Z.nextGaussian();
        this.yRotationChange = this.maxRotationChange * (float)this.field_70146_Z.nextGaussian();
        this.zRotationChange = this.maxRotationChange * (float)this.field_70146_Z.nextGaussian();
    }

    public EntityLivingBase getThrower() {
        return this.thrower;
    }

    public void setThrower(Entity thrower) {
        this.thrower = (EntityLivingBase)thrower;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 2000) {
            this.func_70106_y();
            return;
        }
        this.xRotation += this.xRotationChange;
        this.yRotation += this.yRotationChange;
        this.zRotation += this.zRotationChange;
        this.xRotationChange *= this.rotationSlowdownFactor;
        this.yRotationChange *= this.rotationSlowdownFactor;
        this.zRotationChange *= this.rotationSlowdownFactor;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        ++this.ticksInAir;
        if (this.stopped) {
            return;
        }
        Vector3D vec3 = new Vector3D(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vector3D vec31 = new Vector3D(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = MWCUtil.rayTraceBlocks(this.field_70170_p, vec3, vec31, (block, blockMetadata) -> this.canCollideWithBlock((Block)block, (IBlockState)blockMetadata));
        vec3 = new Vector3D(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec31 = new Vector3D(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null) {
            vec31.copy(new Vector3D(movingobjectposition.field_72307_f));
        }
        if (this.thrower != null) {
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b(entity, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72321_a(1.0, 1.0, 1.0));
            double d0 = 0.0;
            EntityLivingBase entitylivingbase = this.getThrower();
            RayTraceResult entityMovingObjectPosition = null;
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                Entity entity1 = (Entity)list.get(j);
                if (!entity1.func_70067_L() || entity1 == entitylivingbase && this.ticksInAir < 5) continue;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72321_a((double)f, (double)f, (double)f);
                RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(vec3.toVec3d(), vec31.toVec3d());
                if (movingobjectposition1 == null || !((d1 = vec3.distanceTo(new Vector3D(movingobjectposition1.field_72307_f))) < d0) && d0 != 0.0) continue;
                entity = entity1;
                entityMovingObjectPosition = movingobjectposition1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
                movingobjectposition.field_178784_b = entityMovingObjectPosition.field_178784_b;
                movingobjectposition.field_72307_f = entityMovingObjectPosition.field_72307_f;
            }
        }
        ModReference.LOG.trace("Ori position to {}, {}, {}, motion {} {} {} ", (Object)this.field_70165_t, (Object)this.field_70163_u, (Object)this.field_70161_v, (Object)this.field_70159_w, (Object)this.field_70181_x, (Object)this.field_70179_y);
        if (movingobjectposition != null && (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK || movingobjectposition.field_72313_a == RayTraceResult.Type.ENTITY)) {
            ModReference.LOG.trace("Hit {}, vec set to {}, {}, {}", (Object)movingobjectposition.field_72313_a, (Object)movingobjectposition.field_72307_f.field_72450_a, (Object)movingobjectposition.field_72307_f.field_72448_b, (Object)movingobjectposition.field_72307_f.field_72449_c);
            ModReference.LOG.trace("Before bouncing {}, side {}, motion set to {}, {}, {}", (Object)this.bounceCount, (Object)movingobjectposition.field_178784_b, (Object)this.field_70159_w, (Object)this.field_70181_x, (Object)this.field_70179_y);
            this.field_70165_t = movingobjectposition.field_72307_f.field_72450_a;
            this.field_70163_u = movingobjectposition.field_72307_f.field_72448_b;
            this.field_70161_v = movingobjectposition.field_72307_f.field_72449_c;
            switch (movingobjectposition.field_178784_b) {
                case DOWN: {
                    this.field_70181_x = -this.field_70181_x;
                    this.field_70163_u += this.field_70181_x;
                    break;
                }
                case UP: {
                    this.field_70181_x = -this.field_70181_x;
                    break;
                }
                case NORTH: {
                    this.field_70179_y = -this.field_70179_y;
                    this.field_70161_v += this.field_70179_y;
                    break;
                }
                case SOUTH: {
                    this.field_70179_y = -this.field_70179_y;
                    break;
                }
                case WEST: {
                    this.field_70159_w = -this.field_70159_w;
                    this.field_70165_t += this.field_70159_w;
                    break;
                }
                case EAST: {
                    this.field_70159_w = -this.field_70159_w;
                }
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (movingobjectposition.field_72313_a == RayTraceResult.Type.ENTITY) {
                this.avoidEntityCollisionAfterBounce(movingobjectposition);
            } else if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.avoidBlockCollisionAfterBounce(movingobjectposition);
            }
            ModReference.LOG.trace("After bouncing {}  motion set to {}, {}, {}", (Object)this.bounceCount, (Object)this.field_70159_w, (Object)this.field_70181_x, (Object)this.field_70179_y);
            this.onBounce(movingobjectposition);
            ++this.bounceCount;
            if (this.field_70128_L) {
                return;
            }
        } else {
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float motionSquared = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motionSquared) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f2 = 0.99f;
        float currentGravityVelocity = this.getGravityVelocity();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float f4 = 0.25f;
                EnumParticleTypes particleType = EnumParticleTypes.func_186831_a((String)"bubble");
                if (particleType == null) continue;
                this.field_70170_p.func_175688_a(particleType, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f2 = 0.8f;
        }
        if (movingobjectposition != null && (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK || movingobjectposition.field_72313_a == RayTraceResult.Type.ENTITY)) {
            f2 = this.slowdownFactor;
            this.rotationSlowdownFactor *= this.slowdownFactor * 1.5f;
        }
        this.field_70159_w *= (double)f2;
        this.field_70181_x *= (double)f2;
        this.field_70179_y *= (double)f2;
        this.recordVelocityHistory();
        if (!this.velocityHistory.stream().anyMatch(v -> v > 0.001)) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.stopped = true;
            ModReference.LOG.trace("Stopping {}", (Object)this);
            this.onStop();
        } else {
            this.field_70181_x -= (double)currentGravityVelocity;
        }
        ModReference.LOG.trace("Set position to {}, {}, {}, motion {} {} {} ", (Object)this.field_70165_t, (Object)this.field_70163_u, (Object)this.field_70161_v, (Object)this.field_70159_w, (Object)this.field_70181_x, (Object)this.field_70179_y);
    }

    public void onStop() {
    }

    public void onBounce(RayTraceResult movingobjectposition) {
    }

    private void avoidBlockCollisionAfterBounce(RayTraceResult movingobjectposition) {
        if (movingobjectposition.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        double dX = Math.signum(this.field_70159_w) * 0.01;
        double dY = Math.signum(this.field_70181_x) * 0.01;
        double dZ = Math.signum(this.field_70179_y) * 0.01;
        for (int i = 0; i < 10; ++i) {
            double projectedXPos = this.field_70165_t + dX * (double)i;
            double projectedYPos = this.field_70163_u + dY * (double)i;
            double projectedZPos = this.field_70161_v + dZ * (double)i;
            Vector3D projectedPos = new Vector3D(projectedXPos, projectedYPos, projectedZPos);
            BlockPos blockPos = new BlockPos(projectedPos.x, projectedPos.y, projectedPos.z);
            AxisAlignedBB projectedEntityBoundingBox = this.func_174813_aQ().func_72317_d(dX * (double)i, dY * (double)i, dZ * (double)i);
            if (!this.field_70170_p.func_175623_d(blockPos) && new AxisAlignedBB(blockPos).func_72326_a(projectedEntityBoundingBox)) continue;
            this.field_70165_t = projectedXPos;
            this.field_70163_u = projectedYPos;
            this.field_70161_v = projectedZPos;
            ModReference.LOG.trace("Found non-intercepting post-bounce position on iteration {}", (Object)i);
            break;
        }
    }

    private void avoidEntityCollisionAfterBounce(RayTraceResult movingobjectposition) {
        if (movingobjectposition.field_72308_g == null) {
            return;
        }
        this.slowdownFactor = 0.01f;
        double dX = Math.signum(this.field_70159_w) * 0.01;
        double dY = Math.signum(this.field_70181_x) * 0.01;
        double dZ = Math.signum(this.field_70179_y) * 0.01;
        float f = 0.3f;
        AxisAlignedBB axisalignedbb = movingobjectposition.field_72308_g.func_174813_aQ().func_72321_a((double)f, (double)f, (double)f);
        RayTraceResult intercept = movingobjectposition;
        for (int i = 0; i < 10; ++i) {
            Vector3D currentPos = new Vector3D(this.field_70165_t + dX * (double)i, this.field_70163_u + dY * (double)i, this.field_70161_v + dY * (double)i);
            Vector3D projectedPos = new Vector3D(this.field_70165_t + dX * (double)(i + 1), this.field_70163_u + dY * (double)(i + 1), this.field_70161_v + dZ * (double)(i + 1));
            intercept = axisalignedbb.func_72327_a(currentPos.toVec3d(), projectedPos.toVec3d());
            if (intercept != null) continue;
            BlockPos blockPos = new BlockPos(projectedPos.x, projectedPos.y, projectedPos.z);
            IBlockState iBlockState = this.field_70170_p.func_180495_p(blockPos);
            if (iBlockState != null && iBlockState.func_177230_c() != Blocks.field_150350_a) {
                ModReference.LOG.debug("Found non-intercept position colliding with block {}", (Object)iBlockState);
                intercept = movingobjectposition;
                break;
            }
            this.field_70165_t = projectedPos.x;
            this.field_70163_u = projectedPos.y;
            this.field_70161_v = projectedPos.z;
            break;
        }
        if (intercept != null) {
            ModReference.LOG.debug("Could not find non-intercept position after bounce");
        }
    }

    protected float getGravityVelocity() {
        return this.gravityVelocity;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.thrower != null ? this.thrower.func_145782_y() : -1);
        buffer.writeDouble(this.field_70165_t);
        buffer.writeDouble(this.field_70163_u);
        buffer.writeDouble(this.field_70161_v);
        buffer.writeDouble(this.field_70159_w);
        buffer.writeDouble(this.field_70181_x);
        buffer.writeDouble(this.field_70179_y);
        buffer.writeFloat(this.gravityVelocity);
        buffer.writeFloat(this.rotationSlowdownFactor);
        buffer.writeFloat(this.initialYaw);
        buffer.writeFloat(this.initialPitch);
    }

    public void readSpawnData(ByteBuf buffer) {
        Entity entity;
        int entityId = buffer.readInt();
        if (this.thrower == null && entityId >= 0 && (entity = this.field_70170_p.func_73045_a(entityId)) instanceof EntityLivingBase) {
            this.thrower = (EntityPlayer)entity;
        }
        this.field_70165_t = buffer.readDouble();
        this.field_70163_u = buffer.readDouble();
        this.field_70161_v = buffer.readDouble();
        this.field_70159_w = buffer.readDouble();
        this.field_70181_x = buffer.readDouble();
        this.field_70179_y = buffer.readDouble();
        this.gravityVelocity = buffer.readFloat();
        this.rotationSlowdownFactor = buffer.readFloat();
        this.initialYaw = buffer.readFloat();
        this.initialPitch = buffer.readFloat();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        ModReference.LOG.debug("Restoring with position {}{}{}, rotation pitch {}, velocity {}, {}, {}", (Object)this.field_70165_t, (Object)this.field_70163_u, (Object)this.field_70161_v, (Object)Float.valueOf(this.field_70125_A), (Object)this.field_70159_w, (Object)this.field_70181_x, (Object)this.field_70179_y);
    }

    public float getXRotation() {
        return this.xRotation;
    }

    public float getYRotation() {
        return this.yRotation - this.initialYaw - 90.0f;
    }

    public float getZRotation() {
        return this.zRotation;
    }

    public boolean canCollideWithBlock(Block block, IBlockState iBlockState) {
        return iBlockState.func_185904_a().func_76230_c();
    }

    private void recordVelocityHistory() {
        double velocity = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y;
        this.velocityHistory.add(velocity);
        if (this.velocityHistory.size() > 10) {
            this.velocityHistory.poll();
        }
    }

    @Override
    public void setContext(ModContext modContext) {
        if (this.modContext == null) {
            this.modContext = modContext;
        }
    }
}

