/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.capabilities.EquipmentCapability;
import com.paneedah.mwc.network.NetworkPermitManager;
import com.paneedah.mwc.network.TypeRegistry;
import com.paneedah.weaponlib.AttachmentContainer;
import com.paneedah.weaponlib.CommonEventHandler;
import com.paneedah.weaponlib.EffectManager;
import com.paneedah.weaponlib.EntityShellCasing;
import com.paneedah.weaponlib.EntitySpreadable;
import com.paneedah.weaponlib.LightExposure;
import com.paneedah.weaponlib.MagazineReloadAspect;
import com.paneedah.weaponlib.MagazineState;
import com.paneedah.weaponlib.MaterialImpactSound;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.PlayerItemInstanceRegistry;
import com.paneedah.weaponlib.PlayerMagazineInstance;
import com.paneedah.weaponlib.PlayerTransitionProvider;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.SpreadableExposure;
import com.paneedah.weaponlib.SyncManager;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.WeaponAttachmentAspect;
import com.paneedah.weaponlib.WeaponFireAspect;
import com.paneedah.weaponlib.WeaponKeyInputHandler;
import com.paneedah.weaponlib.WeaponReloadAspect;
import com.paneedah.weaponlib.WeaponRenderer;
import com.paneedah.weaponlib.WeaponSpawnEntity;
import com.paneedah.weaponlib.WeaponState;
import com.paneedah.weaponlib.compatibility.CompatibleExposureCapability;
import com.paneedah.weaponlib.compatibility.CompatibleExtraEntityFlags;
import com.paneedah.weaponlib.compatibility.CompatiblePlayerEntityTrackerProvider;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.crafting.RecipeManager;
import com.paneedah.weaponlib.crafting.ammopress.BlockAmmoPress;
import com.paneedah.weaponlib.crafting.ammopress.TileEntityAmmoPress;
import com.paneedah.weaponlib.crafting.workbench.TileEntityWorkbench;
import com.paneedah.weaponlib.crafting.workbench.WorkbenchBlock;
import com.paneedah.weaponlib.electronics.EntityWirelessCamera;
import com.paneedah.weaponlib.electronics.HandheldState;
import com.paneedah.weaponlib.electronics.PlayerHandheldInstance;
import com.paneedah.weaponlib.electronics.PlayerTabletInstance;
import com.paneedah.weaponlib.electronics.TabletState;
import com.paneedah.weaponlib.grenade.EntityFlashGrenade;
import com.paneedah.weaponlib.grenade.EntityGasGrenade;
import com.paneedah.weaponlib.grenade.EntityGrenade;
import com.paneedah.weaponlib.grenade.EntitySmokeGrenade;
import com.paneedah.weaponlib.grenade.GrenadeAttackAspect;
import com.paneedah.weaponlib.grenade.GrenadeRenderer;
import com.paneedah.weaponlib.grenade.ItemGrenade;
import com.paneedah.weaponlib.grenade.PlayerGrenadeInstance;
import com.paneedah.weaponlib.inventory.GuiHandler;
import com.paneedah.weaponlib.melee.ItemMelee;
import com.paneedah.weaponlib.melee.MeleeAttachmentAspect;
import com.paneedah.weaponlib.melee.MeleeAttackAspect;
import com.paneedah.weaponlib.melee.MeleeRenderer;
import com.paneedah.weaponlib.melee.MeleeState;
import com.paneedah.weaponlib.melee.PlayerMeleeInstance;
import com.paneedah.weaponlib.state.Permit;
import com.paneedah.weaponlib.state.StateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CommonModContext
implements ModContext {
    protected Object mod;
    protected WeaponReloadAspect weaponReloadAspect;
    protected WeaponAttachmentAspect weaponAttachmentAspect;
    protected WeaponFireAspect weaponFireAspect;
    protected MeleeAttachmentAspect meleeAttachmentAspect;
    protected MeleeAttackAspect meleeAttackAspect;
    protected SyncManager<?> syncManager;
    protected MagazineReloadAspect magazineReloadAspect;
    protected NetworkPermitManager permitManager;
    protected PlayerItemInstanceRegistry playerItemInstanceRegistry;
    private Map<ResourceLocation, SoundEvent> registeredSounds = new HashMap<ResourceLocation, SoundEvent>();
    private RecipeManager recipeManager;
    private SoundEvent changeZoomSound;
    private SoundEvent changeFireModeSound;
    private SoundEvent noAmmoSound;
    private SoundEvent explosionSound;
    private SoundEvent flashExplosionSound;
    private SoundEvent nightVisionOnSound;
    private SoundEvent nightVisionOffSound;
    private Map<BulletImpactSoundKey, MaterialImpactSound> bulletImpactSoundEntries = new HashMap<BulletImpactSoundKey, MaterialImpactSound>();
    private int modEntityID = 256;
    private GrenadeAttackAspect grenadeAttackAspect;
    private Map<Integer, String> registeredTextureNames = new HashMap<Integer, String>();
    private int registeredTextureCounter;
    protected static ModContext currentContext;

    @Override
    public void preInit(Object mod) {
        this.mod = mod;
        this.weaponReloadAspect = new WeaponReloadAspect(this);
        this.magazineReloadAspect = new MagazineReloadAspect(this);
        this.weaponFireAspect = new WeaponFireAspect(this);
        this.weaponAttachmentAspect = new WeaponAttachmentAspect(this);
        this.meleeAttackAspect = new MeleeAttackAspect(this);
        this.meleeAttachmentAspect = new MeleeAttachmentAspect(this);
        this.grenadeAttackAspect = new GrenadeAttackAspect(this);
        StateManager grenadeStateManager = new StateManager((s1, s2) -> s1 == s2);
        this.grenadeAttackAspect.setStateManager(grenadeStateManager);
        this.permitManager = new NetworkPermitManager();
        this.syncManager = new SyncManager(this.permitManager);
        this.playerItemInstanceRegistry = new PlayerItemInstanceRegistry(this.syncManager);
        StateManager weaponStateManager = new StateManager((s1, s2) -> s1 == s2);
        this.weaponReloadAspect.setPermitManager(this.permitManager);
        this.weaponReloadAspect.setStateManager(weaponStateManager);
        this.weaponFireAspect.setPermitManager(this.permitManager);
        this.weaponFireAspect.setStateManager(weaponStateManager);
        this.weaponAttachmentAspect.setPermitManager(this.permitManager);
        this.weaponAttachmentAspect.setStateManager(weaponStateManager);
        StateManager meleeStateManager = new StateManager((s1, s2) -> s1 == s2);
        this.meleeAttackAspect.setStateManager(meleeStateManager);
        this.meleeAttachmentAspect.setPermitManager(this.permitManager);
        this.meleeAttachmentAspect.setStateManager(meleeStateManager);
        StateManager magazineStateManager = new StateManager((s1, s2) -> s1 == s2);
        this.magazineReloadAspect.setPermitManager(this.permitManager);
        this.magazineReloadAspect.setStateManager(magazineStateManager);
        this.recipeManager = new RecipeManager();
        ModernConfigManager.init();
        CommonEventHandler serverHandler = new CommonEventHandler(this);
        MinecraftForge.EVENT_BUS.register((Object)serverHandler);
        MinecraftForge.EVENT_BUS.register((Object)serverHandler);
        MinecraftForge.EVENT_BUS.register((Object)new WeaponKeyInputHandler(this, this::getPlayer, this.weaponAttachmentAspect));
        CompatiblePlayerEntityTrackerProvider.register(this);
        CompatibleExposureCapability.register(this);
        CompatibleExtraEntityFlags.register(this);
        EquipmentCapability.register();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mwc", "ammo" + this.modEntityID), WeaponSpawnEntity.class, (String)("Ammo" + this.modEntityID), (int)this.modEntityID++, (Object)mod, (int)64, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mwc", "wcam" + this.modEntityID), EntityWirelessCamera.class, (String)("wcam" + this.modEntityID), (int)this.modEntityID++, (Object)mod, (int)200, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mwc", "ShellCasing" + this.modEntityID), EntityShellCasing.class, (String)("ShellCasing" + this.modEntityID), (int)this.modEntityID++, (Object)mod, (int)64, (int)500, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mwc", "Grenade" + this.modEntityID), EntityGrenade.class, (String)("Grenade" + this.modEntityID), (int)this.modEntityID++, (Object)mod, (int)64, (int)10000, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mwc", "SmokeGrenade" + this.modEntityID), EntitySmokeGrenade.class, (String)("SmokeGrenade" + this.modEntityID), (int)this.modEntityID++, (Object)mod, (int)64, (int)10000, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mwc", "GasGrenade" + this.modEntityID), EntityGasGrenade.class, (String)("GasGrenade" + this.modEntityID), (int)this.modEntityID++, (Object)mod, (int)64, (int)10000, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mwc", "FlashGrenade" + this.modEntityID), EntityFlashGrenade.class, (String)("FlashGrenade" + this.modEntityID), (int)this.modEntityID++, (Object)mod, (int)64, (int)10000, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("mwc", "EntitySpreadable" + this.modEntityID), EntitySpreadable.class, (String)("EntitySpreadable" + this.modEntityID), (int)this.modEntityID++, (Object)mod, (int)64, (int)3, (boolean)false);
    }

    @Override
    public void preInitEnd(Object mod) {
        GameRegistry.registerTileEntity(TileEntityWorkbench.class, (String)"mwc:tileworkbench");
        Block workbenchblock = new WorkbenchBlock(this, "weapon_workbench", Material.field_151575_d).func_149647_a(MWC.BLOCKS_AND_INGOTS_TAB);
        if (workbenchblock.getRegistryName() == null) {
            if (workbenchblock.func_149739_a().length() < "mwc".length() + 2 + 5) {
                throw new IllegalArgumentException("Unlocalize block name too short " + workbenchblock.func_149739_a());
            }
            String unlocalizedName = workbenchblock.func_149739_a().toLowerCase();
            String registryName = unlocalizedName.substring(5 + "mwc".length() + 1);
            workbenchblock.setRegistryName("mwc", registryName);
        }
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)workbenchblock);
        ItemBlock workbenchItemBlock = new ItemBlock(workbenchblock);
        this.registerRenderableItem(workbenchblock.getRegistryName(), (Item)workbenchItemBlock, null);
        GameRegistry.registerTileEntity(TileEntityAmmoPress.class, (String)"mwc:tileammopress");
        Block ammopressblock = new BlockAmmoPress(this, "ammo_press", Material.field_151573_f).func_149647_a(MWC.BLOCKS_AND_INGOTS_TAB);
        if (ammopressblock.getRegistryName() == null) {
            if (ammopressblock.func_149739_a().length() < "mwc".length() + 2 + 5) {
                throw new IllegalArgumentException("Unlocalize block name too short " + ammopressblock.func_149739_a());
            }
            String unlocalizedName = ammopressblock.func_149739_a().toLowerCase();
            String registryName = unlocalizedName.substring(5 + "mwc".length() + 1);
            ammopressblock.setRegistryName("mwc", registryName);
        }
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)ammopressblock);
        ItemBlock ammoItemBlock = new ItemBlock(ammopressblock);
        this.registerRenderableItem(ammopressblock.getRegistryName(), (Item)ammoItemBlock, null);
    }

    @Override
    public void init(Object mod) {
        NetworkRegistry.INSTANCE.registerGuiHandler(mod, (IGuiHandler)new GuiHandler());
    }

    public static ModContext getContext() {
        return currentContext;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    public void registerServerSideOnly() {
    }

    @Override
    public SoundEvent registerSound(String sound) {
        if (sound == null) {
            return null;
        }
        ResourceLocation soundResourceLocation = new ResourceLocation("mwc", sound);
        return this.registerSound(soundResourceLocation);
    }

    protected SoundEvent registerSound(ResourceLocation soundResourceLocation) {
        SoundEvent result = this.registeredSounds.get(soundResourceLocation);
        if (result == null) {
            result = new SoundEvent(soundResourceLocation);
            this.registeredSounds.put(soundResourceLocation, result);
            result.setRegistryName(soundResourceLocation);
            ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)result);
        }
        return result;
    }

    @Override
    public void registerWeapon(String name, Weapon weapon, WeaponRenderer renderer) {
        weapon.setRegistryName("mwc", name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)weapon);
    }

    private EntityPlayer getServerPlayer(MessageContext ctx) {
        return ctx != null ? ctx.getServerHandler().field_147369_b : null;
    }

    protected EntityPlayer getPlayer(MessageContext ctx) {
        return this.getServerPlayer(ctx);
    }

    @Override
    public void registerRenderableItem(String name, Item item, Object renderer) {
        item.setRegistryName("mwc", name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    @Override
    public void registerRenderableItem(ResourceLocation name, Item item, Object renderer) {
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    @Override
    public PlayerItemInstanceRegistry getPlayerItemInstanceRegistry() {
        return this.playerItemInstanceRegistry;
    }

    @Override
    public WeaponReloadAspect getWeaponReloadAspect() {
        return this.weaponReloadAspect;
    }

    @Override
    public WeaponFireAspect getWeaponFireAspect() {
        return this.weaponFireAspect;
    }

    @Override
    public WeaponAttachmentAspect getAttachmentAspect() {
        return this.weaponAttachmentAspect;
    }

    @Override
    public MagazineReloadAspect getMagazineReloadAspect() {
        return this.magazineReloadAspect;
    }

    @Override
    public MeleeAttackAspect getMeleeAttackAspect() {
        return this.meleeAttackAspect;
    }

    @Override
    public MeleeAttachmentAspect getMeleeAttachmentAspect() {
        return this.meleeAttachmentAspect;
    }

    @Override
    public PlayerWeaponInstance getMainHeldWeapon() {
        throw new IllegalStateException();
    }

    @Override
    public RecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public void setChangeZoomSound(String sound) {
        this.changeZoomSound = this.registerSound(sound.toLowerCase());
    }

    @Override
    public SoundEvent getZoomSound() {
        return this.changeZoomSound;
    }

    @Override
    public SoundEvent getChangeFireModeSound() {
        return this.changeFireModeSound;
    }

    @Override
    public void setChangeFireModeSound(String sound) {
        this.changeFireModeSound = this.registerSound(sound.toLowerCase());
    }

    @Override
    public void setNoAmmoSound(String sound) {
        this.noAmmoSound = this.registerSound(sound.toLowerCase());
    }

    @Override
    public SoundEvent getNoAmmoSound() {
        return this.noAmmoSound;
    }

    @Override
    public void setExplosionSound(String sound) {
        this.explosionSound = this.registerSound(sound.toLowerCase());
    }

    @Override
    public SoundEvent getExplosionSound() {
        return this.explosionSound;
    }

    @Override
    public SoundEvent getFlashExplosionSound() {
        return this.flashExplosionSound;
    }

    @Override
    public void setFlashExplosionSound(String sound) {
        this.flashExplosionSound = this.registerSound(sound);
    }

    @Override
    public void setNightVisionOnSound(String sound) {
        this.nightVisionOnSound = this.registerSound(sound.toLowerCase());
    }

    @Override
    public SoundEvent getNightVisionOnSound() {
        return this.nightVisionOnSound;
    }

    @Override
    public void setNightVisionOffSound(String sound) {
        this.nightVisionOffSound = this.registerSound(sound.toLowerCase());
    }

    @Override
    public SoundEvent getNightVisionOffSound() {
        return this.nightVisionOffSound;
    }

    @Override
    public void registerMeleeWeapon(String name, ItemMelee itemMelee, MeleeRenderer renderer) {
        itemMelee.setRegistryName("mwc", name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemMelee);
    }

    @Override
    public void registerGrenadeWeapon(String name, ItemGrenade itemMelee, GrenadeRenderer renderer) {
        itemMelee.setRegistryName("mwc", name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemMelee);
    }

    @Override
    public ResourceLocation getNamedResource(String name) {
        return new ResourceLocation("mwc", name);
    }

    @Override
    public float getAspectRatio() {
        return 1.0f;
    }

    @Override
    public AttachmentContainer getGrenadeAttachmentAspect() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public GrenadeAttackAspect getGrenadeAttackAspect() {
        return this.grenadeAttackAspect;
    }

    @Override
    public Object getMod() {
        return this.mod;
    }

    @Override
    public EffectManager getEffectManager() {
        throw new IllegalStateException();
    }

    @Override
    public void registerRenderableEntity(Class<? extends Entity> entityClass, Object renderer) {
    }

    @Override
    public void setPlayerTransitionProvider(PlayerTransitionProvider playerTransitionProvider) {
    }

    @Override
    public CommonModContext setMaterialImpactSound(String sound, float volume, Material material) {
        MaterialImpactSound materialImpactSound = this.bulletImpactSoundEntries.computeIfAbsent(new BulletImpactSoundKey(material), key -> new MaterialImpactSound(volume));
        materialImpactSound.addSound(this.registerSound(sound.toLowerCase()));
        return this;
    }

    @Override
    public CommonModContext setMaterialsImpactSound(String sound, float volume, Material ... materials) {
        for (Material material : materials) {
            MaterialImpactSound materialImpactSound = this.bulletImpactSoundEntries.computeIfAbsent(new BulletImpactSoundKey(material), key -> new MaterialImpactSound(volume));
            materialImpactSound.addSound(this.registerSound(sound.toLowerCase()));
        }
        return this;
    }

    @Override
    public CommonModContext setMaterialsImpactSound(String sound, Material ... materials) {
        for (Material material : materials) {
            MaterialImpactSound materialImpactSound = this.bulletImpactSoundEntries.computeIfAbsent(new BulletImpactSoundKey(material), key -> new MaterialImpactSound(1.0f));
            materialImpactSound.addSound(this.registerSound(sound.toLowerCase()));
        }
        return this;
    }

    @Override
    public MaterialImpactSound getMaterialImpactSound(IBlockState iBlockState, WeaponSpawnEntity entity) {
        return this.bulletImpactSoundEntries.get(new BulletImpactSoundKey(iBlockState.func_185904_a()));
    }

    @Override
    public CommonModContext setMaterialImpactSounds(Material material, float volume, String ... sounds) {
        for (String sound : sounds) {
            this.setMaterialImpactSound(sound, volume, material);
        }
        return this;
    }

    @Override
    public int getRegisteredTextureId(String textureName) {
        if (textureName == null) {
            return -1;
        }
        Optional<Map.Entry> existingEntry = this.registeredTextureNames.entrySet().stream().filter(e -> textureName.equals(e.getValue())).findFirst();
        return existingEntry.isPresent() ? (Integer)existingEntry.get().getKey() : -1;
    }

    @Override
    public String getRegisteredTexture(int textureId) {
        return this.registeredTextureNames.get(textureId);
    }

    @Override
    public int registerTexture(String textureName) {
        int id;
        if (textureName == null) {
            return -1;
        }
        Optional<Map.Entry> existingEntry = this.registeredTextureNames.entrySet().stream().filter(e -> textureName.equals(e.getValue())).findFirst();
        if (existingEntry.isPresent()) {
            id = (Integer)existingEntry.get().getKey();
        } else {
            id = this.registeredTextureCounter++;
            this.registeredTextureNames.put(id, textureName);
        }
        return id;
    }

    public NetworkPermitManager getPermitManager() {
        return this.permitManager;
    }

    static {
        TypeRegistry.getINSTANCE().register(MagazineReloadAspect.LoadPermit.class);
        TypeRegistry.getINSTANCE().register(MagazineState.class);
        TypeRegistry.getINSTANCE().register(PlayerItemInstance.class);
        TypeRegistry.getINSTANCE().register(PlayerWeaponInstance.class);
        TypeRegistry.getINSTANCE().register(PlayerMagazineInstance.class);
        TypeRegistry.getINSTANCE().register(PlayerWeaponInstance.class);
        TypeRegistry.getINSTANCE().register(Permit.class);
        TypeRegistry.getINSTANCE().register(WeaponAttachmentAspect.EnterAttachmentModePermit.class);
        TypeRegistry.getINSTANCE().register(WeaponAttachmentAspect.ExitAttachmentModePermit.class);
        TypeRegistry.getINSTANCE().register(WeaponAttachmentAspect.ChangeAttachmentPermit.class);
        TypeRegistry.getINSTANCE().register(WeaponReloadAspect.CompoundPermit.class);
        TypeRegistry.getINSTANCE().register(WeaponReloadAspect.UnloadPermit.class);
        TypeRegistry.getINSTANCE().register(MagazineReloadAspect.LoadPermit.class);
        TypeRegistry.getINSTANCE().register(PlayerWeaponInstance.class);
        TypeRegistry.getINSTANCE().register(WeaponState.class);
        TypeRegistry.getINSTANCE().register(PlayerMeleeInstance.class);
        TypeRegistry.getINSTANCE().register(PlayerGrenadeInstance.class);
        TypeRegistry.getINSTANCE().register(PlayerTabletInstance.class);
        TypeRegistry.getINSTANCE().register(PlayerHandheldInstance.class);
        TypeRegistry.getINSTANCE().register(MeleeState.class);
        TypeRegistry.getINSTANCE().register(TabletState.class);
        TypeRegistry.getINSTANCE().register(HandheldState.class);
        TypeRegistry.getINSTANCE().register(SpreadableExposure.class);
        TypeRegistry.getINSTANCE().register(LightExposure.class);
    }

    static class BulletImpactSoundKey {
        private Material material;

        public BulletImpactSoundKey(Material material) {
            this.material = material;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.material == null ? 0 : this.material.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BulletImpactSoundKey other = (BulletImpactSoundKey)obj;
            if (this.material == null) {
                return other.material == null;
            }
            return this.material.equals(other.material);
        }
    }
}

