/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.capabilities.EquipmentCapability;
import com.paneedah.mwc.equipment.inventory.EquipmentInventory;
import com.paneedah.mwc.items.equipment.carryable.ItemBackpack;
import com.paneedah.mwc.network.messages.BalancePackClientMessage;
import com.paneedah.mwc.network.messages.CraftingClientMessage;
import com.paneedah.mwc.network.messages.EntityControlServerMessage;
import com.paneedah.mwc.network.messages.EntityInventorySyncMessage;
import com.paneedah.mwc.network.messages.ExposureMessage;
import com.paneedah.mwc.network.messages.LivingEntityTrackerMessage;
import com.paneedah.mwc.network.messages.SpreadableExposureMessage;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.CommonModContext;
import com.paneedah.weaponlib.Contextual;
import com.paneedah.weaponlib.EntityBounceable;
import com.paneedah.weaponlib.EntityProjectile;
import com.paneedah.weaponlib.Exposure;
import com.paneedah.weaponlib.ItemVest;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.SpreadableExposure;
import com.paneedah.weaponlib.compatibility.CompatibleExposureCapability;
import com.paneedah.weaponlib.compatibility.CompatibleExtraEntityFlags;
import com.paneedah.weaponlib.compatibility.CompatiblePlayerEntityTrackerProvider;
import com.paneedah.weaponlib.config.BalancePackManager;
import com.paneedah.weaponlib.crafting.CraftingFileManager;
import com.paneedah.weaponlib.electronics.ItemHandheld;
import com.paneedah.weaponlib.jim.util.ByteArrayUtils;
import com.paneedah.weaponlib.tracking.LivingEntityTracker;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommonEventHandler {
    private final ModContext modContext;

    public CommonEventHandler(ModContext modContext) {
        this.modContext = modContext;
    }

    public ModContext getModContext() {
        return this.modContext;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CommonModContext.currentContext = this.modContext;
        }
    }

    @SubscribeEvent
    protected void onCompatibleLivingUpdateEvent(LivingEvent.LivingUpdateEvent livingUpdateEvent) {
        if (!livingUpdateEvent.getEntity().field_70170_p.field_72995_K) {
            SpreadableExposure exposure;
            long lastSyncTimestamp;
            ItemStack itemStack = livingUpdateEvent.getEntityLiving().func_184614_ca();
            NBTTagCompound doseNbt = null;
            if (itemStack != null && itemStack.func_77973_b() instanceof ItemHandheld) {
                if (itemStack.func_77978_p() == null) {
                    itemStack.func_77982_d(new NBTTagCompound());
                }
                doseNbt = itemStack.func_77978_p();
            }
            boolean effectiveUpdate = false;
            Collection<? extends Exposure> exposures = CompatibleExposureCapability.getExposures(livingUpdateEvent.getEntity());
            Iterator<? extends Exposure> iterator = exposures.iterator();
            while (iterator.hasNext()) {
                Exposure exposure2 = iterator.next();
                exposure2.update(livingUpdateEvent.getEntity());
                if (doseNbt != null && exposure2 instanceof SpreadableExposure) {
                    doseNbt.func_74776_a("dose", ((SpreadableExposure)exposure2).getLastDose());
                }
                if (exposure2.isEffective(livingUpdateEvent.getEntity().field_70170_p)) continue;
                iterator.remove();
                effectiveUpdate = true;
            }
            if (effectiveUpdate) {
                CompatibleExposureCapability.updateExposures(livingUpdateEvent.getEntity(), exposures);
            }
            if ((lastSyncTimestamp = CompatibleExposureCapability.getLastSyncTimestamp(livingUpdateEvent.getEntity())) + 5L < livingUpdateEvent.getEntity().field_70170_p.func_82737_E() && livingUpdateEvent.getEntity() instanceof EntityPlayerMP) {
                MWC.CHANNEL.sendTo((IMessage)new ExposureMessage(exposures), (EntityPlayerMP)livingUpdateEvent.getEntity());
                CompatibleExposureCapability.setLastSyncTimestamp(livingUpdateEvent.getEntity(), livingUpdateEvent.getEntity().field_70170_p.func_82737_E());
            }
            if ((exposure = CompatibleExposureCapability.getExposure(livingUpdateEvent.getEntity(), SpreadableExposure.class)) != null) {
                ItemStack itemStack1;
                boolean stillEffective = exposure.isEffective(livingUpdateEvent.getEntity().field_70170_p);
                exposure.update(livingUpdateEvent.getEntity());
                if (livingUpdateEvent.getEntity() instanceof EntityPlayerMP && System.currentTimeMillis() - exposure.getLastSyncTimestamp() > 500L) {
                    MWC.CHANNEL.sendTo((IMessage)new SpreadableExposureMessage(stillEffective ? exposure : null), (EntityPlayerMP)livingUpdateEvent.getEntity());
                    exposure.setLastSyncTimestamp(System.currentTimeMillis());
                }
                if (!stillEffective) {
                    CompatibleExposureCapability.removeExposure(livingUpdateEvent.getEntity(), SpreadableExposure.class);
                }
                if ((itemStack1 = livingUpdateEvent.getEntityLiving().func_184614_ca()) != null && itemStack1.func_77973_b() instanceof ItemHandheld) {
                    if (itemStack1.func_77978_p() == null) {
                        itemStack1.func_77982_d(new NBTTagCompound());
                    }
                    NBTTagCompound nbt = itemStack1.func_77978_p();
                    nbt.func_74776_a("dose", exposure.getLastDose());
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Contextual) {
            ((Contextual)entity).setContext(this.modContext);
        }
        if (entity instanceof EntityPlayerMP && !event.getWorld().field_72995_K) {
            ModReference.LOG.debug("Player {} joined the world", (Object)event.getEntity());
            EntityPlayer player = (EntityPlayer)entity;
            LivingEntityTracker tracker = LivingEntityTracker.getTracker((EntityLivingBase)player);
            if (tracker != null) {
                MWC.CHANNEL.sendTo((IMessage)new LivingEntityTrackerMessage(tracker, null), (EntityPlayerMP)entity);
            }
            MWC.CHANNEL.sendTo((IMessage)new EntityControlServerMessage((Entity)player, CompatibleExtraEntityFlags.getFlags((Entity)player)), (EntityPlayerMP)entity);
            MWC.CHANNEL.sendToAll((IMessage)new EntityInventorySyncMessage(entity, false, EquipmentCapability.getInventory((EntityLivingBase)player)));
        }
    }

    @SubscribeEvent
    protected void onPlayerStartedTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayer && !event.getTarget().field_70170_p.field_72995_K) {
            MWC.CHANNEL.sendTo((IMessage)new EntityInventorySyncMessage(event.getTarget(), false, EquipmentCapability.getInventory((EntityLivingBase)event.getTarget())), (EntityPlayerMP)event.getEntityPlayer());
            return;
        }
        if (event.getTarget() instanceof EntityProjectile || event.getTarget() instanceof EntityBounceable) {
            return;
        }
        LivingEntityTracker tracker = LivingEntityTracker.getTracker((EntityLivingBase)((EntityPlayer)event.getEntity()));
        if (tracker != null && tracker.updateTrackableEntity(event.getTarget())) {
            ModReference.LOG.debug("Player {} started tracking {} with uuid {}", (Object)event.getEntityPlayer(), (Object)event.getTarget(), (Object)event.getTarget().func_110124_au());
            MWC.CHANNEL.sendTo((IMessage)new LivingEntityTrackerMessage(tracker, null), (EntityPlayerMP)event.getEntityPlayer());
            EntityPlayer player = (EntityPlayer)event.getEntity();
            MWC.CHANNEL.sendTo((IMessage)new EntityControlServerMessage((Entity)player, CompatibleExtraEntityFlags.getFlags((Entity)player)), (EntityPlayerMP)event.getEntity());
        }
    }

    @SubscribeEvent
    protected void onCompatibleLivingDeathEvent(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K && !entity.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            EquipmentInventory inventory = EquipmentCapability.getInventory(entity);
            for (int slotIndex = 0; slotIndex < inventory.func_70302_i_(); ++slotIndex) {
                ItemStack stackInSlot = inventory.func_70301_a(slotIndex);
                if (stackInSlot == null) continue;
                ((EntityPlayer)entity).func_146097_a(stackInSlot, true, false);
                inventory.func_70299_a(slotIndex, null);
            }
        }
    }

    @SubscribeEvent
    protected void onLivingHurtEvent(LivingHurtEvent event) {
        EntityLivingBase entityLiving = event.getEntityLiving();
        EquipmentInventory equipmentInventory = EquipmentCapability.getInventory(entityLiving);
        if (equipmentInventory != null && equipmentInventory.func_70301_a(1).func_77973_b() != Items.field_190931_a) {
            NonNullList stackList = NonNullList.func_191196_a();
            ItemStack[] itemStacks = new ItemStack[]{equipmentInventory.func_70301_a(1)};
            stackList.addAll(Arrays.asList(itemStacks));
            event.setAmount((float)((double)event.getAmount() * (1.0 - ((ItemVest)equipmentInventory.func_70301_a(1).func_77973_b()).getDamageBlocked())));
        }
    }

    @SubscribeEvent
    public void playerDroppedItem(PlayerDropsEvent event) {
        event.getDrops().removeIf(entityItem -> entityItem.func_92059_d().func_77973_b() instanceof ItemBackpack);
    }

    @SubscribeEvent
    protected void onPlayerCloneEvent(PlayerEvent.Clone event) {
        EquipmentInventory originalInventory = EquipmentCapability.getInventory((EntityLivingBase)event.getOriginal());
        if (originalInventory == null) {
            return;
        }
        EquipmentCapability.setInventory((EntityLivingBase)event.getEntityPlayer(), originalInventory);
        originalInventory.setContext(this.modContext);
        originalInventory.setOwner(event.getEntityPlayer());
    }

    @SubscribeEvent
    protected void onPlayerRespawnEvent(PlayerEvent.PlayerRespawnEvent event) {
        MWC.CHANNEL.sendToAll((IMessage)new EntityInventorySyncMessage((Entity)event.player, false, EquipmentCapability.getInventory((EntityLivingBase)event.player)));
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        MWC.CHANNEL.sendTo((IMessage)new BalancePackClientMessage(BalancePackManager.getActiveBalancePack()), (EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("mwc", "PLAYER_ENTITY_TRACKER"), (ICapabilityProvider)new CompatiblePlayerEntityTrackerProvider());
            event.addCapability(new ResourceLocation("mwc", "PLAYER_ENTITY_FLAGS"), (ICapabilityProvider)new CompatibleExtraEntityFlags());
            event.addCapability(new ResourceLocation("mwc", "PLAYER_CUSTOM_INVENTORY"), (ICapabilityProvider)new EquipmentCapability());
        }
        event.addCapability(new ResourceLocation("mwc", "EXPOSURE"), (ICapabilityProvider)new CompatibleExposureCapability());
    }

    protected void setSize(EntityPlayer entityPlayer, float width, float height) {
        if (width != entityPlayer.field_70130_N || height != entityPlayer.field_70131_O) {
            entityPlayer.field_70130_N = width;
            entityPlayer.field_70131_O = height;
            AxisAlignedBB axisalignedbb = entityPlayer.func_174813_aQ();
            entityPlayer.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)entityPlayer.field_70130_N, axisalignedbb.field_72338_b + (double)entityPlayer.field_70131_O, axisalignedbb.field_72339_c + (double)entityPlayer.field_70130_N));
        }
    }

    @SubscribeEvent
    public final void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        int updatedFlags = CompatibleExtraEntityFlags.getFlags((Entity)event.player);
        if ((updatedFlags & CompatibleExtraEntityFlags.PRONING) != 0) {
            this.setSize(event.player, 0.6f, 0.6f);
        }
    }

    @SubscribeEvent
    public final void onEntityJoinedEvent(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityPlayer) || FMLCommonHandler.instance().getMinecraftServerInstance() == null || !FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        ByteArrayOutputStream baos = ByteArrayUtils.createByteArrayOutputStreamFromBytes(CraftingFileManager.getInstance().getCurrentFileHash());
        if (baos == null) {
            return;
        }
        MWC.CHANNEL.sendTo((IMessage)new CraftingClientMessage(0, baos), (EntityPlayerMP)player);
    }
}

