/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.renderer;

import com.paneedah.mwc.utils.ModReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.minecraft.client.model.ModelBiped;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class EquipmentModelPools {
    private static final HashMap<String, ModelBiped> modelPool = new HashMap();
    private static final HashMap<String, ModelBiped> equippedPool = new HashMap();
    private static final HashMap<String, ModelBiped> equippedArmorPool = new HashMap();

    public static ModelBiped get(String name) {
        return EquipmentModelPools.get(name, modelPool);
    }

    public static ModelBiped getEquipped(String name) {
        return EquipmentModelPools.get(name, equippedPool);
    }

    public static ModelBiped getEquippedArmor(String name, boolean slim) {
        return EquipmentModelPools.get(name + (slim ? "Slim" : ""), equippedArmorPool);
    }

    public static long getSize() {
        return EquipmentModelPools.getSize(modelPool);
    }

    public static long getEquippedSize() {
        return EquipmentModelPools.getSize(equippedPool);
    }

    public static long getEquippedArmorSize() {
        return EquipmentModelPools.getSize(equippedArmorPool);
    }

    private static ModelBiped get(String name, HashMap<String, ModelBiped> pool) {
        if (!pool.containsKey(name)) {
            try {
                pool.put(name, (ModelBiped)Class.forName(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                ModReference.RED_LOG.printFramedError("Equipment Pool", "Failed to load equipment model: " + name, "Non critical exception, model will not be loaded", new String[]{exception.getMessage()});
            }
        }
        return pool.get(name);
    }

    private static long getSize(HashMap<String, ModelBiped> pool) {
        return pool.size();
    }
}

