/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.groovyscript.script;

import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.api.IIngredient;
import com.cleanroommc.groovyscript.helper.ingredient.OreDictIngredient;
import com.cleanroommc.groovyscript.helper.recipe.AbstractRecipeBuilder;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import com.paneedah.mwc.groovyscript.MWCGroovyPlugin;
import com.paneedah.mwc.groovyscript.recipes.GSCrafting;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.CraftingRegistry;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class CraftingStation
extends VirtualizedRegistry<IModernCraftingRecipe> {
    public void onReload() {
        this.removeScripted().forEach(CraftingRegistry::deleteRecipeRegistry);
        this.restoreFromBackup().forEach(CraftingRegistry::registerRecipe);
    }

    public void removeAll() {
        for (ArrayList<IModernCraftingRecipe> list : CraftingRegistry.craftingMap.values()) {
            for (IModernCraftingRecipe recipe : list) {
                CraftingRegistry.deleteRecipeRegistry(recipe);
                this.addBackup(recipe);
            }
        }
    }

    public void remove(IIngredient ingredient) {
        for (ArrayList<IModernCraftingRecipe> list : CraftingRegistry.craftingMap.values()) {
            for (IModernCraftingRecipe recipe : list) {
                if (!ingredient.test((Object)recipe.getItemStack())) continue;
                CraftingRegistry.deleteRecipeRegistry(recipe);
                this.addBackup(recipe);
            }
        }
    }

    public void removeAllinGroup(String group) {
        CraftingRegistry.clearGroup(CraftingGroup.valueOf(group));
    }

    public void removeInGroup(IIngredient ingredient, CraftingGroup group) {
        for (IModernCraftingRecipe recipe : CraftingRegistry.craftingMap.get((Object)group)) {
            if (!ingredient.test((Object)recipe.getItemStack())) continue;
            CraftingRegistry.deleteRecipeRegistry(recipe);
            this.addBackup(recipe);
        }
    }

    public void removeInGroup(IIngredient ingredient, String group) {
        this.removeInGroup(ingredient, CraftingGroup.valueOf(group));
    }

    public void addRecipe(IModernCraftingRecipe crafting) {
        CraftingRegistry.registerRecipe(crafting);
        this.addScripted(crafting);
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder();
    }

    public static class RecipeBuilder
    extends AbstractRecipeBuilder<GSCrafting> {
        private final ArrayList<Double> yields = new ArrayList();
        private double yield = 1.0;
        private CraftingGroup group = CraftingGroup.GUN;

        public String getErrorMsg() {
            return "Error adding Modern Warfare Cubed Workbench Recipe: " + this.name;
        }

        public void validate(GroovyLog.Msg msg) {
            this.validateItems(msg, 1, 27, 1, 1);
        }

        public AbstractRecipeBuilder<GSCrafting> input(IIngredient ingredient) {
            this.yields.add(this.yield);
            return super.input(ingredient);
        }

        public RecipeBuilder setYield(double yield) {
            this.yield = yield;
            return this;
        }

        public RecipeBuilder setGroup(String group) {
            this.group = CraftingGroup.valueOf(group);
            return this;
        }

        public GSCrafting register() {
            if (!this.validate()) {
                return null;
            }
            ArrayList<CraftingEntry> entries = new ArrayList<CraftingEntry>();
            for (int i = 0; i < this.input.size(); ++i) {
                IIngredient ingredient = (IIngredient)this.input.get(i);
                if (ingredient instanceof OreDictIngredient) {
                    OreDictIngredient dict = (OreDictIngredient)ingredient;
                    entries.add(new CraftingEntry(dict.getFirst().func_77973_b(), dict.getOreDict(), dict.getAmount(), (double)this.yields.get(i)));
                    continue;
                }
                entries.add(new CraftingEntry(ingredient.getMatchingStacks()[0].func_77973_b(), ingredient.getAmount(), (double)this.yields.get(i)));
            }
            GSCrafting recipe = new GSCrafting((ItemStack)this.output.get(0), this.group, entries.toArray(new CraftingEntry[0]));
            MWCGroovyPlugin.craftingStation.addRecipe(recipe);
            return recipe;
        }
    }
}

