/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.api.integration.ITBPlugin;
import com.tiviacz.travelersbackpack.api.integration.TBPlugin;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class IntegrationHandler {
    List<String> mods = new ArrayList<String>();
    List<ITBPlugin> integrations = new ArrayList<ITBPlugin>();
    List<ITBPlugin> temp = new ArrayList<ITBPlugin>();

    private void findIntegrations(ASMDataTable asmDataTable) {
        LogHelper.info("Starting the Integration Handler.", new Object[0]);
        this.fetchModIntegrations(asmDataTable);
        if (!this.temp.isEmpty()) {
            LogHelper.info("Found {} possible mod integration(s)!", this.temp.size());
        }
        if (this.temp.isEmpty()) {
            LogHelper.info("Didn't find any possible mod integration(s)!", new Object[0]);
        }
    }

    private void fetchModIntegrations(ASMDataTable asmDataTable) {
        List<ITBPlugin> plugins = this.fetchPlugins(asmDataTable, TBPlugin.class, ITBPlugin.class);
        if (!plugins.isEmpty()) {
            this.temp.addAll(plugins);
        }
    }

    private <T> List<T> fetchPlugins(ASMDataTable asmDataTable, Class annotationClass, Class<T> instanceClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                T instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LogHelper.error("Failed to load: {}", asmData.getClassName(), e);
            }
        }
        return instances;
    }

    private void search() {
        if (!this.temp.isEmpty()) {
            for (ITBPlugin plugin : this.temp) {
                if (!plugin.canLoad()) continue;
                LogHelper.info("Found a integration for mod {}", plugin.getModName());
                this.integrations.add(plugin);
                this.mods.add(plugin.getModName());
            }
            this.temp.clear();
            if (!this.mods.isEmpty()) {
                LogHelper.info("Mod integrations found: {}", this.mods);
            }
        }
    }

    public void preInit(FMLPreInitializationEvent event) {
        this.findIntegrations(event.getAsmData());
    }

    public void init(FMLInitializationEvent event) {
        this.search();
        if (!this.integrations.isEmpty()) {
            for (ITBPlugin plugin : this.integrations) {
                plugin.init();
            }
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (!this.integrations.isEmpty()) {
            for (ITBPlugin plugin : this.integrations) {
                plugin.postInit();
            }
        }
    }
}

