/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.materials;

import com.endertech.common.Args;
import com.endertech.common.Fields;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.economy.IValuable;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.units.UnitId;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeMaterial
extends ForgeItem
implements IValuable {
    private final Type type;
    private final String name;
    private final float strength;
    private final float heaviness;
    private final float frequency;
    private final float magicability;
    private final ColorARGB color;

    public ForgeMaterial(ForgeMod mod, UnitConfig config, Type type, String name, float strength, float heaviness, float frequency, float magicability, ColorARGB color) {
        super(mod, config, name, CreativeTabs.field_78035_l);
        this.type = type;
        this.name = name;
        FloatBounds bounds = ForgeBounds.FACTOR.getFloatBounds();
        this.strength = ForgeConfig.getFloat(config, this.getUnitCategory(), "strength", strength, bounds, "Defines how strong the material is. Affects: physical resistance, durability, weapons & tools power etc.");
        this.heaviness = ForgeConfig.getFloat(config, this.getUnitCategory(), "heaviness", heaviness, bounds, "Defines how heavy one gramm of the material is. Affects: damage, speed");
        this.frequency = ForgeConfig.getFloat(config, this.getUnitCategory(), "frequency", frequency, bounds, "Defines how often this material appears in the world. Affects: loot and ore generation.");
        this.magicability = ForgeConfig.getFloat(config, this.getUnitCategory(), "magicability", magicability, bounds, "Defines how magical the material is. Affects: enchantability, magic resistance.");
        this.color = ForgeConfig.getColorARGB(config, this.getUnitCategory(), "color", color, "Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)");
    }

    public static ForgeMaterial noRegistry(ForgeMod mod, Type type, String name, float strength, float heaviness, float frequency, float magicability, ColorARGB color) {
        ForgeMaterial material = new ForgeMaterial(mod, null, type, name, strength, heaviness, frequency, magicability, color);
        mod.getRegistrator().removeUnit(material);
        return material;
    }

    public static int calculateEnchantability(ForgeMaterial material) {
        return ForgeBounds.ENCHANTABILITY.getIntBounds().approxUp(material.getMagicability());
    }

    public static float calculateHardness(ForgeMaterial material) {
        return ForgeBounds.HARDNESS.getFloatBounds().approxUp(material.getStrength()).floatValue();
    }

    public static float calculateResistance(ForgeMaterial material) {
        return ForgeBounds.RESISTANCE.getFloatBounds().approxUp(material.getStrength()).floatValue();
    }

    public static int calculateHarvestLevel(ForgeMaterial material) {
        float harvestLevel = ForgeBounds.HARVEST_LEVEL.getFloatBounds().approxUp(material.getStrength()).floatValue();
        return (int)Math.floor(harvestLevel);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(ChatFormatting.GREEN + "Strength: " + this.getStrength());
        tooltip.add(ChatFormatting.YELLOW + "Heaviness: " + this.getHeaviness());
        tooltip.add(ChatFormatting.LIGHT_PURPLE + "Magicability: " + this.getMagicability());
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @Override
    public String toString() {
        return ForgeMaterial.class.getSimpleName() + Args.group(Args.get("strength", Float.valueOf(this.getStrength())), Args.get("heaviness", Float.valueOf(this.getHeaviness())), Args.get("frequency", Float.valueOf(this.getFrequency())), Args.get("magicability", Float.valueOf(this.getMagicability()))) + Args.extend(super.toString());
    }

    public String getName() {
        return this.name;
    }

    public float getStrength() {
        return this.strength;
    }

    public float getHeaviness() {
        return this.heaviness;
    }

    public float getFrequency() {
        return this.frequency;
    }

    public float getMagicability() {
        return this.magicability;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    @Override
    public float getWorthness() {
        return this.getStrength() * 0.3f + ForgeBounds.invertFactor(this.getHeaviness()) * 0.1f + ForgeBounds.invertFactor(this.getFrequency()) * 0.4f + this.getMagicability() * 0.2f;
    }

    public Type getType() {
        return this.type;
    }

    public UnitId getRepairId() {
        return UnitId.from(this.getType() == Type.METAL ? Type.INGOT.getDictNameFor(this.getName()) : this.getId().getDictName());
    }

    public static class VanillaMaterials {
        static final Map<Material, String> MATERIAL_NAMES = new HashMap<Material, String>();

        public static String getNameFor(Material material, String defaultName) {
            return MATERIAL_NAMES.getOrDefault(material, defaultName);
        }

        static {
            List<Field> fields = Fields.getStaticFrom(Material.class);
            for (Field field : fields) {
                if (field.getType() != Material.class) continue;
                try {
                    Material material = (Material)field.get(null);
                    MATERIAL_NAMES.put(material, field.getName());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static enum Type implements IForgeEnum
    {
        BLOCK,
        DUST,
        GEM,
        INGOT,
        METAL;


        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }

        public String getDictNameFor(String materialName) {
            return UnitId.buildDictName(this.func_176610_l(), materialName);
        }
    }
}

