/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.ForgeLocating;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.units.IForgeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ForgePotion
extends Potion {
    protected final ResourceLocation texture;

    protected ForgePotion(ForgeMod mod, boolean isBadEffect, ColorARGB liquidColor) {
        super(isBadEffect, liquidColor.getARGB());
        String name = IForgeUnit.getClassRegName(((Object)((Object)this)).getClass());
        this.texture = ForgeLocating.potionTexture(mod.getId(), name, new String[0]);
        this.func_76390_b("potion." + name);
        this.setRegistryName(name);
        ForgeRegistries.POTIONS.register((IForgeRegistryEntry)this);
    }

    public abstract void func_76394_a(EntityLivingBase var1, int var2);

    public PotionEffect createEffect(CommonTime.Interval duration) {
        return this.createEffect(duration, true);
    }

    public PotionEffect createEffect(CommonTime.Interval duration, boolean showParticles) {
        int ticks = (int)GameTime.inServerTicks(duration);
        PotionEffect effect = new PotionEffect((Potion)this, ticks, 0, false, showParticles);
        return effect;
    }

    public boolean func_76397_a(int ticksLeft, int amplifier) {
        int reminder = ticksLeft % this.getUpdateInterval();
        return reminder == 0;
    }

    public int getUpdateInterval() {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        this.drawTexture(x + 7, y + 8, mc);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        this.drawTexture(x + 4, y + 4, mc);
    }

    @SideOnly(value=Side.CLIENT)
    protected int getTextureSize() {
        return 16;
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawTexture(int x, int y, Minecraft mc) {
        mc.field_71446_o.func_110577_a(this.texture);
        int size = this.getTextureSize();
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)size, (int)size, (float)size, (float)size);
    }
}

