/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.ConnectingRodValveGear;
import cam72cam.immersiverailroading.model.part.ValveGear;
import cam72cam.immersiverailroading.model.part.WheelSet;
import cam72cam.mod.math.Vec3d;
import java.util.Comparator;
import java.util.stream.Collectors;
import util.Matrix4;

public class StephensonValveGear
extends ConnectingRodValveGear {
    protected final ModelComponent drivingRod;
    protected final ModelComponent pistonRod;
    protected final ModelComponent cylinder;
    protected final boolean reverse;
    protected final Vec3d drivenWheel;

    public static StephensonValveGear get(WheelSet wheels, ComponentProvider provider, ModelState state, ModelComponentType.ModelPosition pos, float angleOffset) {
        ModelComponent drivingRod = provider.parse(ModelComponentType.MAIN_ROD_SIDE, pos);
        ModelComponent connectingRod = provider.parse(ModelComponentType.SIDE_ROD_SIDE, pos);
        ModelComponent pistonRod = provider.parse(ModelComponentType.PISTON_ROD_SIDE, pos);
        ModelComponent cylinder = provider.parse(ModelComponentType.CYLINDER_SIDE, pos);
        ModelComponent frontExhaust = provider.parse(ModelComponentType.CYLINDER_DRAIN_SIDE, pos.and(ModelComponentType.ModelPosition.A));
        ModelComponent rearExhaust = provider.parse(ModelComponentType.CYLINDER_DRAIN_SIDE, pos.and(ModelComponentType.ModelPosition.B));
        return drivingRod != null && connectingRod != null && pistonRod != null ? new StephensonValveGear(wheels, state, drivingRod, connectingRod, pistonRod, cylinder, angleOffset, frontExhaust, rearExhaust) : null;
    }

    public StephensonValveGear(WheelSet wheels, ModelState state, ModelComponent drivingRod, ModelComponent connectingRod, ModelComponent pistonRod, ModelComponent cylinder, float angleOffset, ModelComponent frontExhaust, ModelComponent rearExhaust) {
        super(wheels, state, connectingRod, angleOffset);
        this.drivingRod = drivingRod;
        this.pistonRod = pistonRod;
        this.cylinder = cylinder;
        Vec3d center = ModelComponent.center(wheels.wheels.stream().map(x -> x.wheel).collect(Collectors.toList()));
        this.reverse = pistonRod.center.x > center.x;
        this.angleOffset = angleOffset + (float)(this.reverse ? -90 : 0);
        this.drivenWheel = wheels.wheels.stream().map(w -> w.wheel.center).min(Comparator.comparingDouble(w -> w.distanceTo(this.reverse ? drivingRod.min : drivingRod.max))).get();
        this.centerOfWheels = drivingRod.pos.equals(ModelComponentType.ModelPosition.CENTER) ? this.drivenWheel : center;
        state.include(cylinder);
        state.push(builder -> builder.add((stock, partialTicks) -> {
            Matrix4 matrix = new Matrix4();
            Vec3d connRodMovment = this.connRodMovement(stock);
            Vec3d drivingRodRotPoint = new Vec3d(this.reverse ? drivingRod.min.x + drivingRod.height() / 2.0 : drivingRod.max.x - drivingRod.height() / 2.0, drivingRod.center.y, this.reverse ? drivingRod.min.z : drivingRod.max.z);
            float drivingRodAngle = (float)Math.toDegrees(Math.atan2(this.reverse ? -connRodMovment.z : connRodMovment.z, drivingRod.length() - drivingRod.height()));
            double connRodRadius = this.connRodRadius();
            matrix.translate(-connRodRadius, 0.0, 0.0);
            matrix.translate(connRodMovment.x, connRodMovment.z, 0.0);
            matrix.translate(drivingRodRotPoint.x, drivingRodRotPoint.y, drivingRodRotPoint.z);
            matrix.rotate(Math.toRadians(drivingRodAngle), 0.0, 0.0, 1.0);
            matrix.translate(-drivingRodRotPoint.x, -drivingRodRotPoint.y, -drivingRodRotPoint.z);
            return matrix;
        })).include(drivingRod);
        state.push(builder -> builder.add((stock, partialTicks) -> {
            Matrix4 matrix = new Matrix4();
            Vec3d connRodMovment = this.connRodMovement(stock);
            double pistonDelta = connRodMovment.x - this.connRodRadius();
            matrix.translate(pistonDelta, 0.0, 0.0);
            return matrix;
        })).include(pistonRod);
        this.frontExhaust = frontExhaust != null ? new ValveGear.Exhaust(frontExhaust, 90.0f) : (ValveGear)this.new ValveGear.Exhaust(pistonRod.min, pistonRod.pos, 90.0f);
        this.rearExhaust = rearExhaust != null ? new ValveGear.Exhaust(rearExhaust, 270.0f) : (ValveGear)this.new ValveGear.Exhaust(pistonRod.min, pistonRod.pos, 270.0f);
    }
}

