/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.animation;

import cam72cam.immersiverailroading.model.animation.Animatrix;
import cam72cam.mod.resource.Identifier;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import util.Matrix4;

public class AnimatrixSet {
    private final float min;
    private final float max;
    Map<Float, Animatrix> steps = new HashMap<Float, Animatrix>();

    public AnimatrixSet(Map<Float, Identifier> input, double internal_model_scale) throws IOException {
        for (Map.Entry<Float, Identifier> entry : input.entrySet()) {
            this.steps.put(entry.getKey(), new Animatrix(entry.getValue().getResourceStream(), internal_model_scale));
        }
        if (this.steps.isEmpty()) {
            throw new RuntimeException("Invalid Animatrix Configuration (empty)");
        }
        this.min = (float)this.steps.keySet().stream().mapToDouble(x -> x.floatValue()).min().getAsDouble();
        this.max = (float)this.steps.keySet().stream().mapToDouble(x -> x.floatValue()).max().getAsDouble();
    }

    public Matrix4 getMatrix(String group, float index, float percent, boolean looping) {
        float min = this.min;
        float max = this.max;
        for (Float step : this.steps.keySet()) {
            if (step.floatValue() < index && step.floatValue() > min) {
                min = step.floatValue();
            }
            if (!(step.floatValue() > index) || !(step.floatValue() < max)) continue;
            max = step.floatValue();
        }
        if (min == max) {
            return this.steps.get(Float.valueOf(min)).getMatrix(group, percent, looping);
        }
        Matrix4 ms = this.steps.get(Float.valueOf(min)).getMatrix(group, percent, looping);
        Matrix4 me = this.steps.get(Float.valueOf(max)).getMatrix(group, percent, looping);
        if (ms == null) {
            return me;
        }
        if (me == null) {
            return ms;
        }
        float lerp = (index - min) / (max - min);
        return ms.slerp(me, lerp);
    }
}

