/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.animation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import util.Matrix4;

public class Animatrix {
    private final Map<String, List<Matrix4>> map = new HashMap<String, List<Matrix4>>();
    private final int frameCount;

    public Animatrix(InputStream in, double internal_model_scale) throws IOException {
        Matrix4 scale = new Matrix4();
        scale.m33 = 1.0 / internal_model_scale;
        Matrix4 inv = scale.copy();
        inv.m33 = internal_model_scale;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Matrix4> frames = new ArrayList<Matrix4>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("O ")) {
                    for (String name : names) {
                        this.map.put(name, frames);
                    }
                    names = new ArrayList();
                    frames = new ArrayList();
                    names.add(line.substring(2));
                    continue;
                }
                if (line.startsWith("A ")) {
                    names.add(line.substring(2));
                    continue;
                }
                if (line.startsWith("M ")) {
                    String[] mm = line.substring(2).split(",");
                    frames.add(new Matrix4(Double.parseDouble(mm[0]), Double.parseDouble(mm[1]), Double.parseDouble(mm[2]), Double.parseDouble(mm[3]), Double.parseDouble(mm[4]), Double.parseDouble(mm[5]), Double.parseDouble(mm[6]), Double.parseDouble(mm[7]), Double.parseDouble(mm[8]), Double.parseDouble(mm[9]), Double.parseDouble(mm[10]), Double.parseDouble(mm[11]), Double.parseDouble(mm[12]), Double.parseDouble(mm[13]), Double.parseDouble(mm[14]), Double.parseDouble(mm[15])).multiply(inv).leftMultiply(scale));
                    continue;
                }
                throw new RuntimeException("Invalid line '" + line + "'");
            }
            if (!frames.isEmpty()) {
                for (String name : names) {
                    this.map.put(name, frames);
                }
            }
        }
        this.frameCount = this.map.values().stream().mapToInt(List::size).max().getAsInt();
    }

    public Set<String> groups() {
        return this.map.keySet();
    }

    public Matrix4 getMatrix(String group, float percent, boolean looping) {
        List<Matrix4> frames = this.map.get(group);
        if (frames == null) {
            return null;
        }
        if (!looping) {
            if (percent >= ((float)frames.size() - 1.0f) / (float)frames.size()) {
                return frames.get(frames.size() - 1).copy();
            }
            if (percent <= 0.0f) {
                return frames.get(0).copy();
            }
        }
        percent = (percent % 1.0f + 1.0f) % 1.0f;
        double frame = (float)frames.size() * percent;
        Matrix4 ms = frames.get((int)Math.floor(frame) % frames.size());
        Matrix4 me = frames.get((int)Math.ceil(frame) % frames.size());
        float lerp = (float)(frame - Math.floor(frame));
        return ms.slerp(me, lerp);
    }

    public int frameCount() {
        return this.frameCount;
    }
}

