/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.Tender;
import cam72cam.immersiverailroading.inventory.SlotFilter;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.model.part.Control;
import cam72cam.immersiverailroading.registry.LocomotiveSteamDefinition;
import cam72cam.immersiverailroading.util.BurnUtil;
import cam72cam.immersiverailroading.util.FluidQuantity;
import cam72cam.immersiverailroading.util.LiquidUtil;
import cam72cam.immersiverailroading.util.Speed;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.fluid.Fluid;
import cam72cam.mod.fluid.FluidStack;
import cam72cam.mod.fluid.ITank;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.stream.Collectors;

public class LocomotiveSteam
extends Locomotive {
    @TagSync
    @TagField(value="boiler_psi")
    private float boilerPressure = 0.0f;
    @TagSync
    @TagField(value="boiler_temperature")
    private float boilerTemperature;
    @TagSync
    @TagField(value="pressure_valve")
    private boolean pressureValve = false;
    @TagSync
    @TagField(value="burn_time", mapper=SlotTagMapper.class)
    private Map<Integer, Integer> burnTime = new HashMap<Integer, Integer>();
    @TagSync
    @TagField(value="burn_max", mapper=SlotTagMapper.class)
    private Map<Integer, Integer> burnMax = new HashMap<Integer, Integer>();
    private float drainRemainder;

    public LocomotiveSteam() {
        this.boilerTemperature = this.ambientTemperature();
    }

    @Override
    public LocomotiveSteamDefinition getDefinition() {
        return super.getDefinition(LocomotiveSteamDefinition.class);
    }

    @Override
    public boolean openGui(Player player) {
        if (!this.getDefinition().isCabCar() && player.hasPermission(Permissions.LOCOMOTIVE_CONTROL)) {
            GuiTypes.STEAM_LOCOMOTIVE.open(player, (Entity)this);
            return true;
        }
        return false;
    }

    public float getBoilerTemperature() {
        return this.boilerTemperature;
    }

    private void setBoilerTemperature(float temp) {
        this.boilerTemperature = temp;
    }

    public float getBoilerPressure() {
        return this.boilerPressure;
    }

    private void setBoilerPressure(float temp) {
        this.boilerPressure = temp;
    }

    public Map<Integer, Integer> getBurnTime() {
        return this.burnTime;
    }

    public Map<Integer, Integer> getBurnMax() {
        return this.burnMax;
    }

    @Override
    public double getAppliedTractiveEffort(Speed speed) {
        if (this.getDefinition().isCabCar()) {
            return 0.0;
        }
        double traction_N = Math.max((double)this.getDefinition().getStartingTractionNewtons(this.gauge), (double)(this.getDefinition().getHorsePower(this.gauge) * 375) / Math.max(Math.abs(speed.imperial()), 1.0));
        if (Config.isFuelRequired(this.gauge)) {
            traction_N = traction_N / (double)this.getDefinition().getMaxPSI(this.gauge) * (double)this.getBoilerPressure();
        }
        double reverser = this.getReverser();
        double reverserCap = 0.25;
        double maxReverser = 1.0 - Math.abs(this.getCurrentSpeed().metric()) / this.getDefinition().getMaxSpeed(this.gauge).metric() * reverserCap;
        double multiplier = Math.copySign(Math.abs(Math.pow((double)this.getThrottle() * Math.min(Math.abs(reverser), maxReverser), 3.0)), reverser);
        return traction_N * multiplier;
    }

    @Override
    public void onDissassemble() {
        super.onDissassemble();
        this.setBoilerTemperature(this.ambientTemperature());
        this.setBoilerPressure(0.0f);
        for (Integer slot : this.burnTime.keySet()) {
            this.burnTime.put(slot, 0);
        }
    }

    @Override
    public double getTractiveEffortNewtons(Speed speed) {
        return (double)(this.getDefinition().cab_forward ? -1 : 1) * super.getTractiveEffortNewtons(speed);
    }

    @Override
    public double slipCoefficient(Speed speed) {
        double slipMult = super.slipCoefficient(speed);
        if (speed.metric() != 0.0) {
            double balance = 1.0 / (Math.abs(speed.metric()) + 300.0) / 0.0033333333333333335;
            slipMult *= balance;
        }
        double ratio = 0.35;
        double hammer = ratio + (this.slipping ? 0.0 : Math.abs(Math.sin(Math.toRadians(360.0 * this.distanceTraveled / (5.0 * this.gauge.scale() / 2.0))) * (1.0 - ratio)));
        return slipMult *= hammer;
    }

    @Override
    protected double simulateWheelSlip() {
        return (double)(this.getDefinition().cab_forward ? -1 : 1) * super.simulateWheelSlip();
    }

    @Override
    public void onTick() {
        EntityCoupleableRollingStock.CouplerType coupler;
        super.onTick();
        if (this.getWorld().isClient) {
            return;
        }
        if (this.getTickCount() < 2) {
            return;
        }
        OptionalDouble control = this.getDefinition().getModel().getControls().stream().filter(x -> x.part.type == ModelComponentType.WHISTLE_CONTROL_X).mapToDouble(this::getControlPosition).max();
        if (control.isPresent() && control.getAsDouble() > 0.0) {
            this.setHorn(10, this.hornPlayer);
        }
        if (!this.isBuilt() || this.getDefinition().isCabCar()) {
            return;
        }
        FreightTank stock = this;
        EntityCoupleableRollingStock.CouplerType couplerType = coupler = this.getDefinition().cab_forward ? EntityCoupleableRollingStock.CouplerType.FRONT : EntityCoupleableRollingStock.CouplerType.BACK;
        while (coupler != null && stock.getCoupled(coupler) instanceof Tender) {
            Tender tender = (Tender)stock.getCoupled(coupler);
            int desiredDrain = 10;
            if (this.getTankCapacity().MilliBuckets() - this.getServerLiquidAmount() >= 10) {
                this.theTank.drain((ITank)tender.theTank, desiredDrain, false);
            }
            if (this.getTickCount() % 20 == 0 && this.getDefinition().tender_auto_feed) {
                for (int slot = 2; slot < this.cargoItems.getSlotCount(); ++slot) {
                    if (BurnUtil.getBurnTime(this.cargoItems.get(slot)) == 0) continue;
                    for (int tenderSlot = 0; tenderSlot < tender.cargoItems.getSlotCount(); ++tenderSlot) {
                        if (!this.cargoItems.get(slot).is(tender.cargoItems.get(tenderSlot)) || this.cargoItems.get(slot).getLimit() <= this.cargoItems.get(slot).getCount()) continue;
                        ItemStack extracted = tender.cargoItems.extract(tenderSlot, 1, false);
                        this.cargoItems.insert(slot, extracted, false);
                    }
                }
            }
            if ((coupler = tender.getCouplerFor(stock)) == null) break;
            coupler = coupler.opposite();
            stock = tender;
        }
        float boilerTemperature = this.getBoilerTemperature();
        float boilerPressure = this.getBoilerPressure();
        float waterLevelMB = this.getLiquidAmount();
        int burningSlots = 0;
        float waterUsed = 0.0f;
        if (boilerPressure < 0.0f) {
            boilerPressure = 0.0f;
        }
        if (this.getLiquidAmount() > 0) {
            for (int slot = 2; slot < this.cargoItems.getSlotCount(); ++slot) {
                int remainingTime = this.burnTime.getOrDefault(slot, 0);
                if (remainingTime <= 0) {
                    ItemStack stack = this.cargoItems.get(slot);
                    if (stack.getCount() <= 0 || BurnUtil.getBurnTime(stack) == 0) continue;
                    remainingTime = (int)((double)BurnUtil.getBurnTime(stack) / this.gauge.scale() * ((double)Config.ConfigBalance.locoSteamFuelEfficiency / 100.0));
                    this.burnTime.put(slot, remainingTime);
                    this.burnMax.put(slot, remainingTime);
                    stack.setCount(stack.getCount() - 1);
                    this.cargoItems.set(slot, stack);
                } else {
                    this.burnTime.put(slot, remainingTime - 1);
                }
                ++burningSlots;
            }
        }
        double energyKCalDeltaTick = 0.0;
        if (burningSlots != 0 && this.getLiquidAmount() > 0) {
            energyKCalDeltaTick += (double)burningSlots * this.coalEnergyKCalTick();
        }
        double boilerVolume = this.getTankCapacity().Buckets();
        double boilerEdgeM = Math.pow(boilerVolume, 0.3333333333333333);
        double boilerAreaM = 6.0 * Math.pow(boilerEdgeM, 2.0);
        if (boilerTemperature > 0.0f) {
            double radiatedKwHr = Math.pow(boilerTemperature / 10.0f, 2.0) / 100.0 * boilerAreaM * 2.0;
            double radiatedKCalHr = radiatedKwHr * 859.85;
            double radiatedKCalTick = radiatedKCalHr / 60.0 / 60.0 / 20.0 * (double)Config.ConfigBalance.locoHeatTimeScale;
            energyKCalDeltaTick -= radiatedKCalTick / 1000.0;
        }
        if (energyKCalDeltaTick != 0.0) {
            boilerTemperature = (float)((double)boilerTemperature + energyKCalDeltaTick / (double)((waterLevelMB + 1.0f) / 1000.0f));
        }
        if (boilerTemperature > 100.0f) {
            int maxPSI;
            float heatTransfer = boilerTemperature - 100.0f;
            boilerPressure += heatTransfer;
            if (this.getPercentLiquidFull() > 25) {
                boilerTemperature -= heatTransfer;
            }
            boolean bl = this.pressureValve = boilerPressure > (float)(maxPSI = this.getDefinition().getMaxPSI(this.gauge));
            if (boilerPressure > (float)maxPSI) {
                waterUsed += boilerPressure - (float)maxPSI;
                boilerPressure = maxPSI;
            }
        } else {
            if (boilerPressure > 0.0f) {
                boilerPressure = Math.max(0.0f, boilerPressure - (100.0f - boilerTemperature));
                boilerTemperature = 100.0f;
            }
            this.pressureValve = false;
        }
        float throttle = this.getThrottle() * Math.abs(this.getReverser());
        if (throttle != 0.0f && boilerPressure > 0.0f) {
            double burnableSlots = this.cargoItems.getSlotCount() - 2;
            double maxKCalTick = burnableSlots * this.coalEnergyKCalTick();
            double maxPressureTick = maxKCalTick / (double)(this.getTankCapacity().MilliBuckets() / 1000);
            float delta = (float)((double)throttle * (maxPressureTick *= 0.8));
            boilerPressure = Math.max(0.0f, boilerPressure - delta);
            waterUsed += delta;
        }
        if (waterUsed != 0.0f) {
            waterUsed *= Config.ConfigBalance.locoWaterUsage;
            if ((waterUsed += this.drainRemainder) > 0.0f && this.theTank.getContents() != null) {
                this.theTank.drain(new FluidStack(this.theTank.getContents().getFluid(), (int)Math.floor(waterUsed)), false);
                this.drainRemainder = waterUsed % 1.0f;
            }
        }
        this.setBoilerPressure(boilerPressure);
        this.setBoilerTemperature(Math.max(boilerTemperature, this.ambientTemperature()));
        if ((double)boilerPressure > (double)this.getDefinition().getMaxPSI(this.gauge) * 1.1 || (double)boilerPressure > (double)this.getDefinition().getMaxPSI(this.gauge) * 0.5 && boilerTemperature > 150.0f) {
            Vec3d pos = this.getPosition();
            if (Config.ConfigDamage.explosionsEnabled) {
                this.createExplosion(pos, boilerPressure / 5.0f, Config.ConfigDamage.explosionEnvDamageEnabled);
            }
            this.getWorld().removeEntity((Entity)this);
        }
    }

    @Override
    public boolean providesElectricalPower() {
        return this.getBoilerPressure() > 0.0f || !Config.ConfigBalance.FuelRequired;
    }

    @Override
    public void onDrag(Control<?> component, double newValue) {
        super.onDrag(component, newValue);
        if (component.part.type == ModelComponentType.WHISTLE_CONTROL_X) {
            this.setHorn(10, null);
        }
    }

    @Override
    public void onDragRelease(Control<?> component) {
        super.onDragRelease(component);
        if (component.part.type == ModelComponentType.WHISTLE_CONTROL_X) {
            this.setControlPosition(component, 0.0f);
        }
    }

    @Override
    protected void initContainerFilter() {
        this.cargoItems.filter.clear();
        this.cargoItems.filter.put(0, SlotFilter.FLUID_CONTAINER);
        this.cargoItems.filter.put(1, SlotFilter.FLUID_CONTAINER);
        this.cargoItems.defaultFilter = SlotFilter.BURNABLE;
    }

    @Override
    public int getInventorySize() {
        return this.getDefinition().getInventorySize(this.gauge) + 2;
    }

    @Override
    public int getInventoryWidth() {
        return this.getDefinition().getInventoryWidth(this.gauge);
    }

    @Override
    protected int[] getContainerInputSlots() {
        return new int[]{0};
    }

    @Override
    protected int[] getContainertOutputSlots() {
        return new int[]{1};
    }

    @Override
    public FluidQuantity getTankCapacity() {
        return this.getDefinition().getTankCapacity(this.gauge);
    }

    @Override
    public List<Fluid> getFluidFilter() {
        return LiquidUtil.getWater();
    }

    public boolean isOverpressure() {
        return this.pressureValve;
    }

    private double coalEnergyKCalTick() {
        double coalEnergyDensity = 30000.0;
        double coalEnergyKJ = coalEnergyDensity / 9.0;
        double coalEnergyBTU = coalEnergyKJ * 0.958;
        double coalEnergyKCal = coalEnergyBTU / 3968.0;
        double coalBurnTicks = 1600.0;
        return coalEnergyKCal / coalBurnTicks * (double)Config.ConfigBalance.locoHeatTimeScale;
    }

    public boolean cylinderDrainsEnabled() {
        List drains = this.getDefinition().getModel().getControls().stream().filter(x -> x.part.type == ModelComponentType.CYLINDER_DRAIN_CONTROL_X).collect(Collectors.toList());
        if (drains.isEmpty()) {
            double csm = Math.abs(this.getCurrentSpeed().metric()) / this.gauge.scale();
            return csm < 20.0;
        }
        return drains.stream().anyMatch(c -> this.getControlPosition((Control<?>)c) == 1.0f);
    }

    public void setCylinderDrains(boolean enabled) {
        List drains = this.getDefinition().getModel().getControls().stream().filter(x -> x.part.type == ModelComponentType.CYLINDER_DRAIN_CONTROL_X).collect(Collectors.toList());
        for (Control drain : drains) {
            this.setControlPosition(drain, enabled ? 1.0f : 0.0f);
        }
    }

    private static class SlotTagMapper
    implements TagMapper<Map<Integer, Integer>> {
        private SlotTagMapper() {
        }

        public TagMapper.TagAccessor<Map<Integer, Integer>> apply(Class<Map<Integer, Integer>> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor((d, o) -> d.setMap(fieldName, o, Objects::toString, i -> new TagCompound().setInteger("val", i)), d -> d.getMap(fieldName, Integer::parseInt, t -> {
                Integer val = t.getInteger("val");
                if (val == null) {
                    val = 0;
                }
                return val;
            }));
        }
    }
}

