/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading;

import cam72cam.immersiverailroading.library.PressureDisplayType;
import cam72cam.immersiverailroading.library.SpeedDisplayType;
import cam72cam.immersiverailroading.library.TemperatureDisplayType;
import cam72cam.mod.config.ConfigFile;
import cam72cam.mod.render.OptiFine;
import java.util.HashMap;
import java.util.Map;

@ConfigFile.Comment(value="Configuration File")
@ConfigFile.Name(value="general")
@ConfigFile.File(value="immersiverailroading_graphics.cfg")
public class ConfigGraphics {
    @ConfigFile.Comment(value="Enable Particles")
    public static boolean particlesEnabled = true;
    @ConfigFile.Comment(value="Self explanatory")
    public static boolean trainsOnTheBrain = true;
    @ConfigFile.Comment(value="What unit to use for speedometer. (kmh, mph or ms)")
    public static SpeedDisplayType speedUnit = SpeedDisplayType.kmh;
    @ConfigFile.Comment(value="What units to display pressure in (psi, bar)")
    public static PressureDisplayType pressureUnit = PressureDisplayType.psi;
    @ConfigFile.Comment(value="What units to display pressure in (psi, bar)")
    public static TemperatureDisplayType temperatureUnit = TemperatureDisplayType.celcius;
    @ConfigFile.Comment(value="How long to keep textures in memory after they have left the screen (higher numbers = smoother game play, lower numbers = less GPU memory used)")
    @ConfigFile.Range(min=0.0, max=100.0)
    public static int textureCacheSeconds = 30;
    @ConfigFile.Comment(value="Show text tooltips over interactable components")
    public static boolean interactiveComponentsOverlay = true;
    @ConfigFile.Comment(value="Show stock variants in JEI/NEI/Creative search")
    public static boolean stockItemVariants = false;
    @ConfigFile.Comment(value="Override OptiFine Shaders for entities")
    public static OptiFine.Shaders OptiFineEntityShader = OptiFine.Shaders.Entities;
    @ConfigFile.Comment(value="Override Optifine Shader for all entities (not just ones that have specular/normal maps)")
    public static boolean OptifineEntityShaderOverrideAll = false;
    @ConfigFile.Comment(value="How far away stock needs to be to switch to a smaller LOD texture")
    @ConfigFile.Range(min=0.0, max=500.0)
    public static double StockLODDistance = 64.0;
    @ConfigFile.Comment(value="0.0 is no sway, 1.0 is default sway")
    @ConfigFile.Range(min=0.0, max=1.0)
    public static double StockSwayMultiplier = 1.0;
    @ConfigFile.Comment(value="How likely a piece of stock is to sway (1 == always, 10 == infrequent)")
    @ConfigFile.Range(min=1.0, max=10.0)
    public static int StockSwayChance = 1;
    @ConfigFile.Comment(value="Settings used in the stock user interfaces")
    public static Map<String, Float> settings = new HashMap<String, Float>();
    @ConfigFile.Comment(value="Mouse Scroll Speed (negative values invert it)")
    @ConfigFile.Range(min=-10.0, max=10.0)
    public static float ScrollSpeed = 1.0f;
    @ConfigFile.Comment(value="Try to fake interior lighting for locomotives/passenger cars that are being ridden")
    public static boolean FakeInteriorLighting = true;
}

