/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.api.temperature;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import toughasnails.api.TANCapabilities;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.ITemperatureModifier;
import toughasnails.api.temperature.ITemperatureRegulator;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureScale;

public class TemperatureHelper {
    private static Map<String, ITemperatureModifier> modifiers = Maps.newHashMap();
    private static final IModifierMonitor DUMMY_MONITOR = new IModifierMonitor(){

        @Override
        public void addEntry(IModifierMonitor.Context context) {
        }

        @Override
        public void setTargetTemperature(Temperature temperature) {
        }
    };

    public static boolean registerTemperatureModifier(ITemperatureModifier modifier) {
        if (modifier.getId() == null || modifiers.containsKey(modifier.getId())) {
            return false;
        }
        modifiers.put(modifier.getId(), modifier);
        return true;
    }

    public static ImmutableMap<String, ITemperatureModifier> getTemperatureModifiers() {
        return ImmutableMap.copyOf(modifiers);
    }

    public static ITemperature getTemperatureData(EntityPlayer player) {
        return (ITemperature)player.getCapability(TANCapabilities.TEMPERATURE, null);
    }

    public static Temperature getTargetAtPos(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IModifierMonitor monitor) {
        return new Temperature(MathHelper.func_76125_a((int)TemperatureHelper.getTargetAtPosUnclamped(world, pos, monitor).getRawValue(), (int)0, (int)TemperatureScale.getScaleTotal()));
    }

    public static Temperature getTargetAtPosUnclamped(@Nonnull World world, @Nonnull BlockPos pos, @Nullable IModifierMonitor monitor) {
        if (monitor == null) {
            monitor = DUMMY_MONITOR;
        }
        int targetTemperature = TemperatureScale.getScaleMidpoint();
        monitor.addEntry(new IModifierMonitor.Context("equilibrium", "Equilibrium", new Temperature(0), new Temperature(TemperatureScale.getScaleMidpoint())));
        for (ITemperatureModifier modifier : TemperatureHelper.getTemperatureModifiers().values()) {
            if (modifier.isPlayerSpecific()) continue;
            targetTemperature = modifier.applyEnvironmentModifiers(world, pos, new Temperature(targetTemperature), monitor).getRawValue();
        }
        monitor.setTargetTemperature(new Temperature(targetTemperature));
        return new Temperature(targetTemperature);
    }

    public static List<ITemperatureRegulator> getTemperatureRegulators(World world) {
        ArrayList list = Lists.newArrayList();
        for (TileEntity tileEntity : world.field_175730_i) {
            if (!(tileEntity instanceof ITemperatureRegulator)) continue;
            list.add((ITemperatureRegulator)tileEntity);
        }
        return list;
    }

    public static boolean isPosClimatisedForTemp(World world, BlockPos pos, Temperature temperature) {
        for (ITemperatureRegulator regulator : TemperatureHelper.getTemperatureRegulators(world)) {
            if (regulator.getRegulatedTemperature().getRawValue() < temperature.getRawValue() || !regulator.isPosRegulated(pos)) continue;
            return true;
        }
        return false;
    }
}

