/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.jei;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.FRBlocks;
import com.silvaniastudios.roads.jei.FabricatorWrapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FabricatorCategory
implements IRecipeCategory<FabricatorWrapper> {
    private final IDrawable background;
    private final IDrawable electric_bar;
    private final IDrawable icon;
    private final IDrawableAnimated progressBar;
    public static final int width = 162;
    public static final int height = 62;
    private boolean electric = false;
    private String uid;

    public FabricatorCategory(IGuiHelper guiHelper, String uid, boolean electric) {
        ResourceLocation guiTexture = new ResourceLocation("furenikusroads:textures/gui/jei_texture_3.png");
        this.background = guiHelper.createDrawable(guiTexture, 0, 0, 162, 62);
        this.electric_bar = guiHelper.createDrawable(guiTexture, 164, 0, 18, 62);
        this.icon = electric ? guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.fabricator_electric)) : guiHelper.createDrawableIngredient((Object)new ItemStack((Block)FRBlocks.fabricator));
        int progressTick = electric ? RoadsConfig.machine.electricFabricatorTickRate : RoadsConfig.machine.fabricatorTickRate;
        this.progressBar = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(guiTexture, 0, 252, 160, 4), progressTick, IDrawableAnimated.StartDirection.LEFT, false);
        this.electric = electric;
        this.uid = uid;
    }

    public String getUid() {
        return this.uid;
    }

    public String getTitle() {
        if (this.electric) {
            return I18n.func_135052_a((String)"roads.gui.electric_fabricator.name", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"roads.gui.fabricator.name", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Fureniku's Roads";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.electric) {
            this.electric_bar.draw(minecraft, 144, 0);
        }
        this.progressBar.draw(minecraft, 1, 57);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, FabricatorWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiStack = recipeLayout.getItemStacks();
        guiStack.init(0, true, 0, 16);
        guiStack.init(1, true, 18, 16);
        guiStack.init(2, true, 36, 16);
        guiStack.init(3, true, 0, 34);
        guiStack.init(4, true, 18, 34);
        guiStack.init(5, true, 36, 34);
        guiStack.init(6, false, 122, 25);
        guiStack.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        guiStack.set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
        guiStack.set(2, (List)ingredients.getInputs(VanillaTypes.ITEM).get(2));
        guiStack.set(3, (List)ingredients.getInputs(VanillaTypes.ITEM).get(3));
        guiStack.set(4, (List)ingredients.getInputs(VanillaTypes.ITEM).get(4));
        guiStack.set(5, (List)ingredients.getInputs(VanillaTypes.ITEM).get(5));
        guiStack.set(6, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }
}

