/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.roadfactory;

import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.items.ItemStackHandler;

public class RoadFactoryStackHandler
extends ItemStackHandler {
    private final ItemStackHandler internalStackHandler;
    boolean electric;
    public int[] inputSlots = new int[]{0, 1, 2, 3};
    public int[] outputSlots = new int[]{4, 5, 6, 7, 10};
    private int fuelSlot = 8;

    public RoadFactoryStackHandler(ItemStackHandler ish, boolean electric) {
        this.electric = electric;
        this.internalStackHandler = ish;
    }

    public void setSize(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.internalStackHandler.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.internalStackHandler.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.internalStackHandler.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot == this.fuelSlot && TileEntityFurnace.func_145952_a((ItemStack)stack) > 0 && !this.electric) {
            return this.internalStackHandler.insertItem(slot, stack, simulate);
        }
        if (slot == 9 && stack.func_77973_b() instanceof UniversalBucket) {
            return this.internalStackHandler.insertItem(slot, stack, simulate);
        }
        for (int i = 0; i < this.inputSlots.length; ++i) {
            if (this.inputSlots[i] != slot || !(stack.func_77973_b() instanceof ItemBlock)) continue;
            return this.internalStackHandler.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        for (int i = 0; i < this.outputSlots.length; ++i) {
            if (this.outputSlots[i] != slot) continue;
            return this.internalStackHandler.extractItem(slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }
}

