/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.mission;

import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.util.HashedBlockPosition;

public abstract class MissionResourceCollection
extends SatelliteBase
implements IMission {
    long startWorldTime;
    double x;
    double y;
    double z;
    long duration;
    int launchDimension;
    StorageChunk rocketStorage;
    StatsRocket rocketStats;
    int worldId;
    NBTTagCompound missionPersistantNBT;
    protected LinkedList<HashedBlockPosition> infrastructureCoords;

    public MissionResourceCollection() {
        this.infrastructureCoords = new LinkedList();
    }

    public MissionResourceCollection(long duration, EntityRocket entity, LinkedList<IInfrastructure> infrastructureCoords) {
        this.missionPersistantNBT = new NBTTagCompound();
        entity.writeMissionPersistentNBT(this.missionPersistantNBT);
        this.satelliteProperties.setId(DimensionManager.getInstance().getNextSatelliteId());
        this.startWorldTime = net.minecraftforge.common.DimensionManager.getWorld((int)0).func_82737_E();
        this.duration = duration;
        this.launchDimension = entity.field_70170_p.field_73011_w.getDimension();
        this.rocketStorage = entity.storage;
        this.rocketStats = entity.stats;
        this.x = entity.field_70165_t;
        this.y = entity.field_70163_u;
        this.z = entity.field_70161_v;
        this.worldId = entity.field_70170_p.field_73011_w.getDimension();
        this.infrastructureCoords = new LinkedList();
        for (IInfrastructure tile : infrastructureCoords) {
            this.infrastructureCoords.add(new HashedBlockPosition(((TileEntity)tile).func_174877_v()));
        }
    }

    @Override
    public double getProgress(World world) {
        return Math.max((double)(AdvancedRocketry.proxy.getWorldTimeUniversal(0) - this.startWorldTime) / (double)this.duration, 0.0);
    }

    @Override
    public int getTimeRemainingInSeconds() {
        return (int)Math.max((this.duration - AdvancedRocketry.proxy.getWorldTimeUniversal(0) + this.startWorldTime) / 20L, 0L);
    }

    @Override
    public String getInfo(World world) {
        return null;
    }

    @Override
    public String getName() {
        return LibVulpes.proxy.getLocalizedString("mission.asteroidmining.name");
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, BlockPos pos) {
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    @Override
    public boolean canTick() {
        return true;
    }

    @Override
    public abstract void onMissionComplete();

    @Override
    public void tickEntity() {
        if (this.getProgress((World)net.minecraftforge.common.DimensionManager.getWorld((int)this.getDimensionId())) >= 1.0 && !net.minecraftforge.common.DimensionManager.getWorld((int)0).field_72995_K) {
            this.setDead();
            this.onMissionComplete();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74782_a("persist", (NBTBase)this.missionPersistantNBT);
        NBTTagCompound nbt2 = new NBTTagCompound();
        this.rocketStats.writeToNBT(nbt2);
        nbt.func_74782_a("rocketStats", (NBTBase)nbt2);
        nbt2 = new NBTTagCompound();
        this.rocketStorage.writeToNBT(nbt2);
        nbt.func_74782_a("rocketStorage", (NBTBase)nbt2);
        nbt.func_74780_a("launchPosX", this.x);
        nbt.func_74780_a("launchPosY", this.y);
        nbt.func_74780_a("launchPosZ", this.z);
        nbt.func_74772_a("startWorldTime", this.startWorldTime);
        nbt.func_74772_a("duration", this.duration);
        nbt.func_74768_a("startDimid", this.worldId);
        nbt.func_74768_a("launchDim", this.launchDimension);
        NBTTagList itemList = new NBTTagList();
        for (HashedBlockPosition inf : this.infrastructureCoords) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74783_a("loc", new int[]{inf.x, inf.y, inf.z});
            itemList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("infrastructure", (NBTBase)itemList);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.missionPersistantNBT = nbt.func_74775_l("persist");
        this.rocketStats = new StatsRocket();
        this.rocketStats.readFromNBT(nbt.func_74775_l("rocketStats"));
        this.rocketStorage = new StorageChunk();
        this.rocketStorage.readFromNBT(nbt.func_74775_l("rocketStorage"));
        this.x = nbt.func_74769_h("launchPosX");
        this.y = nbt.func_74769_h("launchPosY");
        this.z = nbt.func_74769_h("launchPosZ");
        this.startWorldTime = nbt.func_74763_f("startWorldTime");
        this.duration = nbt.func_74763_f("duration");
        this.worldId = nbt.func_74762_e("startDimid");
        this.launchDimension = nbt.func_74762_e("launchDim");
        NBTTagList tagList = nbt.func_150295_c("infrastructure", 10);
        this.infrastructureCoords.clear();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            int[] coords = tagList.func_150305_b(i).func_74759_k("loc");
            this.infrastructureCoords.add(new HashedBlockPosition(coords[0], coords[1], coords[2]));
        }
    }

    @Override
    public long getMissionId() {
        return this.getId();
    }

    @Override
    public int getOriginatingDimension() {
        return this.worldId;
    }

    @Override
    public void unlinkInfrastructure(IInfrastructure tile) {
        HashedBlockPosition pos = new HashedBlockPosition(((TileEntity)tile).func_174877_v());
        this.infrastructureCoords.remove(pos);
    }
}

