/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.entities;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.entities.BlockStateCarrier;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityPollutant
extends BlockStateCarrier {
    protected final GameTime stuckUpdateInterval = GameTime.seconds((int)3);
    protected static final DataParameter<Boolean> STUCK = EntityDataManager.func_187226_a(EntityPollutant.class, (DataSerializer)DataSerializers.field_187198_h);
    static final long maxExistence = GameTime.inServerTicks((CommonTime.Interval)CommonTime.Interval.minutes((double)10.0));

    public EntityPollutant(World world, BlockPos pos, IBlockState carriedState) {
        super(world, pos, carriedState);
        if (world instanceof WorldServer) {
            ((WorldServer)world).func_82742_i();
        }
    }

    public EntityPollutant(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(STUCK, (Object)false);
    }

    public boolean isStuck() {
        return (Boolean)this.func_184212_Q().func_187225_a(STUCK);
    }

    public void setStuck(boolean value) {
        boolean old;
        if (this.isServerSide() && this.func_70089_S() && value != (old = this.isStuck())) {
            SpawnLimiter limiter = WorldData.getData(this.field_70170_p).getPollutantEntityLimiter();
            if (value) {
                limiter.onEntityRemoved((Entity)this);
            } else {
                limiter.onEntityAdded((Entity)this);
            }
        }
        this.func_184212_Q().func_187227_b(STUCK, (Object)value);
    }

    @Nullable
    public Pollutant<?> getPollutant() {
        Block block;
        IBlockState state = this.getCarriedBlockState();
        if (state != null && (block = state.func_177230_c()) instanceof Pollutant) {
            return (Pollutant)state.func_177230_c();
        }
        return null;
    }

    public boolean func_70067_L() {
        return false;
    }

    public int getPollutionAmount() {
        Pollutant<?> pollutant = this.getPollutant();
        IBlockState state = this.getCarriedBlockState();
        if (pollutant != null && state != null) {
            return pollutant.getCarriedPollutionAmount(state);
        }
        return 0;
    }

    public int getPollutionCapacity() {
        Pollutant<?> pollutant = this.getPollutant();
        if (pollutant != null) {
            return pollutant.getPollutionCapacity();
        }
        return 0;
    }

    public boolean carriesSamePollutant(Pollutant<?> pollutant) {
        return this.getPollutant() == pollutant;
    }

    public boolean pump() {
        IBlockState state;
        Pollutant<?> pollutant;
        if (this.isServerSide() && this.func_70089_S() && (pollutant = this.getPollutant()).canStateBePumped(state = this.getCarriedBlockState())) {
            this.setCarriedBlockState(pollutant.getPumpedState(state));
            return true;
        }
        return false;
    }

    public boolean spend() {
        IBlockState state;
        Pollutant<?> pollutant;
        if (this.isServerSide() && this.func_70089_S() && (pollutant = this.getPollutant()).canStateBeSpreaded(state = this.getCarriedBlockState())) {
            this.setCarriedBlockState(pollutant.getSpreadedState(state));
            return true;
        }
        return false;
    }

    protected boolean spreadTo(EntityPollutant targetEntity, int minPollutionDelta) {
        if (targetEntity.func_70089_S() && targetEntity.carriesSamePollutant(this.getPollutant())) {
            int pollutionDelta = Math.abs(this.getPollutionAmount() - targetEntity.getPollutionAmount());
            return pollutionDelta >= minPollutionDelta && targetEntity.pump();
        }
        return false;
    }

    protected void setCarriedBlockState(@Nullable IBlockState newState) {
        super.setCarriedBlockState(newState);
        if (newState != null && ForgeWorld.isAirBlock((IBlockState)newState)) {
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        this.field_70170_p.field_72984_F.func_76320_a("entityPollutant.update");
        super.func_70071_h_();
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    public void func_70030_z() {
        BlockPos pos;
        Spread spread;
        boolean alignedToBlock;
        IBlockState newState;
        if (!this.func_70089_S()) {
            return;
        }
        boolean isStuck = this.isStuck();
        if (this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_82742_i();
        }
        if (isStuck && this.isServerSide() && !this.stuckUpdateInterval.pastIn(this.field_70170_p)) {
            return;
        }
        if (isStuck && this.isClientSide()) {
            return;
        }
        if (isStuck && this.isServerSide() && (long)this.field_70173_aa > maxExistence && !ForgeWorld.SmokeContainers.isChimney((World)this.field_70170_p, (BlockPos)this.func_180425_c())) {
            this.func_70106_y();
            return;
        }
        IBlockState carriedState = this.getCarriedBlockState();
        Pollutant<?> pollutant = this.getPollutant();
        if (carriedState == null || pollutant == null || pollutant == Blocks.field_150350_a || pollutant.getCarriedPollutionAmount(carriedState) <= 0 || !pollutant.getAltitudeBounds().encloses(Integer.valueOf(this.func_180425_c().func_177956_o()))) {
            if (this.isServerSide()) {
                this.func_70106_y();
            }
            return;
        }
        if (this.isServerSide() && (newState = pollutant.affectBlockAt(this.field_70170_p, this.func_180425_c(), Optional.empty(), true, carriedState)) != carriedState) {
            this.setCarriedBlockState(newState);
            return;
        }
        Optional<EnumFacing> motionFacing = pollutant.getMotionFacing(this.field_70170_p, this.func_180425_c());
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        if (motionFacing.isPresent()) {
            float velocity = pollutant.getMotionVelocityIn(this.field_70170_p.func_180494_b(this.func_180425_c()));
            this.field_70181_x = motionFacing.get() != EnumFacing.DOWN ? (double)velocity : (double)(-velocity);
        } else {
            this.field_70181_x = 0.0;
        }
        AxisAlignedBB nextBB = this.getBB(this.getNextPosition());
        BlockPos movePos = new BlockPos(this.field_70165_t, this.field_70181_x < 0.0 ? nextBB.field_72338_b : nextBB.field_72337_e, this.field_70161_v);
        boolean canPassThrough = motionFacing.isPresent() && pollutant.canPassThrough(this.field_70170_p, movePos, motionFacing.get().func_176734_d(), motionFacing.get());
        boolean entityCollided = false;
        if (canPassThrough) {
            this.setStuck(false);
            boolean blockSize = true;
            double motionSign = Math.signum(this.field_70181_x);
            List collidedEntities = this.getCollidedEntitiesIfMove(this.getMotion());
            for (Entity entity : collidedEntities) {
                if (!(entity instanceof EntityPollutant)) continue;
                if (this.isServerSide() && this.spreadTo((EntityPollutant)entity, 0) && this.spend()) {
                    return;
                }
                if (this.isServerSide() && this.field_70181_x > entity.field_70181_x) {
                    this.swapPositionWith(entity);
                    return;
                }
                double alignedY = entity.field_70163_u - motionSign * 1.0;
                this.field_70167_r = this.field_70163_u;
                this.func_70107_b(this.field_70165_t, alignedY, this.field_70161_v);
                canPassThrough = false;
                entityCollided = true;
                this.field_70122_E = true;
                break;
            }
        }
        if (canPassThrough) {
            this.field_70122_E = false;
            this.move();
            return;
        }
        this.field_70122_E = true;
        long alignedY = Math.round(this.field_70163_u);
        if (!entityCollided) {
            this.func_70107_b(this.field_70165_t, alignedY, this.field_70161_v);
        }
        boolean bl = alignedToBlock = this.field_70163_u == (double)alignedY;
        if (alignedToBlock) {
            this.setStuck(true);
        }
        if (this.isServerSide() && alignedToBlock && (spread = pollutant.createSpread(this.field_70170_p, pos = this.func_180425_c(), carriedState).to(pos, Integer.MIN_VALUE).overLedge().around(Integer.MIN_VALUE)).completed()) {
            spread.applyTarget();
            this.setCarriedBlockState(spread.getSourceState());
            return;
        }
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public static class SpawnLimiter {
        public static int maxTotalAmount = 50;
        private Set<Entity> entities = new HashSet<Entity>();
        private long lastSpawn = 0L;

        public boolean canSpawnAt(World world, BlockPos pos) {
            long time = world.func_82737_E();
            return time != this.lastSpawn && this.getTotalAmount() < maxTotalAmount;
        }

        public boolean validEntity(Entity entity) {
            return entity instanceof EntityPollutant;
        }

        public void onEntityAdded(Entity entity) {
            if (this.validEntity(entity)) {
                this.entities.add(entity);
                this.lastSpawn = entity.field_70170_p.func_82737_E();
            }
        }

        public void onEntityRemoved(Entity entity) {
            if (this.validEntity(entity)) {
                this.entities.remove(entity);
            }
        }

        public int getTotalAmount() {
            return this.entities.size();
        }
    }
}

