/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.config.AbstractParsableBlackWhiteList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntityBlackWhiteList
extends AbstractParsableBlackWhiteList<Class<? extends Entity>> {
    public EntityBlackWhiteList(UnitConfig config, String category, String key) {
        super(config, category, key);
    }

    @Override
    protected String getComment() {
        return "";
    }

    @Override
    public boolean isAllowed(Entity entity) {
        return this.isAllowed(entity.getClass());
    }

    @Override
    protected List<Class<? extends Entity>> parse(List<String> configValues) {
        ArrayList<Class<? extends Entity>> entities = new ArrayList<Class<? extends Entity>>();
        for (String string : configValues) {
            UnitId id = UnitId.from((String)string);
            boolean error = id.isEmpty();
            if (!error) {
                EntityEntry entry;
                if (!Loader.isModLoaded((String)id.getModId()) || (entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(id.toResLoc())) == null) continue;
                entities.add(entry.getEntityClass());
                continue;
            }
            this.logParsingError(string);
        }
        return entities;
    }
}

