/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.DynamicWidget;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;

public class ExtendedButtonControl
extends GuiButton
implements DynamicWidget {
    private String[] optionalArgs;
    private Runnable onPushEvent = null;
    private Runnable onHoverEvent = null;
    private FontRenderer currentFontRender = null;
    private boolean isOverScreen = false;

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(buttonId, x, y, widthIn, heightIn, buttonText);
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(ExtendedScreen.getNextIndex(), x, y, widthIn, heightIn, buttonText);
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int id, int xPos, int yPos, String displayString) {
        super(id, xPos, yPos, displayString);
    }

    public ExtendedButtonControl(int xPos, int yPos, String displayString) {
        this(ExtendedScreen.getNextIndex(), xPos, yPos, displayString);
    }

    @Override
    public void draw(ExtendedScreen screen) {
        this.isOverScreen = RenderUtils.isMouseOver(screen);
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
        if (this.isOverScreen() && this.isHoveringOver()) {
            this.onHover();
        }
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        this.setCurrentFontRender(mc.field_71466_p);
        if (this.isControlVisible()) {
            this.setHoveringOver(this.isOverScreen() && RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this));
            this.func_146119_b(mc, mouseX, mouseY);
            int color = !this.isControlEnabled() ? 0xA0A0A0 : (this.isHoveringOrFocusingOver() ? 0xFFFFA0 : 0xE0E0E0);
            RenderUtils.renderScrollingString(mc, this.getFontRenderer(), this.getDisplayMessage(), this.getLeft() + 2, this.getTop(), this.getRight() - 2, this.getBottom(), color);
        }
    }

    protected void func_146119_b(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.isControlVisible()) {
            int hoverState = this.func_146114_a(this.isHoveringOrFocusingOver());
            int hoverValue = 46 + hoverState * 20;
            double xOffset = (double)this.getControlWidth() / 2.0;
            RenderUtils.renderButton(mc, this.getControlPosX(), this.getControlPosY(), 0.0, hoverValue, 200.0 - xOffset, hoverValue, xOffset, this.getControlHeight(), this.getZLevel(), RenderUtils.getButtonTextures());
        }
    }

    public boolean func_146116_c(@Nonnull Minecraft arg, int mouseX, int mouseY) {
        return this.isOverScreen() && this.isControlEnabled() && this.isControlVisible() && this.isHoveringOver();
    }

    @Override
    public int getControlWidth() {
        return this.field_146120_f;
    }

    @Override
    public void setControlWidth(int width) {
        this.field_146120_f = width;
    }

    @Override
    public int getControlHeight() {
        return this.field_146121_g;
    }

    @Override
    public void setControlHeight(int height) {
        this.field_146121_g = height;
    }

    @Override
    public int getControlPosX() {
        return this.field_146128_h;
    }

    @Override
    public void setControlPosX(int posX) {
        this.field_146128_h = posX;
    }

    @Override
    public int getControlPosY() {
        return this.field_146129_i;
    }

    @Override
    public void setControlPosY(int posY) {
        this.field_146129_i = posY;
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public FontRenderer getFontRenderer() {
        return this.currentFontRender != null ? this.currentFontRender : GuiUtils.getDefaultFontRenderer();
    }

    public void setCurrentFontRender(FontRenderer currentFontRender) {
        this.currentFontRender = currentFontRender;
    }

    public int getFontHeight() {
        return RenderUtils.getFontHeight(this.getFontRenderer());
    }

    public String[] getOptionalArgs() {
        return (String[])this.optionalArgs.clone();
    }

    public void setOnClick(Runnable event) {
        this.onPushEvent = event;
    }

    public void onClick() {
        if (this.onPushEvent != null) {
            this.onPushEvent.run();
        }
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    public String getDisplayMessage() {
        return Constants.TRANSLATOR.getLocalizedMessage(this.getControlMessage());
    }

    public String getControlMessage() {
        return this.field_146126_j;
    }

    public void setControlMessage(String newMessage) {
        this.field_146126_j = newMessage;
    }

    public boolean isControlEnabled() {
        return this.field_146124_l;
    }

    public void setControlEnabled(boolean isEnabled) {
        this.field_146124_l = isEnabled;
    }

    public boolean isControlVisible() {
        return this.field_146125_m;
    }

    public void setControlVisible(boolean isVisible) {
        this.field_146125_m = isVisible;
    }

    public boolean isHoveringOver() {
        return this.field_146123_n;
    }

    public void setHoveringOver(boolean isHovered) {
        this.field_146123_n = isHovered;
    }

    public boolean isFocusedOver() {
        return false;
    }

    public void setFocusedOver(boolean isFocused) {
    }

    public boolean isHoveringOrFocusingOver() {
        return this.isHoveringOver() || this.isFocusedOver();
    }

    public double getZLevel() {
        return this.field_73735_i;
    }

    public void setZLevel(double zLevel) {
        this.field_73735_i = (float)zLevel;
    }
}

