/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import minecrafttransportsimulator.baseclasses.AnimationSwitchbox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.items.instances.ItemInstrument;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.rendering.DurationDelayClock;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.rendering.RenderableObject;
import minecrafttransportsimulator.systems.ConfigSystem;

public final class RenderInstrument {
    private static int partNumber = 0;
    private static RenderableObject renderObject = null;
    private static final TransformationMatrix textTransform = new TransformationMatrix();
    private static final Point3D bottomLeft = new Point3D();
    private static final Point3D topLeft = new Point3D();
    private static final Point3D topRight = new Point3D();
    private static final Point3D bottomRight = new Point3D();
    private static final RotationMatrix helperRotation = new RotationMatrix();
    private static final RotationMatrix helperRotationMatrix = new RotationMatrix();
    private static final float[][] instrumentSingleComponentPoints = new float[6][8];

    public static void drawInstrument(AEntityE_Interactable<?> entity, TransformationMatrix transform, int slot, boolean onGUI, boolean blendingEnabled, float partialTicks) {
        ItemInstrument instrument = entity.instruments.get(slot);
        JSONInstrumentDefinition slotDefinition = ((AJSONInteractableEntity)entity.definition).instruments.get(slot);
        boolean lightsOn = entity.renderTextLit();
        float slotScale = onGUI ? slotDefinition.hudScale : slotDefinition.scale;
        partNumber = slotDefinition.optionalPartNumber;
        for (int i = 0; i < ((JSONInstrument)instrument.definition).components.size(); ++i) {
            JSONInstrument.JSONInstrumentComponent component = ((JSONInstrument)instrument.definition).components.get(i);
            if (component.overlayTexture != blendingEnabled) continue;
            if (component.textObject != null) {
                boolean addSuffix;
                textTransform.set(transform);
                textTransform.applyTranslation(0.0, 0.0, (float)i * 2.0E-4f);
                double totalScaling = slotScale * component.scale;
                textTransform.applyScaling(totalScaling, totalScaling, totalScaling);
                InstrumentSwitchbox switchbox = entity.instrumentComponentSwitchboxes.get(component);
                if (switchbox != null && !switchbox.runSwitchbox(partialTicks, true)) continue;
                int variablePartNumber = AEntityF_Multipart.getVariableNumber(component.textObject.variableName);
                boolean bl = addSuffix = variablePartNumber == -1 && (component.textObject.variableName.startsWith("engine_") || component.textObject.variableName.startsWith("propeller_") || component.textObject.variableName.startsWith("gun_") || component.textObject.variableName.startsWith("seat_"));
                if (addSuffix) {
                    String oldName = component.textObject.variableName;
                    component.textObject.variableName = component.textObject.variableName + "_" + partNumber;
                    RenderText.draw3DText(entity.getAnimatedTextVariableValue(component.textObject, partialTicks), entity, textTransform, component.textObject, true);
                    component.textObject.variableName = oldName;
                    continue;
                }
                RenderText.draw3DText(entity.getAnimatedTextVariableValue(component.textObject, partialTicks), entity, textTransform, component.textObject, true);
                continue;
            }
            renderObject = entity.instrumentRenderables.get(slot).get(i);
            RenderInstrument.renderObject.isTranslucent = component.overlayTexture;
            RenderInstrument.renderObject.texture = "/assets/" + ((JSONInstrument)instrument.definition).packID + "/textures/" + ((JSONInstrument)instrument.definition).textureName;
            RenderInstrument.renderObject.transform.set(transform);
            RenderInstrument.renderObject.transform.applyTranslation(0.0, 0.0, (float)i * 2.0E-4f);
            RenderInstrument.renderObject.transform.applyScaling(slotScale, slotScale, slotScale);
            bottomLeft.set((double)(-component.textureWidth) / 2.0, (double)component.textureHeight / 2.0, 0.0);
            topLeft.set((double)(-component.textureWidth) / 2.0, (double)(-component.textureHeight) / 2.0, 0.0);
            topRight.set((double)component.textureWidth / 2.0, (double)(-component.textureHeight) / 2.0, 0.0);
            bottomRight.set((double)component.textureWidth / 2.0, (double)component.textureHeight / 2.0, 0.0);
            InstrumentSwitchbox switchbox = entity.instrumentComponentSwitchboxes.get(component);
            if (switchbox != null && !switchbox.runSwitchbox(partialTicks, true)) continue;
            bottomLeft.add(component.textureXCenter, component.textureYCenter, 0.0);
            topLeft.add(component.textureXCenter, component.textureYCenter, 0.0);
            topRight.add(component.textureXCenter, component.textureYCenter, 0.0);
            bottomRight.add(component.textureXCenter, component.textureYCenter, 0.0);
            bottomLeft.scale(9.765625E-4);
            topLeft.scale(9.765625E-4);
            topRight.scale(9.765625E-4);
            bottomRight.scale(9.765625E-4);
            RenderInstrument.renderObject.transform.applyTranslation(component.xCenter, -component.yCenter, 0.0);
            RenderInstrument.renderObject.transform.applyScaling(component.scale, component.scale, component.scale);
            RenderInstrument.renderObject.worldLightValue = entity.worldLightValue;
            RenderInstrument.renderObject.ignoreWorldShading = onGUI;
            RenderInstrument.renderObject.disableLighting = component.lightUpTexture && lightsOn && (Boolean)ConfigSystem.client.renderingSettings.brightLights.value != false;
            RenderInstrument.renderComponentFromState(component);
        }
    }

    private static void renderComponentFromState(JSONInstrument.JSONInstrumentComponent component) {
        for (int i = 0; i < instrumentSingleComponentPoints.length; ++i) {
            float[] vertex = instrumentSingleComponentPoints[i];
            switch (i) {
                case 0: 
                case 3: {
                    vertex[5] = component.textureWidth / 2;
                    vertex[6] = -component.textureHeight / 2;
                    vertex[3] = (float)RenderInstrument.bottomRight.x;
                    vertex[4] = (float)RenderInstrument.bottomRight.y;
                    break;
                }
                case 1: {
                    vertex[5] = component.textureWidth / 2;
                    vertex[6] = component.textureHeight / 2;
                    vertex[3] = (float)RenderInstrument.topRight.x;
                    vertex[4] = (float)RenderInstrument.topRight.y;
                    break;
                }
                case 2: 
                case 4: {
                    vertex[5] = -component.textureWidth / 2;
                    vertex[6] = component.textureHeight / 2;
                    vertex[3] = (float)RenderInstrument.topLeft.x;
                    vertex[4] = (float)RenderInstrument.topLeft.y;
                    break;
                }
                case 5: {
                    vertex[5] = -component.textureWidth / 2;
                    vertex[6] = -component.textureHeight / 2;
                    vertex[3] = (float)RenderInstrument.bottomLeft.x;
                    vertex[4] = (float)RenderInstrument.bottomLeft.y;
                }
            }
            vertex[2] = 1.0f;
            RenderInstrument.renderObject.vertices.put(vertex);
        }
        RenderInstrument.renderObject.vertices.flip();
        renderObject.render(null);
    }

    public static class InstrumentSwitchbox
    extends AnimationSwitchbox {
        private final JSONInstrument.JSONInstrumentComponent component;

        public InstrumentSwitchbox(AEntityD_Definable<?> entity, JSONInstrument.JSONInstrumentComponent component) {
            super(entity, component.animations, null);
            this.component = component;
        }

        private String convertAnimationPartNumber(DurationDelayClock clock) {
            boolean addSuffix;
            int variablePartNumber = AEntityF_Multipart.getVariableNumber(clock.animation.variable);
            boolean bl = addSuffix = variablePartNumber == -1 && !(this.entity instanceof APart) && (clock.animation.variable.startsWith("engine_") || clock.animation.variable.startsWith("propeller_") || clock.animation.variable.startsWith("gun_") || clock.animation.variable.startsWith("seat_"));
            if (partNumber == 0 && addSuffix) {
                partNumber = 1;
            }
            String oldVariable = clock.animation.variable;
            if (addSuffix) {
                clock.animation.variable = clock.animation.variable + "_" + partNumber;
            }
            return oldVariable;
        }

        @Override
        public void runTranslation(DurationDelayClock clock, float partialTicks) {
            String oldVariable = this.convertAnimationPartNumber(clock);
            double xTranslation = this.entity.getAnimatedVariableValue(clock, clock.animation.axis.x, partialTicks);
            double yTranslation = this.entity.getAnimatedVariableValue(clock, clock.animation.axis.y, partialTicks);
            clock.animation.variable = oldVariable;
            if (this.component.extendWindow) {
                if (clock.animation.axis.x < 0.0) {
                    bottomLeft.x += xTranslation;
                    topLeft.x += xTranslation;
                } else if (clock.animation.axis.x > 0.0) {
                    topRight.x += xTranslation;
                    bottomRight.x += xTranslation;
                }
                if (clock.animation.axis.y < 0.0) {
                    bottomLeft.y += yTranslation;
                    bottomRight.y += yTranslation;
                } else if (clock.animation.axis.y > 0.0) {
                    topLeft.y += yTranslation;
                    topRight.y += yTranslation;
                }
            } else if (this.component.moveComponent) {
                renderObject.transform.applyTranslation(xTranslation, yTranslation, 0.0);
            } else if (this.component.textObject != null) {
                textTransform.applyTranslation(xTranslation, yTranslation, 0.0);
            } else {
                if (clock.animation.axis.x != 0.0) {
                    bottomLeft.x += xTranslation;
                    topLeft.x += xTranslation;
                    topRight.x += xTranslation;
                    bottomRight.x += xTranslation;
                }
                if (clock.animation.axis.y != 0.0) {
                    bottomLeft.y += yTranslation;
                    topLeft.y += yTranslation;
                    topRight.y += yTranslation;
                    bottomRight.y += yTranslation;
                }
            }
        }

        @Override
        public void runRotation(DurationDelayClock clock, float partialTicks) {
            String oldVariable = this.convertAnimationPartNumber(clock);
            double variableValue = -this.entity.getAnimatedVariableValue(clock, clock.animation.axis.z, partialTicks);
            clock.animation.variable = oldVariable;
            if (this.component.rotateWindow) {
                bottomLeft.add(clock.animation.centerPoint);
                topLeft.add(clock.animation.centerPoint);
                topRight.add(clock.animation.centerPoint);
                bottomRight.add(clock.animation.centerPoint);
                helperRotation.angles.set(0.0, 0.0, variableValue);
                bottomLeft.rotate(helperRotation);
                topLeft.rotate(helperRotation);
                topRight.rotate(helperRotation);
                bottomRight.rotate(helperRotation);
                bottomLeft.subtract(clock.animation.centerPoint);
                topLeft.subtract(clock.animation.centerPoint);
                topRight.subtract(clock.animation.centerPoint);
                bottomRight.subtract(clock.animation.centerPoint);
            } else if (this.component.textObject != null) {
                textTransform.applyTranslation((double)this.component.xCenter + clock.animation.centerPoint.x, -((double)this.component.yCenter + clock.animation.centerPoint.y), 0.0);
                helperRotationMatrix.setToAxisAngle(0.0, 0.0, 1.0, variableValue);
                textTransform.applyRotation(helperRotationMatrix);
                textTransform.applyTranslation(-((double)this.component.xCenter + clock.animation.centerPoint.x), (double)this.component.yCenter + clock.animation.centerPoint.y, 0.0);
            } else {
                renderObject.transform.applyTranslation((double)this.component.xCenter + clock.animation.centerPoint.x, -((double)this.component.yCenter + clock.animation.centerPoint.y), 0.0);
                helperRotationMatrix.setToAxisAngle(0.0, 0.0, 1.0, variableValue);
                renderObject.transform.applyRotation(helperRotationMatrix);
                renderObject.transform.applyTranslation(-((double)this.component.xCenter + clock.animation.centerPoint.x), (double)this.component.yCenter + clock.animation.centerPoint.y, 0.0);
            }
        }
    }
}

