/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.entities.instances.EntityRadio;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.AGUIComponent;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketRadioStateChange;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.sound.RadioManager;

public class GUIRadio
extends AGUIBase {
    private GUIComponentButton offButton;
    private GUIComponentButton localButton;
    private GUIComponentButton remoteButton;
    private GUIComponentButton serverButton;
    private GUIComponentButton orderedButton;
    private GUIComponentButton shuffleButton;
    private GUIComponentButton setButton;
    private GUIComponentButton equalizerButton;
    private GUIComponentButton equalizerBackButton;
    private GUIComponentButton equalizerResetButton;
    private GUIComponentButton volUpButton;
    private GUIComponentButton volDnButton;
    private final List<GUIComponentButton> presetButtons = new ArrayList<GUIComponentButton>();
    private final List<GUIComponentButton> equalizerButtons = new ArrayList<GUIComponentButton>();
    private final List<GUIComponentCutout> equalizerSliderBands = new ArrayList<GUIComponentCutout>();
    private final List<GUIComponentCutout> equalizerSliders = new ArrayList<GUIComponentCutout>();
    private GUIComponentTextBox stationDisplay;
    private GUIComponentTextBox volumeDisplay;
    private final EntityRadio radio;
    private final int bandsToSkip;
    private final int bandsToShow;
    private final int bandButtonSize;
    private boolean equalizerMode = false;
    private boolean teachMode = false;

    public GUIRadio(EntityRadio radio) {
        this.radio = radio;
        this.bandsToSkip = 4;
        this.bandsToShow = 32 / this.bandsToSkip;
        this.bandButtonSize = 20;
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.offButton = new GUIComponentButton(this.guiLeft + 20, this.guiTop + 25, 55, 15, "OFF"){

            @Override
            public void onClicked(boolean leftSide) {
                InterfaceManager.packetInterface.sendToServer(new PacketRadioStateChange(GUIRadio.this.radio));
                GUIRadio.this.teachMode = false;
            }
        };
        this.addComponent(this.offButton);
        this.addComponent(new GUIComponentLabel(this.offButton.constructedX + this.offButton.width / 2, this.offButton.constructedY - 10, ColorRGB.BLACK, "SOURCE", RenderText.TextAlignment.CENTERED, 1.0f).setComponent(this.offButton));
        this.localButton = new GUIComponentButton(this.offButton.constructedX, this.offButton.constructedY + this.offButton.height, this.offButton.width, this.offButton.height, "PC"){

            @Override
            public void onClicked(boolean leftSide) {
                InterfaceManager.packetInterface.sendToServer(new PacketRadioStateChange(GUIRadio.this.radio, RadioManager.RadioSources.LOCAL));
                GUIRadio.this.teachMode = false;
            }
        };
        this.addComponent(this.localButton);
        this.remoteButton = new GUIComponentButton(this.offButton.constructedX, this.localButton.constructedY + this.localButton.height, this.offButton.width, this.offButton.height, "INTERNET"){

            @Override
            public void onClicked(boolean leftSide) {
                InterfaceManager.packetInterface.sendToServer(new PacketRadioStateChange(GUIRadio.this.radio, RadioManager.RadioSources.INTERNET));
                GUIRadio.this.teachMode = false;
            }
        };
        this.addComponent(this.remoteButton);
        this.serverButton = new GUIComponentButton(this.offButton.constructedX, this.remoteButton.constructedY + this.remoteButton.height, this.offButton.width, this.offButton.height, "SERVER"){

            @Override
            public void onClicked(boolean leftSide) {
                InterfaceManager.packetInterface.sendToServer(new PacketRadioStateChange(GUIRadio.this.radio, RadioManager.RadioSources.SERVER));
                GUIRadio.this.teachMode = false;
            }
        };
        this.addComponent(this.serverButton);
        this.orderedButton = new GUIComponentButton(this.offButton.constructedX + this.offButton.width, this.offButton.constructedY, this.offButton.width, this.offButton.height, "ORDERED"){

            @Override
            public void onClicked(boolean leftSide) {
                ((GUIRadio)GUIRadio.this).orderedButton.enabled = false;
                ((GUIRadio)GUIRadio.this).shuffleButton.enabled = true;
            }
        };
        this.addComponent(this.orderedButton);
        this.shuffleButton = new GUIComponentButton(this.orderedButton.constructedX, this.orderedButton.constructedY + this.orderedButton.height, this.orderedButton.width, this.orderedButton.height, "SHUFFLE"){

            @Override
            public void onClicked(boolean leftSide) {
                ((GUIRadio)GUIRadio.this).orderedButton.enabled = true;
                ((GUIRadio)GUIRadio.this).shuffleButton.enabled = false;
            }
        };
        this.addComponent(this.shuffleButton);
        this.orderedButton.enabled = false;
        this.setButton = new GUIComponentButton(this.shuffleButton.constructedX, this.shuffleButton.constructedY + this.shuffleButton.height, this.shuffleButton.width, this.shuffleButton.height, "SET URL"){

            @Override
            public void onClicked(boolean leftSide) {
                if (GUIRadio.this.teachMode) {
                    GUIRadio.this.teachMode = false;
                    GUIRadio.this.stationDisplay.setText("");
                } else {
                    InterfaceManager.packetInterface.sendToServer(new PacketRadioStateChange(GUIRadio.this.radio));
                    GUIRadio.this.teachMode = true;
                    GUIRadio.this.stationDisplay.setText("Type or paste a URL (CTRL+V).\nThen press press a preset button.");
                    ((GUIRadio)GUIRadio.this).stationDisplay.focused = true;
                }
            }
        };
        this.addComponent(this.setButton);
        this.volUpButton = new GUIComponentButton(this.guiLeft + 205, this.offButton.constructedY, 30, 20, "UP"){

            @Override
            public void onClicked(boolean leftSide) {
                InterfaceManager.packetInterface.sendToServer(new PacketRadioStateChange(GUIRadio.this.radio, ((GUIRadio)GUIRadio.this).radio.volume + 1));
            }
        };
        this.addComponent(this.volUpButton);
        this.volDnButton = new GUIComponentButton(this.volUpButton.constructedX, this.volUpButton.constructedY + this.volUpButton.height, this.volUpButton.width, 20, "DN"){

            @Override
            public void onClicked(boolean leftSide) {
                InterfaceManager.packetInterface.sendToServer(new PacketRadioStateChange(GUIRadio.this.radio, ((GUIRadio)GUIRadio.this).radio.volume - 1));
            }
        };
        this.addComponent(this.volDnButton);
        this.volumeDisplay = new GUIComponentTextBox(this.guiLeft + 180, this.volUpButton.constructedY, 25, 40, "", ColorRGB.WHITE, 32);
        this.addComponent(this.volumeDisplay);
        this.equalizerButton = new GUIComponentButton(this.volumeDisplay.constructedX, this.volumeDisplay.constructedY + this.volumeDisplay.height, this.volumeDisplay.width + this.volDnButton.width, this.volUpButton.height, "EQ"){

            @Override
            public void onClicked(boolean leftSide) {
                GUIRadio.this.equalizerMode = true;
            }
        };
        this.addComponent(this.equalizerButton);
        this.addComponent(new GUIComponentLabel(this.volumeDisplay.constructedX + this.volumeDisplay.width, this.volumeDisplay.constructedY - 10, ColorRGB.BLACK, "VOLUME", RenderText.TextAlignment.CENTERED, 1.0f).setComponent(this.volUpButton));
        this.presetButtons.clear();
        int x = 25;
        for (int i = 1; i < 7; i = (int)((byte)(i + 1))) {
            this.presetButtons.add(new GUIComponentButton(this.guiLeft + x, this.guiTop + 155, 35, 20, String.valueOf(i)){

                @Override
                public void onClicked(boolean leftSide) {
                    GUIRadio.this.presetButtonClicked(this);
                }
            });
            this.addComponent(this.presetButtons.get(i - 1));
            x += 35;
        }
        this.stationDisplay = new GUIComponentTextBox(this.guiLeft + 20, this.guiTop + 95, 220, 55, this.radio.displayText, ColorRGB.WHITE, 150);
        this.addComponent(this.stationDisplay);
        this.equalizerBackButton = new GUIComponentButton(this.guiLeft + 40, this.guiTop + 162, 80, 20, "BACK"){

            @Override
            public void onClicked(boolean leftSide) {
                GUIRadio.this.equalizerMode = false;
            }
        };
        this.addComponent(this.equalizerBackButton);
        this.equalizerResetButton = new GUIComponentButton(this.guiLeft + this.getWidth() - 80 - 40, this.guiTop + 162, 80, 20, "RESET"){

            @Override
            public void onClicked(boolean leftSide) {
                for (int i = 0; i < ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.getBandCount(); ++i) {
                    ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.setBand(i, 0.0f);
                }
            }
        };
        this.addComponent(this.equalizerResetButton);
        this.equalizerButtons.clear();
        this.equalizerSliderBands.clear();
        this.equalizerSliders.clear();
        int startingOffset = (this.getWidth() - (this.bandsToShow - 1) * this.bandButtonSize) / 2;
        for (int i = 0; i < this.bandsToShow; ++i) {
            int centerXOffset = this.guiLeft + startingOffset + this.bandButtonSize * i;
            GUIComponentEqualizerButton bandUpButton = new GUIComponentEqualizerButton(centerXOffset - this.bandButtonSize / 2, this.guiTop + 20, true);
            GUIComponentEqualizerButton bandDownButton = new GUIComponentEqualizerButton(centerXOffset - this.bandButtonSize / 2, this.guiTop + 140, false);
            GUIComponentCutout sliderBand = new GUIComponentCutout(centerXOffset - 2, bandUpButton.constructedY + bandUpButton.height, 4, 100, 236, 236, 20, 20);
            GUIComponentCutout slider = new GUIComponentCutout(centerXOffset - 4, this.guiTop + 90 - 4, 8, 8, 236, 196, 20, 20);
            this.equalizerButtons.add(bandUpButton);
            this.equalizerButtons.add(bandDownButton);
            this.equalizerSliderBands.add(sliderBand);
            this.equalizerSliders.add(slider);
            this.addComponent(bandUpButton);
            this.addComponent(bandDownButton);
            this.addComponent(sliderBand);
            this.addComponent(slider);
        }
    }

    @Override
    public void setStates() {
        super.setStates();
        for (AGUIComponent component : this.components) {
            component.visible = !this.equalizerMode;
        }
        this.background.visible = true;
        this.offButton.enabled = this.radio.currentStation != null;
        this.localButton.enabled = !this.radio.getSource().equals((Object)RadioManager.RadioSources.LOCAL);
        this.remoteButton.enabled = !this.radio.getSource().equals((Object)RadioManager.RadioSources.INTERNET);
        this.serverButton.visible = false;
        this.equalizerButton.enabled = !this.equalizerMode && !this.radio.getSource().equals((Object)RadioManager.RadioSources.INTERNET) && this.radio.currentStation != null && this.radio.currentStation.equalizer != null;
        this.setButton.enabled = !this.equalizerMode && this.radio.getSource().equals((Object)RadioManager.RadioSources.INTERNET);
        this.stationDisplay.enabled = this.teachMode;
        if (!this.teachMode) {
            if (this.radio.currentStation == null) {
                this.stationDisplay.setText(this.radio.displayText);
            } else {
                this.stationDisplay.setText(this.radio.currentStation.displayText);
            }
        }
        this.volumeDisplay.enabled = false;
        this.volumeDisplay.setText("VOL        " + this.radio.volume);
        this.volUpButton.enabled = this.radio.volume < 10;
        this.volDnButton.enabled = this.radio.volume > 1;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.presetButtons.get((int)i).enabled = this.radio.preset - 1 != i;
        }
        this.equalizerBackButton.visible = this.equalizerMode;
        this.equalizerResetButton.visible = this.equalizerMode;
        for (GUIComponentButton button : this.equalizerButtons) {
            button.visible = this.equalizerMode;
        }
        for (GUIComponentCutout band : this.equalizerSliderBands) {
            band.visible = this.equalizerMode;
        }
        for (GUIComponentCutout slider : this.equalizerSliders) {
            slider.visible = this.equalizerMode;
            if (!this.equalizerMode) continue;
            slider.position.y = (float)(-slider.constructedY) + this.radio.currentStation.equalizer.getBand(this.bandsToSkip * this.equalizerSliders.indexOf(slider)) * 46.0f;
        }
    }

    @Override
    protected boolean canStayOpen() {
        return super.canStayOpen() && this.radio.isValid;
    }

    private void presetButtonClicked(GUIComponentButton buttonClicked) {
        int presetClicked = this.presetButtons.indexOf(buttonClicked);
        if (this.teachMode) {
            RadioManager.setLocalStationURL(this.stationDisplay.getText(), presetClicked);
            this.stationDisplay.setText("Station set to preset " + (presetClicked + 1));
            this.teachMode = false;
        } else if (this.radio.getSource().equals((Object)RadioManager.RadioSources.LOCAL)) {
            InterfaceManager.packetInterface.sendToServer(new PacketRadioStateChange(this.radio, presetClicked + 1, this.orderedButton.enabled));
        } else {
            InterfaceManager.packetInterface.sendToServer(new PacketRadioStateChange(this.radio, presetClicked + 1, RadioManager.getLocalStationURL(presetClicked + 1)));
        }
    }

    private class GUIComponentEqualizerButton
    extends GUIComponentButton {
        private final boolean increment;

        public GUIComponentEqualizerButton(int x, int y, boolean increment) {
            super(x, y, GUIRadio.this.bandButtonSize, GUIRadio.this.bandButtonSize, increment ? "/\\" : "\\/");
            this.increment = increment;
        }

        @Override
        public void onClicked(boolean leftSide) {
            int bandIndex = GUIRadio.this.bandsToSkip * (GUIRadio.this.equalizerButtons.indexOf(this) / 2);
            float level = ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.getBand(bandIndex);
            if (this.increment ? level < 0.9f : level > -0.9f) {
                int i;
                ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.setBand(bandIndex, level += this.increment ? 0.2f : -0.2f);
                if (bandIndex + GUIRadio.this.bandsToSkip < ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.getBandCount()) {
                    int nextBandIndex = bandIndex + GUIRadio.this.bandsToSkip;
                    float nextBandLevel = ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.getBand(nextBandIndex);
                    for (i = 1; i < GUIRadio.this.bandsToSkip; ++i) {
                        ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.setBand(bandIndex + i, level + (float)i * (nextBandLevel - level) / (float)GUIRadio.this.bandsToSkip);
                    }
                }
                if (bandIndex - GUIRadio.this.bandsToSkip >= 0) {
                    int priorBandIndex = bandIndex - GUIRadio.this.bandsToSkip;
                    float priorBandLevel = ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.getBand(priorBandIndex);
                    for (i = 1; i < GUIRadio.this.bandsToSkip; ++i) {
                        ((GUIRadio)GUIRadio.this).radio.currentStation.equalizer.setBand(bandIndex - i, level - (float)i * (level - priorBandLevel) / (float)GUIRadio.this.bandsToSkip);
                    }
                }
            }
        }
    }
}

