/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.AGUIComponent;
import minecrafttransportsimulator.rendering.AModelParser;
import minecrafttransportsimulator.rendering.RenderableObject;

public class GUIComponent3DModel
extends AGUIComponent {
    private static final Map<String, RenderableObject> modelParsedObjects = new HashMap<String, RenderableObject>();
    private static final Map<String, Float> modelScalingFactors = new HashMap<String, Float>();
    private static final RotationMatrix ISOMETRIC_ROTATION = new RotationMatrix().setToAxisAngle(0.0, 1.0, 0.0, -45.0).multiply(new RotationMatrix().setToAxisAngle(0.70712, 0.0, -0.70712, 35.264));
    public final float scaleFactor;
    public final boolean isometric;
    public final boolean staticScaling;
    public boolean spin;
    public float scale;
    public String modelLocation;
    public String textureLocation;

    public GUIComponent3DModel(int x, int y, float scaleFactor, boolean isometric, boolean spin, boolean staticScaling) {
        super(x, y, 0, 0);
        this.scaleFactor = scaleFactor;
        this.isometric = isometric;
        this.spin = spin;
        this.staticScaling = staticScaling;
    }

    @Override
    public int getZOffset() {
        return 100;
    }

    @Override
    public void render(AGUIBase gui, int mouseX, int mouseY, boolean renderBright, boolean renderLitTexture, boolean blendingEnabled, float partialTicks) {
        if (!blendingEnabled && this.modelLocation != null) {
            if (!modelParsedObjects.containsKey(this.modelLocation)) {
                List<RenderableObject> parsedObjects = AModelParser.parseModel(this.modelLocation);
                parsedObjects.removeIf(object -> object.name.toLowerCase(Locale.ROOT).contains("window") || object.name.startsWith("#"));
                float minX = 999.0f;
                float maxX = -999.0f;
                float minY = 999.0f;
                float maxY = -999.0f;
                float minZ = 999.0f;
                float maxZ = -999.0f;
                int totalVertices = 0;
                for (RenderableObject parsedObject : parsedObjects) {
                    totalVertices += parsedObject.vertices.capacity();
                    for (int i = 0; i < parsedObject.vertices.capacity(); i += 8) {
                        float xCoord = parsedObject.vertices.get(i + 5);
                        float yCoord = parsedObject.vertices.get(i + 6);
                        float zCoord = parsedObject.vertices.get(i + 7);
                        minX = Math.min(minX, xCoord);
                        maxX = Math.max(maxX, xCoord);
                        minY = Math.min(minY, yCoord);
                        maxY = Math.max(maxY, yCoord);
                        minZ = Math.min(minZ, zCoord);
                        maxZ = Math.max(maxZ, zCoord);
                    }
                }
                float globalMax = Math.max(Math.max(maxX - minX, maxY - minY), maxZ - minZ);
                modelScalingFactors.put(this.modelLocation, Float.valueOf((double)globalMax > 1.5 ? 1.5f / globalMax : 1.0f));
                FloatBuffer totalModel = FloatBuffer.allocate(totalVertices);
                for (RenderableObject parsedObject : parsedObjects) {
                    totalModel.put(parsedObject.vertices);
                }
                totalModel.flip();
                RenderableObject combinedObject = new RenderableObject("model", this.textureLocation, ColorRGB.WHITE, totalModel, true);
                modelParsedObjects.put(this.modelLocation, combinedObject);
            }
            RenderableObject object2 = modelParsedObjects.get(this.modelLocation);
            object2.transform.resetTransforms();
            object2.transform.setTranslation(this.position);
            if (this.isometric) {
                object2.transform.applyRotation(ISOMETRIC_ROTATION);
            }
            if (this.spin) {
                object2.transform.applyRotation(new RotationMatrix().setToAxisAngle(0.0, 1.0, 0.0, 36L * System.currentTimeMillis() / 1000L % 360L));
            }
            if (!this.staticScaling) {
                this.scale = modelScalingFactors.get(this.modelLocation).floatValue();
            }
            double totalScale = this.scale * this.scaleFactor;
            object2.worldLightValue = gui.worldLightValue;
            object2.transform.applyScaling(totalScale, totalScale, totalScale);
            object2.texture = this.textureLocation;
            object2.ignoreWorldShading = true;
            object2.disableLighting = renderBright;
            object2.render(gui);
        }
    }

    public static void clearModelCaches(AGUIBase gui) {
        modelParsedObjects.values().forEach(renderable -> renderable.destroy(gui));
        modelParsedObjects.clear();
    }
}

