/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.guis.components.AGUIComponent;
import minecrafttransportsimulator.guis.components.GUIComponent3DModel;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.guis.instances.GUIOverlay;
import minecrafttransportsimulator.mcinterface.InterfaceManager;

public abstract class AGUIBase {
    public static final int STANDARD_GUI_WIDTH = 256;
    public static final int STANDARD_GUI_HEIGHT = 192;
    public static final String STANDARD_TEXTURE_NAME = "mts:textures/guis/standard.png";
    protected static final int STANDARD_COLOR_WIDTH = 20;
    protected static final int STANDARD_COLOR_HEIGHT = 20;
    protected static final int STANDARD_COLOR_WIDTH_OFFSET = 236;
    protected static final int STANDARD_RED_HEIGHT_OFFSET = 196;
    protected static final int STANDARD_YELLOW_HEIGHT_OFFSET = 216;
    protected static final int STANDARD_BLACK_HEIGHT_OFFSET = 236;
    protected GUIComponentCutout background;
    public final List<AGUIComponent> components = new ArrayList<AGUIComponent>();
    public static final ConcurrentLinkedQueue<AGUIBase> activeGUIs = new ConcurrentLinkedQueue();
    public static AGUIBase activeInputGUI;
    protected int worldLightValue;
    protected int screenWidth;
    protected int screenHeight;
    protected int guiLeft;
    protected int guiTop;
    protected GUIComponentButton lastButtonClicked;
    public boolean editingText;

    public AGUIBase() {
        activeGUIs.forEach(gui -> {
            if (gui.getClass() == this.getClass()) {
                gui.close();
            }
        });
        activeGUIs.add(this);
        if (this.capturesPlayer()) {
            activeInputGUI = this;
            InterfaceManager.clientInterface.setActiveGUI(this);
            InterfaceManager.inputInterface.setGUIControls(true);
        }
    }

    public void setupComponentsInit(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.guiLeft = (screenWidth - this.getWidth()) / 2;
        this.guiTop = this.renderFlushBottom() ? screenHeight - this.getHeight() : (screenHeight - this.getHeight()) / 2;
        this.setupComponents();
    }

    public void setupComponents() {
        this.components.clear();
        if (this.renderBackgroundFullTexture()) {
            this.background = new GUIComponentCutout(this.guiLeft, this.guiTop, this.getWidth(), this.getHeight());
            this.addComponent(this.background);
        } else {
            this.background = new GUIComponentCutout(this.guiLeft, this.guiTop, this.getWidth(), this.getHeight(), 0, 0, this.getWidth(), this.getHeight());
            this.addComponent(this.background);
        }
    }

    public void addRenderToBuffer(FloatBuffer buffer, int offsetX, int offsetY, int width, int height, float u, float v, float U, float V, int textureWidth, int textureHeight) {
        u /= (float)textureWidth;
        U /= (float)textureWidth;
        v /= (float)textureHeight;
        V /= (float)textureHeight;
        for (int i = 0; i < 6; ++i) {
            buffer.put(0.0f);
            buffer.put(0.0f);
            buffer.put(1.0f);
            switch (i) {
                case 0: 
                case 3: {
                    buffer.put(U);
                    buffer.put(V);
                    buffer.put(offsetX + width);
                    buffer.put(offsetY - height);
                    break;
                }
                case 1: {
                    buffer.put(U);
                    buffer.put(v);
                    buffer.put(offsetX + width);
                    buffer.put(offsetY);
                    break;
                }
                case 2: 
                case 4: {
                    buffer.put(u);
                    buffer.put(v);
                    buffer.put(offsetX);
                    buffer.put(offsetY);
                    break;
                }
                case 5: {
                    buffer.put(u);
                    buffer.put(V);
                    buffer.put(offsetX);
                    buffer.put(offsetY - height);
                }
            }
            buffer.put(0.0f);
        }
    }

    public void setStates() {
        this.background.visible = this.renderBackground();
        if (!this.canStayOpen()) {
            this.close();
        }
    }

    public boolean onClick(int mouseX, int mouseY) {
        for (AGUIComponent component : this.components) {
            GUIComponentButton button;
            if (!(component instanceof GUIComponentButton) || !(button = (GUIComponentButton)component).canClick(mouseX, mouseY)) continue;
            button.onClicked(mouseX <= button.constructedX + button.width / 2);
            this.lastButtonClicked = button;
            return true;
        }
        this.editingText = false;
        for (AGUIComponent component : this.components) {
            if (!(component instanceof GUIComponentTextBox)) continue;
            GUIComponentTextBox box = (GUIComponentTextBox)component;
            box.updateFocus(mouseX, mouseY);
            if (!box.focused) continue;
            this.editingText = true;
        }
        return false;
    }

    public void onRelease() {
        if (this.lastButtonClicked != null) {
            this.lastButtonClicked.onReleased();
            this.lastButtonClicked = null;
        }
    }

    public final void render(int mouseX, int mouseY, boolean blendingEnabled, float partialTicks) {
        boolean ignoreLightState;
        if (!blendingEnabled) {
            this.setStates();
        }
        if (!(ignoreLightState = this.getGUILightMode().equals((Object)GUILightingMode.NONE))) {
            this.worldLightValue = this.getGUILightSource().worldLightValue;
        }
        for (AGUIComponent aGUIComponent : this.components) {
            if (!aGUIComponent.visible || aGUIComponent instanceof GUIComponentInstrument) continue;
            aGUIComponent.render(this, mouseX, mouseY, ignoreLightState, false, blendingEnabled, partialTicks);
        }
        if (blendingEnabled && this.getGUILightMode().equals((Object)GUILightingMode.LIT)) {
            for (AGUIComponent aGUIComponent : this.components) {
                if (!aGUIComponent.visible || aGUIComponent instanceof GUIComponentInstrument || aGUIComponent instanceof GUIComponentItem) continue;
                aGUIComponent.render(this, mouseX, mouseY, true, true, blendingEnabled, partialTicks);
            }
        }
        if (!blendingEnabled) {
            boolean isTextLit = !this.getGUILightMode().equals((Object)GUILightingMode.DARK);
            for (AGUIComponent component : this.components) {
                if (!component.visible || component.text == null) continue;
                component.renderText(isTextLit, this.worldLightValue);
            }
        }
        for (AGUIComponent aGUIComponent : this.components) {
            if (!aGUIComponent.visible || !(aGUIComponent instanceof GUIComponentInstrument)) continue;
            aGUIComponent.render(this, mouseX, mouseY, false, false, blendingEnabled, partialTicks);
        }
        if (!blendingEnabled) {
            for (AGUIComponent aGUIComponent : this.components) {
                if (!aGUIComponent.visible || !aGUIComponent.isMouseInBounds(mouseX, mouseY)) continue;
                aGUIComponent.renderTooltip(this, mouseX, mouseY);
            }
        }
    }

    public void close() {
        if (activeGUIs.contains(this)) {
            activeGUIs.remove(this);
            if (this.capturesPlayer()) {
                activeInputGUI = null;
                InterfaceManager.clientInterface.closeGUI();
                InterfaceManager.inputInterface.setGUIControls(false);
            }
            GUIComponent3DModel.clearModelCaches(this);
        }
    }

    public static void closeIfOpen(Class<? extends AGUIBase> guiClass) {
        AGUIBase guiToClose = null;
        for (AGUIBase gui : activeGUIs) {
            if (!gui.getClass().equals(guiClass)) continue;
            guiToClose = gui;
            break;
        }
        if (guiToClose != null) {
            guiToClose.close();
        }
    }

    protected boolean renderBackground() {
        return true;
    }

    protected boolean renderBackgroundFullTexture() {
        return false;
    }

    protected GUILightingMode getGUILightMode() {
        return GUILightingMode.NONE;
    }

    protected AEntityC_Renderable getGUILightSource() {
        return null;
    }

    public boolean pauseOnOpen() {
        return false;
    }

    protected boolean canStayOpen() {
        return InterfaceManager.clientInterface.getClientPlayer().isValid();
    }

    public boolean capturesPlayer() {
        return true;
    }

    public int getWidth() {
        return 256;
    }

    public int getHeight() {
        return 192;
    }

    public boolean renderFlushBottom() {
        return false;
    }

    public boolean renderTranslucent() {
        return false;
    }

    protected final int getTextureWidth() {
        return this.getWidth() <= 256 ? 256 : (this.getWidth() <= 512 ? 512 : (this.getWidth() <= 1024 ? 1024 : 2048));
    }

    protected final int getTextureHeight() {
        return this.getHeight() <= 256 ? 256 : (this.getHeight() <= 512 ? 512 : (this.getHeight() <= 1024 ? 1024 : 2048));
    }

    protected String getTexture() {
        return STANDARD_TEXTURE_NAME;
    }

    protected void addComponent(AGUIComponent component) {
        this.components.add(component);
    }

    protected static boolean inClockPeriod(int totalPeriod, int onPeriod) {
        return (double)System.currentTimeMillis() * 0.02 % (double)totalPeriod <= (double)onPeriod;
    }

    static {
        new GUIOverlay();
    }

    protected static enum GUILightingMode {
        NONE,
        DARK,
        LIT;

    }
}

